//*****************************************************************
// file			: SQ7613_32PinPackage_startup.c
// version		: V1.1 2020/07/30
// brief		: startup program
// note			:
// Copyright(C)2020 iMQ Technology Inc.  All rights reserved     
//*****************************************************************

/* ---------------------- reference header files ------------------------------ */
#include <stdlib.h>
#include "SQ7613_SFR.h"


/* ---------------------- external symbol declaration ----------------------------- */
// (External Symbol Declaration) //
// symbols are initialized and defined in SQ7613.lcf (link command file)

extern unsigned int  _BaseSP;			// the starting address of the stacking pointer is generally defined as the the last address of the SRAM
extern unsigned int  _RAM_Top;		    // the first address of SRAM
extern unsigned int  _RAM_End;			// the last address of the SRAM

extern unsigned char _TDataAddr[];
extern unsigned char _TDataOrg[];
extern unsigned int  _TDataSize;
extern unsigned char _NDataAddr[];
extern unsigned char _NDataOrg[];
extern unsigned int  _NDataSize;


/*
 ******************************************************************************
 * NAME				: startup routine
 *-----------------------------------------------------------------------------
 * DESCRIPTION		: startup routine
 * PARAMETER		: -
 *
 * RETURN VALUE		: -
 *
 ******************************************************************************
 */


void STARTUP( void )
{
    
//============================================
// Memory Mapping 
//============================================
	DMCFG  	 = 0x50; 	// Code :0x8000~0xFFFF Map to Data: 0x8000~0xFFFF
	//DMCFG  = 0x40;	// Code :0x0000~0x7FFF Map to Data: 0x8000~0xFFFF
	//DMCFG  = 0x00;	// No Map

//============================================
// Disable Interrupt
//============================================
	__DI();			                       // disable all maskable interrupts      

//============================================
// Initial Registers
//============================================
	__WA = 0x00;
	__BC = 0x00;
	__DE = 0x00;
	__HL = 0x00;
	__IX = 0x00;
	__IY = 0x00;

//============================================
// Initial Setting
//============================================	
	__asm("CLR (0x08).5");

//============================================
// Initialize Stack Pointer
//============================================
	__asm(" LD SP,__BaseSP");

//============================================
// Reset PSW
//============================================
	__asm(" LD PSW,0x00");          // Clear status word

//============================================
// Clear RAM
//============================================
	__asm(" LD HL,__RAM_Top");
	__asm(" LD BC,__RAM_End - __RAM_Top");	
	__asm(" LD A,0x00");
	__asm("CLR_RAM:");
	__asm(" LD (HL),A");
	__asm(" INC HL");
	__asm(" DEC BC");
	__asm(" JRS F,CLR_RAM");		/* Clear the RAM */

//============================================
// Initialize of tiny_data section
//============================================
	__asm("	LD	IX,__TDataOrg");
	__asm("	LD	IY,__TDataAddr");
	__asm("	LD	A,__TDataSize");
	__asm("	DEC	A");
	__asm("	J	T,non_t_data");
	__asm("move_t_data:");
	__asm("	LD	C,(IX)");
	__asm("	LD	(IY),C");
	__asm("	INC	IX");
	__asm("	INC	IY");
	__asm("	DEC	A");
	__asm("	J	F,move_t_data");
	__asm("non_t_data:");

//============================================
// Initialize of near_data section
//============================================
	__asm("	LD	IX,__NDataOrg");
	__asm("	LD	IY,__NDataAddr");
	__asm("	LD	WA,__NDataSize");
	__asm("	DEC	WA");
	__asm("	J	T,non_n_data");
	__asm("move_n_data:");
	__asm("	LD	C,(IX)");
	__asm("	LD	(IY),C");
	__asm("	INC	IX");
	__asm("	INC	IY");
	__asm("	DEC	WA");
	__asm("	J	F,move_n_data");
	__asm("non_n_data:");

//==================================================
// Set UnPad Pin normal output LOW to avoid leakage
//==================================================

// 	Set Low
// 	P1.4~P1.7       0000 1111  0x0F
// 	P2.5,P2.6       1001 1111  0x9F
// 	P3.0            1111 1110  0xFE
// 	P4.0,P4.1,P4.6  1011 1100  0xBC
//	P5.0,P5.4		1110 1110  0xEE

	P1DO = P1DO & ( 0x0F ); // P1.4~P1.7 	  output low
	P2DO = P2DO & ( 0x9F ); // P2.5,P2.6 	  output low
	P3DO = P3DO & ( 0xFE ); // P3.0	  		  output low
	P4DO = P4DO & ( 0xBC ); // P4.0,P4.1,P4.6 output low
	P5DO = P5DO & ( 0xEE ); // P5.0,P5.4	  output low
//--------------------------------------------

// 	Set Output
// 	P1.4~P1.7       1111 0000  0xF0
// 	P2.5,P2.6       0110 0000  0x60
// 	P3.0            0000 0001  0x01
// 	P4.0,P4.1,P4.6  0100 0011  0x43
//	P5.0,P5.4		0001 0001  0x11

	P1OE = P1OE | ( 0xF0 ); // P1.4~P1.7 	  output
	P2OE = P2OE | ( 0x60 ); // P2.5,P2.6 	  output
	P3OE = P3OE | ( 0x01 ); // P3.0	  		  output
	P4OE = P4OE | ( 0x43 ); // P4.0,P4.1,P4.6 output
	P5OE = P5OE | ( 0x11 ); // P5.0,P5.4	  output

//============================================
// Jump to main
//============================================
	main();
	for (;;) {
		;
	}
}

