//*************************************************************************************
// file			: SQ7613_SPI_Flash_IS25LP080D.c
// version		: V1.0
// brief		: SPI_Flash_IS25LP080Drelated functions
// note			: related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char IS25LP_ReadState();
unsigned char Status_Data;

//*********************************************************************
// name			: IS25LP_ReadState()
// brief		: read IS25LP080D status
// note			: command 0x05
//*********************************************************************
unsigned char IS25LP_ReadState(){  
uchar retValue;

    P4DO_P3 = 0;                           // CS PIN Enable (low level)
    SIO_ByteSend(SIO_1,0x05);              // master transmits command 0x05
	retValue = SIO_ByteRead(SIO_1);        // get IS25LP080D status
    P4DO_P3 = 1;	                       // CS PIN Disable (high level)	
	return retValue;
}


//*********************************************************************
// name			: IS25LP_WaitBusy()
// brief		: while loop according to IS25LP080D status
// note			: 
//*********************************************************************
void IS25LP_WaitBusy(void){
uchar Status_Data;
uint  tWait_SIO;

	Status_Data = (IS25LP_ReadState() & 0x01); // Write In Progress bit(WIP)
    // WIP bit = "0" indicates the device is ready(default)
    // WIP bit = "1" indicates a write cycle is in progress and the device is busy

	while(Status_Data != 0x00)            // if WIP is not 0, it means device is busy
	{
		CLR_WDT;                           // clear the watchdog timer 
		
		tWait_SIO++;				       // waiting
		if( tWait_SIO>1200 ){		       // if you wait too long, the loop will be broken		
		
		break;
		}	
	}
}


//*********************************************************************
// name			: IS25LP_Write_Enable()
// brief		: enable write function of IS25LP080D
// note			: command 0x06
//*********************************************************************
void IS25LP_Write_Enable(void){
    P4DO_P3 = 0;                           // CS PIN Enable (low level)
    SIO_ByteSend(SIO_1,0x06);              //master transmits command 0x06
	SIO_ReservedStopWait(SIO_1);
    P4DO_P3 = 1;	                       // CS PIN Disable (high level)
    
}


//*********************************************************************
// name			: IS25LP_Write_Disable()
// brief		: disable write function of IS25LP080D
// note			: command 0x04
//*********************************************************************
void IS25LP_Write_Disable(void){
    P4DO_P3 = 0;                           // CS PIN Enable (low level)    
    SIO_ByteSend(SIO_1,0x04);			   // master transmits command 0x04
	SIO_ReservedStopWait(SIO_1);
    P4DO_P3 = 1;	                       // CS PIN Disable (high level)
}


