//*************************************************************************************
// file			: SQ7613_MAC.h
// version		: V1.1
// brief		: MAC header file
// note			: 
//**************************************************************************************
#ifndef _SQ7613_MAC_H__
#define _SQ7613_MAC_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned char MAC_Int_Flag;	// MAC interrupt flag


/* ---------------------- user-defined macros ------------------------------ */
#define MAC_signed   	1		// signed
#define MAC_unsigned 	0		// unsigned

#define MAC_sat    	1		// enable saturation mode
#define MAC_nosat  	0		// disable saturation mode

// MAC mode selection
#define MAC_Mode_Add     	0x00
#define MAC_Mode_Sub     	0x01
#define MAC_Mode_Mul     	0x02
#define MAC_Mode_CAddSum 	0x04
#define MAC_Mode_CSubSum 	0x05
#define MAC_Mode_CAddMul 	0x06
#define MAC_Mode_CSubMul 	0x07

//----------------------------------------------------------------
void MAC_Init();						// initialize MAC
void MAC_IntEnable();					// enable MAC interrupt
void __interrupt IntMAC(void);			// MAC interrupt service routine


#endif

