//*************************************************************************************
// file			: SQ7613_startup_LVD_SWRST.c
// version		: V1.01
// brief		: startup program
// note			: 
//**************************************************************************************

/*
 * --------------------------------------------------------------------------
 *   HEADER INCLUDE DEFINITIONS
 * --------------------------------------------------------------------------
 */
#include <stdlib.h>
#include "SQ7613_SFR.h"


/*
 * --------------------------------------------------------------------------
 *   MACRO DEFINITIONS
 * --------------------------------------------------------------------------
 */
 
extern unsigned int  _BaseSP;				/*the starting address of the stacking pointer is generally defined as the the last address of the SRAM*/
extern unsigned int  _RAM_Top;		    /*the first address of SRAM*/
extern unsigned int  _RAM_End;			/*the last address of the SRAM*/

extern unsigned char _TDataAddr[];		/* for tiny_data initialize, defined in link command file  */
extern unsigned char _TDataOrg[];			/* for tiny_data initialize, defined in link command file  */
extern unsigned int  _TDataSize;			/* for tiny_data initialize, defined in link command file  */
extern unsigned char _NDataAddr[];		/* for near_data initialize, defined in link command file  */
extern unsigned char _NDataOrg[];			/* for near_data initialize, defined in link command file  */
extern unsigned int  _NDataSize;			/* for near_data initialize, defined in link command file  */

/*
 * --------------------------------------------------------------------------
 *   FUNCTION DECLARATIONS
 * --------------------------------------------------------------------------
 */

/*#**************************************************************************#*/

/*
 ******************************************************************************
 * NAME				:STARTUP
 *-----------------------------------------------------------------------------
 * DESCRIPTION		:startup routine
 * PARAMETER		:-
 *
 * RETURN VALUE		:-
 *
 ******************************************************************************
 */
void STARTUP( void )
{
	unsigned int VDD_Lower_DTVT_CNT;		  // number of consecutive times that VDD is below the detection voltage
	unsigned int i,j;
	
	CLKCR1_HIRCEN = 1;						  // enable HIRC
	while(CLKCR1_HIRCRDY == 0);			  	  // wait for HIRC to be ready
	CLKCR0 = 0x10;					  		  // system frequency divided by 2   (16K/2=8KHz) 

	VDD_Lower_DTVT_CNT = 0;				  	  // initialize VDD_Lower_DTVT_CNT to 0		
//=============================================================================
//memory mapping
//=============================================================================
	DMCFG  	 = 0x50; 	//Code :0x8000~0xFFFF Map to Data: 0x8000~0xFFFF
	//DMCFG  = 0x40;	//Code :0x0000~0x7FFF Map to Data: 0x8000~0xFFFF
	//DMCFG  = 0x00;	//No Map

//=============================================================================
// Setting detection voltage (4.2 V   126 mV)
//=============================================================================
	
	P2OE_P0=0;							  	  // light on LED1(P2.0)
	for(i=0;i<1500;i++){					  // delayed for a period of time
		for(j=1500;j>0;j--);
	}
	P2OE_P0=1;								  // light off LED1(P2.0)
	for(i=0;i<1500;i++){					  // delayed for a period of time
		for(j=1500;j>0;j--);
	}

		
	LVDCR_LVDCFG = 6;					  	  // set LVD voltage to 4.2V	
	LVDCR_LVDEN  = 1;                	  	  // enable LVD
	
	
	while(1){	
		WDCDR = 0x4E;             	  		  // clear the watchdog timer 
		if(LVDCR_LVDF == 1 && LVDCR_LVDST == 1){
			VDD_Lower_DTVT_CNT ++;			  // if LVD is detected (i.e. VDD < the set detection voltage), VDD_Lower_DTVT_CNT is added by one
			if(VDD_Lower_DTVT_CNT >= 50){	
				break;						  // if LVD (i.e., VDD < the set detection voltage) is detected for (50+1) consecutive times, the loop will be released
			}
		}else{
			VDD_Lower_DTVT_CNT = 0;		  	  // if no LVD is detected (i.e., VDD >= the set detection voltage), clear VDD_Lower_DTVT_CNT to 0
		}
		
		if(LVDCR_LVDF == 1){
			LVDCR_LVDF = 1;             	  // if LVD is detected, clear LVD flag
		}		
	}

	__ASM("DI");
	LVDCR_LVDIEN = 1;                   	  // enable LVD interrupt
	IER_LVD = 1;                        	  // enable interrupt enable register of LVD
	__ASM("EI");							  // enable all maskable interrupts
//=============================================================================
//initial Registers
//=============================================================================
	__WA = 0x00;
	__BC = 0x00;
	__DE = 0x00;
	__HL = 0x00;
	__IX = 0x00;
	__IY = 0x00;

//=============================================================================
//initial Setting
//=============================================================================	
	__asm("CLR (0x08).5");

//=============================================================================
//Initialize Stack Pointer
//=============================================================================
	__asm(" LD SP,__BaseSP");	//Initialize Stack Pointer

//=============================================================================
//clear status word
//=============================================================================
	__asm(" LD PSW,0x00");

//=============================================================================
//clear RAM
//=============================================================================
	__asm(" LD HL,__RAM_Top");
	__asm(" LD BC,__RAM_End - __RAM_Top");	
	__asm(" LD A,0x00");
	__asm("CLR_RAM:");
	__asm(" LD (HL),A");
	__asm(" INC HL");
	__asm(" DEC BC");
	__asm(" JRS F,CLR_RAM");		/* Clear the RAM */

//=============================================================================
//initialize of tiny_data section
//=============================================================================
	__asm("	LD	IX,__TDataOrg");
	__asm("	LD	IY,__TDataAddr");
	__asm("	LD	A,__TDataSize");
	__asm("	DEC	A");
	__asm("	J	T,non_t_data");
	__asm("move_t_data:");
	__asm("	LD	C,(IX)");
	__asm("	LD	(IY),C");
	__asm("	INC	IX");
	__asm("	INC	IY");
	__asm("	DEC	A");
	__asm("	J	F,move_t_data");
	__asm("non_t_data:");

//=============================================================================
//initialize of near_data section
//=============================================================================
	__asm("	LD	IX,__NDataOrg");
	__asm("	LD	IY,__NDataAddr");
	__asm("	LD	WA,__NDataSize");
	__asm("	DEC	WA");
	__asm("	J	T,non_n_data");
	__asm("move_n_data:");
	__asm("	LD	C,(IX)");
	__asm("	LD	(IY),C");
	__asm("	INC	IX");
	__asm("	INC	IY");
	__asm("	DEC	WA");
	__asm("	J	F,move_n_data");
	__asm("non_n_data:");

//=============================================================================
//  other system configuration
//=============================================================================
    //System_Config();

//=============================================================================
//	Set UnPad Pin normal output LOW to avoid leakage
//=============================================================================

// 	set Low
// 	P1.4~P1.7       0000 1111  0x0F
// 	P2.5,P2.6       1001 1111  0x9F
// 	P3.0            1111 1110  0xFE
// 	P4.0,P4.1,P4.6  1011 1100  0xBC
//	P5.0,P5.4		1110 1110  0xEE

	P1DO = P1DO & ( 0x0F ); // P1.4~P1.7 	  output low
	P2DO = P2DO & ( 0x9F ); // P2.5,P2.6 	  output low
	P3DO = P3DO & ( 0xFE ); // P3.0	  		  output low
	P4DO = P4DO & ( 0xBC ); // P4.0,P4.1,P4.6 output low
	P5DO = P5DO & ( 0xEE ); // P5.0,P5.4	  output low
//---------------------------------------------------------

// 	set Output
// 	P1.4~P1.7       1111 0000  0xF0
// 	P2.5,P2.6       0110 0000  0x60
// 	P3.0            0000 0001  0x01
// 	P4.0,P4.1,P4.6  0100 0011  0x43
//	P5.0,P5.4		0001 0001  0x11

	P1OE = P1OE | ( 0xF0 ); // P1.4~P1.7 	  output
	P2OE = P2OE | ( 0x60 ); // P2.5,P2.6 	  output
	P3OE = P3OE | ( 0x01 ); // P3.0	  		  output
	P4OE = P4OE | ( 0x43 ); // P4.0,P4.1,P4.6 output
	P5OE = P5OE | ( 0x11 ); // P5.0,P5.4	  output

//=============================================================================
//jump to main
//=============================================================================
	main();
	for (;;) {
		;
	}
}

