//*************************************************************************************
// file 		: SQ7613_I2C0.h
// version		: V1.3 (Sep. 4, 20)
// brief		: I2C0 header file
// note			:  
//**************************************************************************************
#ifndef _SQ7613_I2C0_H__
#define _SQ7613_I2C0_H__
/* ---------------------- extern global variables ------------------------- */



/* ---------------------- user-defined macros ------------------------------ */
#define I2C_0 0x00

#define enable         (1)
#define disable        (0)


// PxFC1,PxFC2 configuration
// SDA0 (P0.5) ; SCL0 (P0.6)
#define P0FC_P5_SDA0   P0FC1_P5 = 1; P0FC2_P5 = 0;
#define P0FC_P6_SCL0   P0FC1_P6 = 1; P0FC2_P6 = 0;

// SDA0 (P0.4) ; SCL0 (P0.5)
#define P0FC_P4_SDA0   P0FC1_P4 = 1; P0FC2_P4 = 0;
#define P0FC_P5_SCL0   P0FC1_P5 = 1; P0FC2_P5 = 0;

// SDA0 (P3.2) ; SCL0 (P3.3)
#define P3FC_P2_SDA0   P3FC1_P2 = 1; P3FC2_P2 = 0;
#define P3FC_P3_SCL0   P3FC1_P3 = 1; P3FC2_P3 = 0;


#define i2c0BusFree    (0)
#define i2c0BusBusy    (1)
#define directionW     (0x00)
#define directionR     (0x01)

// bufcount : number of data bits
#define BC_8bit        0x00
#define BC_1bit        0x01
#define BC_2bit        0x02
#define BC_3bit        0x03
#define BC_4bit        0x04
#define BC_5bit        0x05
#define BC_6bit        0x06
#define BC_7bit        0x07

// SYSCLK@24MHZ							fscl          
#define SCK_HI_9_LO_12			0x00	//1143 kHz	;
#define SCK_HI_11_LO_14			0x01	// 960 kHz	;
#define SCK_HI_15_LO_18			0x02	// 727 kHz	;
#define SCK_HI_23_LO_26			0x03	// 490 kHz	;
#define SCK_HI_39_LO_42			0x04	// 296 kHz	;
#define SCK_HI_71_LO_74			0x05	// 166 kHz	;
#define SCK_HI_135_LO_138		0x06	//  88 kHz	;
#define SCK_HI_263_LO_266		0x07	//  45 kHz	;

#define waitCountMax            250     // maximum waiting counting value

#define initBusLowErr           0xE0    // if one of SDA or SCL is not H level, 
                                        // its error code is 0xE0
										
#define nackTimeoutErr          0xE1    // if there is no response, 
                                        // its error code is 0xE1
                                        

//----------------------------------------------------------------
void  I2C0_SetSlaveAddr(uchar addr);						// set slave address
void  I2C0_Init();											// I2C0 initialization
void  I2C0_Int(uchar config);                               // enable / disable I2C0 interrupt

uchar I2C0_Start(uchar deviceId, uchar addr);	            // I2C0 generate the start condition
void  I2C0_Confirm_Tx_Completed();                          // wait for tranfer completion
uchar I2C0_Wait_Slave_ACK();                                // wait for Slave return ACK
void  I2C0_SetSlaveAddr_Direction(uchar deviceId, uchar i2cDirection); // set slave device address and direction

uchar I2C0_ReStart(uchar deviceId);						    // I2C0 generate the restart condition
void  I2C0_Stop();											// I2C0 generate the stop condition
uchar I2C0_Bytes_Write(uchar *data, uchar len);	            // I2C0 transmits data
uchar I2C0_Bytes_Read(uchar *data, uchar len);	            // I2C0 receives data
void  I2C0_Reset();                                         // software reset I2C0

void  __interrupt IntI2C0(void);							// I2C0 interrupt service routine
void  I2C0_Error_Handling();                                // error handling

#endif


