//*************************************************************************************
// file 		: SQ7613_I2C.h
// version		: V1.2
// brief		: I2C header file
// note			:  
//**************************************************************************************
#ifndef _SQ7613_I2C_H__
#define _SQ7613_I2C_H__

/* ---------------------- extern global variables ------------------------- */



/* ---------------------- user-defined macros ------------------------------ */
#define SLAVE_ADDR 0x68

#define I2C_0 0x00
#define I2C_1 0x01

#define I2C_Master     1
#define I2C_Slave      0

#define I2C_Write   0x00
#define I2C_Read    0x01

#define I2C_ACK        0
#define I2C_NACK       1

#define BIT0  0x0001
#define BIT1  0x0002
#define BIT2  0x0004
#define BIT3  0x0008
#define BIT4  0x0010
#define BIT5  0x0020
#define BIT6  0x0040
#define BIT7  0x0080
#define BIT8  0x0100
#define BIT9  0x0200
#define BIT10 0x0400
#define BIT11 0x0800
#define BIT12 0x1000
#define BIT13 0x2000
#define BIT14 0x4000
#define BIT15 0x8000

//bufcount : number of data bits
#define BC_8bit      0x00
#define BC_1bit      0x01
#define BC_2bit      0x02
#define BC_3bit      0x03
#define BC_4bit      0x04
#define BC_5bit      0x05
#define BC_6bit      0x06
#define BC_7bit      0x07

// SYSCLK@24MHZ							fscl          
#define SCK_HI_9_LO_12			0x00	//1143 kHz	;
#define SCK_HI_11_LO_14			0x01	// 960 kHz	;
#define SCK_HI_15_LO_18			0x02	// 727 kHz	;
#define SCK_HI_23_LO_26			0x03	// 490 kHz	;
#define SCK_HI_39_LO_42			0x04	// 296 kHz	;
#define SCK_HI_71_LO_74			0x05	// 166 kHz	;
#define SCK_HI_135_LO_138		0x06	//  88 kHz	;
#define SCK_HI_263_LO_266		0x07	//  45 kHz	;

#define SBICR2_MST      BIT7
#define SBICR2_TX       BIT6
#define SBICR2_RX       0x00
#define SBICR2_BB       BIT5
#define SBICR2_PIN      BIT4
#define SBICR2_SBIM     BIT3

#define SBISR_Master    BIT7
#define SBISR_TX        BIT6
#define SBISR_BusBusy   BIT5
#define SBISR_PIN       BIT4
#define SBISR_AL        BIT3
#define SBISR_AAS       BIT2
#define SBISR_AD0       BIT1
#define SBISR_LRB       BIT0

#define I2C_Slave_adr     0
#define I2C_Slave_cmd     1
#define I2C_Slave_write   2
#define I2C_Slave_read    3

//------------------------------------------------------------------
typedef struct{
	unsigned char adr;
	unsigned char cmd;
	unsigned char pointer;
	unsigned char len;
	unsigned char status;
	unsigned char pec;
	unsigned char buf[34];
}I2C_SlavePacket;

typedef struct{
	unsigned char adr;
	unsigned char cmd;
	unsigned char len;
	unsigned char buf[34];
}I2C_MasterPacket;

extern I2C_MasterPacket i2c_master;
extern I2C_SlavePacket  i2c_slave;

//------------------------------------------------------------------
void I2C0_Init();
void I2C0_IntEnable();
void I2C0_IntDisable(void);

void I2C1_Init();
void I2C1_IntEnable();
void I2C1_IntDisable(void);

void I2C_Start(unsigned char i2c,unsigned char adr);
void I2C_ReStart(unsigned char i2c,unsigned char adr);
void I2C_Stop(unsigned char i2c);
void I2C_TXOneByte(unsigned char i2c,unsigned char TxBuf);
unsigned char I2C_RXOneByte(unsigned char i2c);


void I2C_SetBufvalue(unsigned char i2c,unsigned char data);
unsigned char I2C_ReadBufvalue(unsigned char i2c);
void I2C_FinishSlaveTx(unsigned char i2c);
void I2C_Reset(unsigned char i2c);

unsigned char I2C_Master_Write(unsigned char i2c,I2C_MasterPacket* pi2c);
unsigned char I2C_Master_Read(unsigned char i2c,I2C_MasterPacket* pi2c);
void I2C_Slave_Int(unsigned char i2c,I2C_SlavePacket* pi2c);

void __interrupt IntI2C0(void);
void __interrupt IntI2C1(void);

#endif

