//*************************************************************************************
// file			: main.h
// version		: V1.1
// brief		: header file of this example
// note			: the custom variables used are collected in this document in this header file
//**************************************************************************************

#ifndef _INCLUDES_H__
#define _INCLUDES_H__

/* ---------------------- reference header files ------------------------------ */
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "SQ7613_SFR.h"
#include "SQ7613_TCA.h"


/* ---------------------- user-defined macros ------------------------------ */
#define d_10Hz_Count 2343    	      	  // count 2343 times to get 10Hz frequency (0.0426ms * 2343= 99.81ms)

#define   BTN1_in    P3DI_P1	      	  // BTN1(P3.1) button 1 input voltage
#define   BTN2_in    P3DI_P2		      // BTN2(P3.2) button 2 input voltage
//#define BTN3_in    P3DI_P3		      // BTN3(P3.3) button 3 input voltage

#define   LED1_out   P2DO_P0		  	  // define LED1_out as P2.0 output
//#define LED2_out   P2DO_P1		  	  // define LED2_out as P2.1 output
//#define LED3_out   P2DO_P2          	  // define LED3_out as P2.2 output

#define BIT0  0x0001				  
#define BIT1  0x0002
#define BIT2  0x0004
#define BIT3  0x0008
#define BIT4  0x0010
#define BIT5  0x0020
#define BIT6  0x0040
#define BIT7  0x0080
#define BIT8  0x0100
#define BIT9  0x0200
#define BIT10 0x0400
#define BIT11 0x0800
#define BIT12 0x1000
#define BIT13 0x2000
#define BIT14 0x4000
#define BIT15 0x8000

#define SET(n,c)  ((n) |= (c))      	  
#define CLR(n,c)  ((n) &= ~(c))

/* ---------------------- extern global variables ------------------------- */




/* ---------------------- extern functions ------------------------ */
extern void STARTUP(void);


#endif //#ifndef _INCLUDES_H__

