//*************************************************************************************
// file			: SQ7613_Delay_Loop.h
// version		: V1.0 (Sep. 4, 20)
// brief		: SQ7613_Delay_Loop header file
// note			:        
//**************************************************************************************
#ifndef _SQ7613_DELAY_LOOP_H__
#define _SQ7613_DELAY_LOOP_H__

/* ---------------------- extern global variables ------------------------- */
extern volatile  unsigned int  Delay_base_ms;
extern volatile  unsigned int  Delay_base_100us;

/* ---------------------- user-defined macros ------------------------------ */
#define PLL         1

#define PLL_24M    	0x01	// system frequency divided by 2    (48M/2	= 24MHz) 
#define	PLL_12M  	0x02	// system frequency divided by 4    (48M/4	= 12MHz) 
#define PLL_6M  	0x03	// system frequency divided by 8    (48M/8	= 6MHz) 

// the number of loops required for the 1ms Delay Loop function corresponding to each system frequency is defined here
#define f24m_1ms_t    (1508)  // this is the number of loops required by the Delay Loop function for 1ms at PLL 24MHz, please do not modify this definition!
#define f12m_1ms_t    (1508/2)
#define f06m_1ms_t    (1508/4)

// the number of loops required for the 100us Delay Loop function corresponding to each system frequency is defined here
#define f24m_100us_t  (149)   // this is the number of loops required by the Delay Loop function for 100us at PLL 24MHz, please do not modify this definition!


//------------------------------------------------------------------
void Delay_Loop_Init();
void delay_ms(uint x);
void delay_100us(uint y);


#endif

