//*************************************************************************************
// file			: SQ7613_DVOB.c
// version		: V1.1
// brief		: DVOB related functions
// note			: DVOB related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"


//*********************************************************************
// name			: DVOB_Init()
// brief		: DVOB initialization
// note			: 
//*********************************************************************
void DVOB_Init(){

	//====== DVOB output pin setting ======
	P4FC1_P7 = 0;                       // Set P4.7 to DVOB output
	P4FC2_P7 = 1; 
	
	//====== parameter setting ======
	
	//--DVOB_fcgck_DIV_4096--  			//set DVOB output frequency to fsysclk/4096 (about 3.906 KHz)
	//TBTCR_DV9CK = 0;
	DVOCR_DVOCK = 0;						
/*	
	//--DVOB_fcgck_DIV_2048--  			//set DVOB output frequency to fsysclk/2048 (about 7.812 KHz)
	TBTCR_DV9CK = 0;
	DVOCR_DVOCK = 1;						
*/


/*
	//--DVOB_fcgck_DIV_1024--  			//set DVOB output frequency to fsysclk/1024 (about 15.625 KHz)
	TBTCR_DV9CK = 0;
	DVOCR_DVOCK = 2;						
*/


/*
	//--DVOB_fcgck_DIV_512--  			//set DVOB output frequency to fsysclk/512 (about 31.25  KHz)
	TBTCR_DV9CK = 0;
	DVOCR_DVOCK = 3;						
*/


}


//*********************************************************************
// name			: DVOB_Start()
// brief		: start DVOB
// note			: 
//*********************************************************************
void DVOB_Start(){	

	DVOCR_DVOEN = 1;                    	// enable DVOB

}


//*********************************************************************
// name			: DVOB_Stop()
// brief		: stop DVOB
// note			: 
//*********************************************************************
void DVOB_Stop(){
	
	DVOCR_DVOEN = 0;                    	// disable DVOB
	
}

