//*************************************************************************************
// file			: SQ7613_ADC.h
// version		: V1.1 2020/07/30
// brief		: ADC header file
// note			: 
//**************************************************************************************

#ifndef _SQ7613_ADC_H__
#define _SQ7613_ADC_H__

/* ---------------------- extern global variables ------------------------- */



/* ---------------------- user-defined macros ------------------------------ */
#define ADC_RefScale(x) 	(x/4096)         		  // x fills in the value of uV
#define	ad_test_times   	16				 		  // average number of times for ADC repeat mode conversion

// ADC reference voltage
#define IRFEN_VDD   		0x01
#define IRFEN_XREF  		0x02

// ADC operation mode
#define AMD_Stop    		0x00
#define	AMD_Single  		0x01
#define AMD_Repeat  		0x03


// ADC input trigger source
#define EVSEL_ADRS     		0x00
#define EVSEL_DMA      		0x03
#define EVSEL_TCA0     		0x08
#define EVSEL_TCA2     		0x09
#define EVSEL_TCA4     		0x0A
#define EVSEL_EINT0    		0x0C


// ADC input channel
#define AIN4	       		0x4
#define AIN5	       		0x5
#define AIN6	       		0x6
#define AIN7	       		0x7
#define AIN8	       		0x8
#define AIN9	       		0x9
#define AIN10	       		0xA

//----------------------------------------------------------------
void ADC_Init();							 			// ADC initialization
void ADC_IntEnable();						 			// enable ADC interrupt
void ADC_IntDisable();						 			// disable ADC interrupt
void ADC_Stop_and_Disable();                            // disable ADC operation and forcibly stop ADC operation

void ADC_Convert_Single();					 			// ADC single mode conversion
//unsigned int ADC_Convert_Repeat(unsigned char SAIN);	// perform ADC repeat mode conversion and store the conversion value in ADCDRL and ADCDRH and average them
char ADC_ConvertDone();						 			// determine if the ADC conversion is complete and return the value
long ADC_Read_Value(unsigned char chsel);	 			// readout ADC value  

void __interrupt IntADC(void);				 			// ADC interrupt subroutine

#endif


