//*************************************************************************************
// file			: SQ7515_TBT.c
// version		: V1.0
// brief		: TBT related functions
// note			: TBT related functions are collected in this subroutine
//**************************************************************************************
#include "main.h"
unsigned char TBT_Int_Flag;			// TBT interrupt flag


//*********************************************************************
// name			: TBT_Init()
// brief		: TBT initialization
// note			: 
//*********************************************************************
void TBT_Init(){
	TBTCR_DV9CK = 0;                    // set DV9CK to 0
    TBTCR_TBTCK = 0x08;                 // selects the TBT interrupt frequency
										// set interrupt frequency to fcgck / 2^22
										// 								     (fcgck / 2^22 = 5.722Hz)
										// T=1/5.722 = 0.174764s
}


//*********************************************************************
// name			: TBT_IntEnable()
// brief		: enable TBT interrupt
// note			: 
//*********************************************************************
void TBT_IntEnable(){	
    __ASM("DI");						// enable all maskable interrupts
	IER_TBT = 1;                        // enable TBT interrupt
	__ASM("EI");                        // enable all maskable interrupts
}


//*********************************************************************
// name			: TBT_Start()
// brief		: start TBT
// note			: 
//*********************************************************************
void TBT_Start(){	

	TBTCR_TBTEN = 1;					// start TBT
	
}


//*********************************************************************
// name			: TBT_Stop()
// brief		: stop TBT
// note			: 
//*********************************************************************
void TBT_Stop(){
	
	TBTCR_TBTEN = 0;					// stop TBT
	
}


//*********************************************************************
// name			: __interrupt IntTBT()
// brief		: TBT interrupt subroutine
// note			:
//*********************************************************************
void __interrupt IntTBT(void){
	__asm("NOP");						// no operation
	TBT_Int_Flag = 1;					// set TBT interrupt flag to 1

}

