//*************************************************************************************
// file			: SQ7515_HXTAL_System_Init.c
// version		: V1.0
// brief		: HXTAL_System_Init related functions
// note			: HXTAL_System_Init related functions are collected in this subroutine
//**************************************************************************************

#include "main.h"

//*********************************************************************
// name			: HXTAL_System_Init()
// brief		: PLL initialization
// note			: 
// F_div_sel: HXTAL_16M	system frequency divided by 1  (16M/1  = 16MHz)
//            HXTAL_8M	system frequency divided by 2  (16M/2  = 8MHz)
//			  HXTAL_4M	system frequency divided by 4  (16M/4  = 4MHz)
//			  HXTAL_2M   system frequency divided by 8  (16M/8  = 2MHz)
//			  HXTAL_1M   system frequency divided by 16 (16M/16 = 1MHz)
//			  HXTAL_500K system frequency divided by 32 (16M/32 = 0.5MHz = 500KHz)
//			  HXTAL_250K system frequency divided by 64 (16M/64 = 0.25MHz = 250KHz)
//			  HXTAL_62_5Ksystem frequency divided by 128(16M/128= 0.0625MHz = 62.5KHz)
//
// example		: to use HXTAL 8MHz as the system clock source, the function is used as shown below
//			  HXTAL_System_Init(HXTAL_8M);	  // (16M/2=8MHz) 
//*********************************************************************
void HXTAL_System_Init(unsigned char F_div_sel){

	// change the system clock source pre-divider to pre-divide 1	
	CLKCR0_SCKPSC = 0x00;					  // system clock setting fsysclk = fsck/1 = 16MHz 

	// because of the need to use an external high speed crystal oscillator, the first step is to set the pin of the external crystal oscillator
	P4FC1 = 0x30;							  // set external high-speed crystal oscillator pin
	P4FC2 = 0x30;							  // set external high-speed crystal oscillator pin
	
	
	CLKCR1_HXEN   = 1;                  	  // enable HXTAL (external high-speed clock) of 16MHz
	while(CLKCR1_HXRDY == 0);		    	  // wait for HXTAL to be ready
	// the HXTAL is ready, switch the system clock source to HXTAL
	
	CLKCR0_SCKSRC = 0x03;					  // switch the system clock source to HXTAL
	//CLKCR0_SCKPSC = 0x00;					  // system clock setting fsysclk = fsck/1 = 16MHz
	
	while(CLKCR0_SCKRDY==0);	        	  // wait for system clock to be ready
	// system clock is ready

}


//*********************************************************************
// name			: HXTAL_Freq_Division()
// brief		: HXTAL frequency division selection
// note			: 
//*********************************************************************
void HXTAL_Freq_Division(unsigned char F_div_sel){


	CLKCR0_SCKPSC = F_div_sel;                // set system clock frequency division
  

}

