//*************************************************************************************
// file			: main.c
// version		: V1.0 2022/05/25
// brief		: main program
// description	: 1. this example program demostrates AES ECB mode
//
//            2. please use the serial port of the computer to connect with UART1 and use the terminal program
//
// note			: 
//            1. set I2C1 to Master mode
//		             set P2.1 as SDA1
//		             set P2.2 as SCL1
//	             *remember to add pull-high resistors
//
//            2. set P2.5 as UART1 TX
//               set P2.6 as UART1 RX
//               set Baud rate to 115200
// 
//			     [Button Configuration] button 1 :  BTN1(P3.0), (EINT0)
//
//				 [LED Configuration]  LED 1  (P2.0)
//**************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif

#include "main.h"

SecureUnit_Command_Packet SecureUnit_CMD;
SecureUnit_Response_Packet SecureUnit_RESP;

///Key
const uint8_t KEY[3][16] = {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
                            {0x10,0xa5,0x88,0x69,0xd7,0x4b,0xe5,0xa3,0x74,0xcf,0x86,0x7c,0xfb,0x47,0x38,0x59},
                            {0x90,0xf4,0x2e,0xc0,0xf6,0x83,0x85,0xf2,0xff,0xc5,0xdf,0xc0,0x3a,0x65,0x4d,0xce}
                           };

///Plaintext						   
const uint8_t PT[3][16] =  {{0xf3,0x44,0x81,0xec,0x3c,0xc6,0x27,0xba,0xcd,0x5d,0xc3,0xfb,0x08,0xf2,0x73,0xe6},
                            {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
                            {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
                           };

///Ciphertext						   
const uint8_t CT[3][16] =  {{0x03,0x36,0x76,0x3e,0x96,0x6d,0x92,0x59,0x5a,0x56,0x7c,0xc9,0xce,0x53,0x7f,0x5e},
                            {0x6d,0x25,0x1e,0x69,0x44,0xb0,0x51,0xe0,0x4e,0xaa,0x6f,0xb4,0xdb,0xf7,0x84,0x65},
                            {0x7a,0x20,0xa5,0x3d,0x46,0x0f,0xc9,0xce,0x04,0x23,0xa7,0xa0,0x76,0x4c,0x6c,0xf2}
                           };

//*********************************************************************
// name			: main()
// brief		: main program
// param		: 
// retval		: 
// note			: 
//*********************************************************************
void main()
{
    uint8_t temp;

/* ---------------------- system initialization ------------------------ */
	PLLCR0_PLLEN  = 1;                  // enable PLL
	while(PLLCR0_PLLRDY ==0);			// wait for PLL to be ready
	CLKCR0_SCKPSC = 1;                  // system frequency divided by 2   (48M/2=24MHz) 
    CLKCR0_SCKSRC = 1;                  // switch clock source to PLL
	while(CLKCR0_SCKRDY ==0);			// wait for system clock to be ready
/* ---------------------- pin configuration initialization ------------------------ */
    P0PU = 0xFF;                        // enable all built-in pull-up resistors
    P1PU = 0xFF;
    P2PU = 0xFF;
    P3PU = 0xFF;
    P4PU = 0xFF;
    P5PU = 0xFF;

    P2OE_P0 = 1;                        // set P2.0 as output pin
    P2PU_P0 = 0;                        // disable P2.0 built-in pull-up resistor

    P3OE_P7 = 1;                        // set P3.7 as output pin
    P3PU_P7 = 0;                        // disable P3.7 built-in pull-up resistor

    P3OE_P6 = 1;                        // set P3.6 as output pin
    P3PU_P6 = 0;                        // disable P3.6 built-in pull-up resistor
	
    LED1_out = 1;                       // set LED1 to the light off
    LED2_out = 1;                       // set LED2 to the light off
    LED3_out = 1;                       // set LED3 to the light off
/* ---------------------- EINT initialization ------------------------ */
    EINT_Init();                        // initialize EINT
    EINT_IntEnable();                   // enable EINT interrupt
/* ---------------------- I2C1 initialization ------------------------ */
    I2C1_Init();                        // set I2C1 as Master and disable I2C1 interrupt 
/* ---------------------- UART1 initialization ------------------------ */
    UART1_Init();
    UART1_SetBaud rate(SYSCLK_24MHZ_BAUD_115200);
	UART1_Start();
/* ---------------------- TCA0 initialization ------------------------ */    
    TCA0_Timer_Init();
    TCA0_IntEnable();
/* ---------------------- CRC initialization ------------------------ */
    CRC_Init();
///-------------------------------------------------------------    

    UART_SendCString("SecureUnit API Example: Lecagy ECB Encrypt\n");


    while(1){
        UART_SendCString("\nSelect encrypt test pattern NO.: 0~2 \n");
        temp = UART1_RX_OneByte();
        UART1_TX_OneByte(temp);

        temp -= 0x30;        

        UART_SendCString("\nECB encrypt test\n");
        ///Setup Key 0
        SecureUnit_CMD.Length = 25; 
        SecureUnit_CMD.Opcode = OpCode_BlockWrite;	// Block write command
        SecureUnit_CMD.Mode = 0x00;
        SecureUnit_CMD.Param1 = 0xF200;				// Write Key 0
        SecureUnit_CMD.Param2 = 0x0010;
        SecureUnit_CMD.pDIN = (uint8_t*)&KEY[temp][0];
        UART_SendCString("Key: "); UART_SendHex((uint8_t*)&KEY[temp][0],16);
			  
        if(SecureUnit_Command_Execute(&SecureUnit_CMD,&SecureUnit_RESP)==CMD_RET_OK){
            if(SecureUnit_RESP.CMDST==0){
                UART_SendCString("Key write success!\n");
            }
            else{
                UART_SendCString("Key write fail!\n");
            }
        }
        else{
            UART_SendCString("Key write fail!\n");
        }

        ///ECB mode ecnryption 
        SecureUnit_CMD.Length = 25; 
        SecureUnit_CMD.Opcode = OpCode_Legacy;	  // Legacy command 					  
        SecureUnit_CMD.Mode = 0x00;
        SecureUnit_CMD.Param1 = 0x0000;			  // Use Key 0 
        SecureUnit_CMD.Param2 = 0x0000; 
        SecureUnit_CMD.pDIN = (uint8_t*)&PT[temp][0];
        UART_SendCString("Plaintext: "); UART_SendHex((uint8_t*)&PT[temp][0],16);
			  
        if(SecureUnit_Command_Execute(&SecureUnit_CMD,&SecureUnit_RESP)==CMD_RET_OK){
			  
            if(SecureUnit_RESP.CMDST==0){
			      
                UART_SendCString("ECB encrypt command execute success!\n");
                if(memcmp(SecureUnit_RESP.DOUT,&CT[temp][0],16)==0){   // data comparison
                    UART_SendCString("ECB encrypt success!\n");  
                    //UART_SendCString("Ciphertext: "); UART_SendHex((uint8_t*)&CT[temp][0],16);
                    //UART_SendCString("Encrypt result: "); UART_SendHex(SecureUnit_RESP.DOUT,16);
						
                }
                else{					
                    UART_SendCString("ECB encrypt fail!\n");  
                    //UART_SendCString("Ciphertext: "); UART_SendHex((uint8_t*)&CT[temp][0],16);
                    //UART_SendCString("Encrypt result: "); UART_SendHex(SecureUnit_RESP.DOUT,16);
                }
					
                UART_SendCString("Ciphertext: "); UART_SendHex((uint8_t*)&CT[temp][0],16);
                UART_SendCString("Encrypt result: "); UART_SendHex(SecureUnit_RESP.DOUT,16);					
            }
            else{
				  
                UART_SendCString("ECB encrypt command execute fail! ReturnCode: ");
                UART_PutByte(UART_1,SecureUnit_RESP.CMDST);UART_PutCrlf(); 
            }
        }
        else{
            UART_SendCString("ECB encrypt command execute fail!\n");
        }
    }
}

/*---------------------------------------------------------------------------------------------*/
//*********************************************************************
// name			: Delay_us()
// brief		: 
// note			: 
//*********************************************************************
void Delay_us(uint16_t val)
{

    TCA0_SetPeriod(val*6);
    TCA0_Int_Flag = 0;
    TCA0_Start();
    while(!TCA0_Int_Flag);
    TCA0_Stop();
  
}

/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void){
    __asm("NOP");                       // no operation
}

void __interrupt_n OnlyRetn(void){
    __asm("NOP");                       // no operation
}

void __interrupt_n IntWDT(void){
    __asm("NOP");                       // no operation
}

void __interrupt_n IntSWI(void){        // software reset interrupt service routine
    PRSTR7 = 0x5a;
    PRSTR7 = 0xa5;
    PRSTR7 = 0xc3;
    PRSTR7 = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */


/* -------------------- SQ7515 interrupt vector ---------------------- */ 
#pragma section const INT_VECTOR1 0xff40
void * const IntTbl1[] = {											
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : IntTCA7			*/	//interrupt source:TCA7 16-bit timer								
	OnlyReti,				/* 0xff5a : IntTCA6			*/	//interrupt source:TCA6 16-bit timer							
	OnlyReti,				/* 0xff5c : Reserved		*/									
	OnlyReti,				/* 0xff5e : Reserved		*/									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved		*/									
	OnlyReti,				/* 0xff6c : IntTX2			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : IntRX2			*/	//interrupt source:UART2 RX2							
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : IntTCA5			*/	//interrupt source:TCA5 16-bit timer								
	OnlyReti,				/* 0xff78 : IntTCA4			*/	//interrupt source:TCA4 16-bit timer								
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/									
	OnlyReti,		    	/* 0xff82 : Reserved		*/									
	OnlyReti,	    		/* 0xff84 : Reserved		*/									
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	OnlyReti,				/* 0xff8c : IntSIO1			*/	//interrupt source:SIO 1								
	OnlyReti,				/* 0xff8e : IntI2C1			*/	//interrupt source:I2C1						
	OnlyReti,				/* 0xff90 : IntTX1			*/	//interrupt source:UART1 TX1							
	OnlyReti,				/* 0xff92 : IntRX1			*/	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : Reserved		*/									
	OnlyReti,				/* 0xff9a : IntTCA3			*/	//interrupt source:TCA3 16-bit timer							
	OnlyReti,				/* 0xff9c : IntTCA2			*/	//interrupt source:TCA2 16-bit timer								
	OnlyReti,				/* 0xff9e : Reserved		*/									
	OnlyReti,				/* 0xffa0 : IntMAC			*/	//interrupt source:multiplier								
	OnlyReti,				/* 0xffa2 : IntEXT7			*/	//external interrupt7								
	OnlyReti,				/* 0xffa4 : IntEXT6			*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : IntEXT5			*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : IntEXT4			*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/							
	OnlyReti,				/* 0xffb0 : IntDIC			*/	//interrupt source:DIC								
	OnlyReti,				/* 0xffb2 : Reserved		*/							
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : IntFMC			*/	//interrupt source:flash memory controller								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : Reserved		*/									
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	OnlyReti,               /* 0xffce : IntADC			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : IntEXT3			*/	//external interrupt3
	IntEXT2,				/* 0xffd2 : IntEXT2			*/	//external interrupt2
	IntEXT1,				/* 0xffd4 : IntEXT1			*/	//external interrupt1
	IntEXT0,				/* 0xffd6 : IntEXT0			*/	//external interrupt0   
	OnlyReti,				/* 0xffd8 : IntSIO0			*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : IntI2C0			*/	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : IntTX0			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : IntRX0			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : Reserved		*/									
	OnlyReti,				/* 0xffe4 : Reserved		*/									
	OnlyReti,				/* 0xffe6 : IntTCA1			*/	//interrupt source:TCA1 16-bit timer								
	IntTCA0,				/* 0xffe8 : IntTCA0			*/	//interrupt source:TCA0 16-bit timer								
	OnlyReti,				/* 0xffea : Reserved		*/									
	OnlyReti,				/* 0xffec : Reserved		*/									
	OnlyReti,			    /* 0xffee : IntRTC			*/	//interrupt source:real-time clock timer								
	OnlyReti,				/* 0xfff0 : IntTBT			*/  //interrupt source:time base timer				
	OnlyReti,				/* 0xfff2 : Reserved		*/									
	OnlyReti,				/* 0xfff4 : IntCFD			*/	//interrupt source:clock fail detection								
	OnlyReti,				/* 0xfff6 : IntLVD			*/	//interrupt source:low voltage detection							
	IntWDT,					/* 0xfff8 : IntWDT			*/	//non-maskable interrupt source:watchdog timer		
	(void *)0xffff,			/* 0xfffa : Reserved		*/									
	IntSWI,					/* 0xfffc : IntSWI/INTUNDEF */	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7515 interrupt vector ---------------------- */

/* ---------------------- end of file -------------------------------- */