//*************************************************************************************
// file			: SQ7515_SecureUnit_I2C_Comm.c
// version		: V1.0
// brief		: control communication functions of SecureUnit
// note			:
//**************************************************************************************
#include "main.h"

//*********************************************************************
// name			: Command_Send()
// brief		: send command to SecureUnit
// param		: wBuff  - pointer to the command buffer
//            wCnt   - command buffer size
// retval		: communication results
// note			: 
//*********************************************************************
Comm_Ret Command_Send(uint8_t* wBuff, uint8_t wCnt)
{
    I2C_HAL_Ret RET;
    uint8_t Loop_Cnt=0;

    do{
        RET = I2C_Data_Transmit(wBuff,wCnt);
        if(RET == I2C_HAL_RET_OK){
		 	break;
        }

        Loop_Cnt++;
        if(Loop_Cnt>=30 && RET!=I2C_HAL_RET_OK){
            break;
        }

        Delay_us(100);
    }while(RET!=I2C_HAL_RET_OK);

    if(RET != I2C_HAL_RET_OK){
        return COMM_RET_ERR; 
    }
	 
	return COMM_RET_OK; 
}


//*********************************************************************
// name			: Response_Receive()
// brief		: receive command execution responses from SecureUnit
// param		: rBuff  - pointer to the response buffer
// retval		: communication results
// note			: 
//*********************************************************************
Comm_Ret Response_Receive(uint8_t* rBuff)
{
    I2C_HAL_Ret RET;
	 
    RET = I2C_Data_Receive(rBuff);

	if(RET != I2C_HAL_RET_OK){
        return COMM_RET_ERR;
    }
	
	return COMM_RET_OK; 
}


/* ------------------- end of file  ---------------------- */