//*************************************************************************************
// file			: SQ7515_SecureUnit_CMD_Marshaling.c
// version		: V1.3
// brief		: SecureUnit command marshaling and execution
// note			:
//**************************************************************************************
#include "main.h"

uint8_t TxBuffer[80];
uint8_t RxBuffer[80];

#ifndef HW_CRC
//*********************************************************************
// name			: crc16()
// brief		: CRC16 calculation
// param		: crcValue: the actual or initial value
//            newByte:  data to be calculated
// retval		: calculation result
// note			: 
//*********************************************************************
uint16_t crc16(uint16_t crcValue, uint8_t newByte) 
{
	uint8_t i;

	for (i = 0; i < 8; i++){

		if (((crcValue & 0x8000) >> 8) ^ (newByte & 0x80)){
			crcValue = (crcValue << 1) ^ POLYNOM;
		}
        else{
			crcValue = (crcValue << 1);
		}

		newByte <<= 1;
	}
  
	return crcValue;
}

#endif // HW_CRC

//*********************************************************************
// name			: SecureUnit_CRC_Calculate()
// brief		: calculate the CRC value of the buffer
// param		: pData:  buffer pointer
//            len: buffer size
// retval		: 
// note			: 
//*********************************************************************
uint16_t SecureUnit_CRC_Calculate(uint8_t *pData, uint16_t len)
{
#ifdef HW_CRC
    //----------------------------------
    // calculate CRC using hardware
    //----------------------------------
    return (CRC_Calculate(pData,len));

#else // HW_CRC
    //----------------------------------
    // calculate CRC using software
    //----------------------------------
	uint16_t crc;
	uint16_t aux = 0;

	crc = 0xFFFF;                       // CRC initial value

	while (aux < len){
		crc = crc16(crc,pData[aux]);
		aux++;
	}

	return crc;
	
#endif // HW_CRC
}

//*********************************************************************
// name			: Command_Buffer_Prepare()
// brief		: pre-processing of command packets
// param		: pCMD: pointer to the command packet
//            pBuff: pointer to the processed data buffer
// retval		: 
// note			: 
//*********************************************************************
void Command_Buffer_Prepare(SecureUnit_Command_Packet* pCMD, uint8_t* pBuff)
{
    uint8_t* pTemp;
	uint8_t  i;
	uint16_t crc;
	  
    pTemp = pBuff;
	*pBuff++ = pCMD->Length;
    *pBuff++ = pCMD->Opcode;
	*pBuff++ = pCMD->Mode;

    if(pCMD->Opcode == OpCode_SHA){

        *pBuff++ = pCMD->Length_H;      
        *pBuff++ = pCMD->Length_L;
		  
        if(pCMD->Length > 7){
		    for(i=0 ;i<(pCMD->Length-7) ;i++){
                *pBuff++ = *pCMD->pDIN++;
            }
        }
    }
	else if(pCMD->Opcode != OpCode_RDSR){

        *pBuff++ = (uint8_t)(pCMD->Param1 >> 8);
        *pBuff++ = (uint8_t)pCMD->Param1;
        *pBuff++ = (uint8_t)(pCMD->Param2 >> 8);
        *pBuff++ = (uint8_t)pCMD->Param2;

        if(pCMD->Length > 9){

            for(i=0 ;i<(pCMD->Length-9) ;i++){
                //*pBuff++ = pCMD->DIN[i];
                *pBuff++ = *pCMD->pDIN++;
            }
        }
    }

    crc = SecureUnit_CRC_Calculate(pTemp,pCMD->Length-2);
	*pBuff++ = (uint8_t)(crc >> 8);
	*pBuff++ = (uint8_t)crc;
	  
}

//*********************************************************************
// name			: SecureUnit_Command_Execute()
// brief		: execute the SecureUnit command
// param		: pCMD    - pointer to the command packet
//            pRESP   - pointer to the response packet
// retval		: execution result
// note			: 
//*********************************************************************
SecureUnit_Cmd_Ret SecureUnit_Command_Execute(SecureUnit_Command_Packet* pCMD ,SecureUnit_Response_Packet* pRESP)
{
    Comm_Ret RET;
    uint16_t LoopCnt=0;
	uint16_t PollingTime;

	if((pCMD->Opcode==OpCode_EncWrite || pCMD->Opcode==OpCode_BlockWrite) || 
        (pCMD->Opcode==OpCode_WriteCompute) ||
        (pCMD->Opcode==OpCode_Reset)||
		(pCMD->Opcode==OpCode_Counter) ||
		(pCMD->Opcode==OpCode_KeyCreate||pCMD->Opcode==OpCode_KeyImport||pCMD->Opcode==OpCode_KeyLoad||pCMD->Opcode==OpCode_KeyTransfer)){

        PollingTime = 12000;
    }
	else if((pCMD->Opcode==OpCode_Auth && pCMD->Mode==3)|| // Auth , mutual mode
            (pCMD->Opcode==OpCode_DecRead)||
			(pCMD->Opcode==OpCode_EncRead)||
			(pCMD->Opcode==OpCode_WriteCompute)||
			(pCMD->Opcode==OpCode_Legacy)||
			(pCMD->Opcode==OpCode_Decrypt)||
            (pCMD->Opcode==OpCode_Encrypt)){

		PollingTime = 1000;
	}
	else if(pCMD->Opcode==OpCode_INFO){
		PollingTime = 100;
	}
	else{
	 	PollingTime = 300;
    }

    Command_Buffer_Prepare(pCMD,TxBuffer);

	if(Command_Send(TxBuffer,pCMD->Length) == COMM_RET_OK){
	 
        Delay_us(PollingTime);
        do{
		 	RET = Response_Receive(RxBuffer);
            
			if(RET == COMM_RET_OK){
				break;
            }

		    Delay_us(PollingTime); 
            
		    if(LoopCnt++ > 100){
                break;
            }

        }while(RET==COMM_RET_ERR || RET==COMM_RET_BUSY); 
       
        if(RET == COMM_RET_OK){
            pRESP->Length = RxBuffer[0];
            pRESP->CMDST = RxBuffer[1];
            memcpy(pRESP->DOUT, &RxBuffer[2], (pRESP->Length-4));
			pRESP->CRC = (RxBuffer[pRESP->Length-2]<<8)|(RxBuffer[pRESP->Length-1]);
            return CMD_RET_OK;
        }
		else if(RET == COMM_RET_ERR){
            return CMD_RET_RXERR;
		}
	    else if(RET == COMM_RET_BUSY){
            return CMD_RET_TIMEOUT;
        }		 	 
    }
    

    return CMD_RET_TXERR;
    
}

/* ------------------- end of file  ---------------------- */
