//*************************************************************************************
// file			: SQ7515_CRC.c
// version		: V3.0
// brief		: CRC related functions
// note			: CRC related functions are collected in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char crc_in[16] = {            // values to be calculated using CRC
0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38};
//----------------------------------------------------------------------------------------
// array to keep the CRC information.
unsigned char crc_out[4];               // CRC calculation result

//-----------------------------------------------------------------------------------------
unsigned char result_crc[4] = {0x15, 0x90, 0x00, 0x00};     // correct CRC value for check if the calculated CRC value is correct


//*********************************************************************
// name			: CRC_Init()
// brief		: CRC initialization
// param		: 
// retval		:
// note			:
//*********************************************************************
void CRC_Init(void){
	
	PCKEN7_CRC = 1;                     // enable CRC
	CRCCR0 = 0x00;                      // init CRCCR0
}


//*********************************************************************
// name			: CRC_Start()
// brief		: start CRC
// param		: 
// retval		:
// note			:
//*********************************************************************
void CRC_Start(void){
	
	CRCCR1 = 0x02;                      // CRCCR1 needs to be set to 0x02 when the program is running
	CRCCR0 = 0x03;                      // start CRC , CRC initial value = 0xFFFFF
	
}
 

//*********************************************************************
// name			: CRC_Stop()
// brief		: stop CRC
// param		: 
// retval		:
// note			:
//*********************************************************************
void CRC_Stop(void){

	CRCCR0_CRCEN = 0;                   // stop CRC
} 


//*********************************************************************
// name			: CRC_Calculate()
// brief		: calculate CRC
// param		: 
// retval		:
// note			:
//*********************************************************************
unsigned int CRC_Calculate(unsigned char *pData, unsigned int len){

    unsigned int i;
    unsigned int crc;

    CRC_Start();
	
    for(i=0; i<len; i++){
       while(CRCCR0_DATARDY == 0);

	   CRCDI = *pData++;
    }
	
    while(CRCCR0_DATARDY == 0);

	crc = (CRCDO1 << 8)|CRCDO0;
    CRC_Stop();

	return crc;

}

//*********************************************************************
// name			: Check_CRC()
// brief		: check if the calculated CRC value is correct
// param		: 
// retval		:
// note			:
//*********************************************************************
unsigned char Check_CRC(unsigned char *crc_ref){

	unsigned char j;
	
	for(j=0;j< 4; j++){
		if (crc_ref[j] != crc_out[j]){  // if the calculated CRC is different from the correct CRC value, return 0
			return(0);
		}
	}
	
	return(1);                          // if the calculated CRC is the same as the correct CRC value, return 1
}	

/* ------------------- end of file  ---------------------- */
