//*************************************************************************************
// file			: SQ7515_SecureUnit_I2C_HAL.c
// version		: V1.0
// brief		: I2C hardware abstraction layer functions that control SecureUnit
// note			:
//**************************************************************************************
#include "main.h"


//*********************************************************************
// name			: I2C_Data_Transmit()
// brief		: write data to SecureUnit via I2C
// param		: wBuffer - pointer to the data buffer to be written
//            Length  - length of datato be written
// retval		: I2C HAL result
// note			: 
//*********************************************************************
I2C_HAL_Ret I2C_Data_Transmit(uint8_t* Wbuffer, uint8_t Length)
{
    I2C_MasterPacket i2c_master;

    i2c_master.adr = SLAVE_ADDR;
    i2c_master.len = Length;
	i2c_master.pBuf = Wbuffer; 
	
    if(I2C_Master_Write(I2C_CHANNEL,&i2c_master)==0){
        return I2C_HAL_RET_NACK;
    }

	return I2C_HAL_RET_OK;		
	
}

//*********************************************************************
// name			: I2C_Data_Receive()
// brief		: receive data from SecureUnit via I2C
// param		: Rbuffer - pointer to the receive buffer
// retval		: I2C HAL result
// note			: 
//*********************************************************************
I2C_HAL_Ret I2C_Data_Receive(uint8_t* Rbuffer)
{    
    I2C_MasterPacket i2c_master;
    unsigned char rdsr[4]={0x04,0xF0,0x3E,0xD4}; 

    i2c_master.adr = SLAVE_ADDR;
    i2c_master.len = 4;
	i2c_master.pBuf = rdsr; 

    if(I2C_Master_Write(I2C_CHANNEL,&i2c_master)==0){
        return I2C_HAL_RET_NACK;
    }

    i2c_master.adr = SLAVE_ADDR;
 	i2c_master.pBuf = Rbuffer; 
	
    if(I2C_Master_Read(I2C_CHANNEL,&i2c_master)==0){
		return I2C_HAL_RET_NACK;
    }

	return I2C_HAL_RET_OK;

}

/* ------------------- end of file  ---------------------- */

