//*************************************************************************************
// file			: SQ7515_SecureUnit.h
// version		: V1.0 2022/05/25
// brief		:
// note			:
//**************************************************************************************
#ifndef _SQ7515_SECURE_UNIT_H__
#define _SQ7515_SECURE_UNIT_H__

#include "main.h"


/*------------------CRC--------------------------------------------*/
#define HW_CRC                          // calculate CRC by hardware

#ifndef HW_CRC
#define CRC16_DNP	    0x3D65		    // DNP, IEC 870, M-BUS, wM-BUS, ...
#define CRC16_CCITT	    0x1021          // X.25, V.41, HDLC FCS, Bluetooth, ...
#define POLYNOM		    CRC16_CCITT     // define the polynomial
#endif
/*-------------------------------------------------------------------*/

/*-------------------SecureUnit command opcode define--------------------------*/
#define OpCode_Reset         0x00
#define OpCode_Nonce         0x01
#define OpCode_Random        0x02
#define OpCode_Auth          0x03
#define OpCode_EncRead       0x04
#define OpCode_EncWrite      0x05   
#define OpCode_Encrypt       0x06
#define OpCode_Decrypt       0x07
#define OpCode_Counter       0x0A
#define OpCode_INFO          0x0C
#define OpCode_Lock          0x0D
#define OpCode_KeyCreate     0x08
#define OpCode_KeyImport     0x19
#define OpCode_KeyLoad       0x09
#define OpCode_KeyTransfer   0x1A

#define OpCode_SetIV         0x0E
#define OpCode_Legacy        0x0F
#define OpCode_BlockRead     0x10
#define OpCode_Sleep      	 0x11
#define OpCode_NonceCompute  0x13
#define OpCode_AuthCompute   0x14
#define OpCode_AuthCheck     0x15
#define OpCode_WriteCompute  0x16
#define OpCode_DecRead       0x17
#define OpCode_RDSR          0xF0
#define OpCode_Aort          0xF1
#define OpCode_Wakeup        0xF2
#define OpCode_BlockWrite    0xF3
#define OpCode_SHA           0x47 

/*-----------------------------------------------------------------*/


typedef struct 
{
   uint8_t   Length;
   uint8_t   Opcode;
   uint8_t   Mode;
   uint16_t  Param1;
   uint16_t  Param2;
   uint8_t   Length_H;
   uint8_t   Length_L;	
   uint8_t*  pDIN;
}SecureUnit_Command_Packet;


typedef struct
{
   uint8_t   Length;
   uint8_t   CMDST;
   uint8_t   DOUT[32];
   uint16_t  CRC;
}SecureUnit_Response_Packet;


typedef enum
{
  I2C_HAL_RET_OK=0x00u,
  I2C_HAL_RET_NACK=0x01u	
  
}I2C_HAL_Ret;

typedef enum
{
  SPI_HAL_RET_OK=0x00u,
  SPI_HAL_RET_ERR=0x01u	
  
}SPI_HAL_Ret;


typedef enum
{
  COMM_RET_OK=0x00u,     
  COMM_RET_ERR=0x01u,
  COMM_RET_BUSY=0x02u
}Comm_Ret;


typedef enum
{
  CMD_RET_OK=0x00u,
  CMD_RET_TIMEOUT=0x01u,
  CMD_RET_TXERR=0x02u,
  CMD_RET_RXERR=0x03u
}SecureUnit_Cmd_Ret;


extern uint8_t TxBuffer[];
extern uint8_t RxBuffer[];

I2C_HAL_Ret I2C_Data_Transmit(uint8_t* Wbuffer, uint8_t Length);
I2C_HAL_Ret I2C_Data_Receive(uint8_t* Rbuffer);

//uint16_t CRC_Calculate(uint8_t *Data, uint16_t len);
uint16_t SecureUnit_CRC_Calculate(uint8_t *pData, uint16_t len);
void Command_Buffer_Prepare(SecureUnit_Command_Packet* pCMD, uint8_t* pBuff);
Comm_Ret Command_Send(uint8_t* wBuff, uint8_t wCnt);
Comm_Ret Response_Receive(uint8_t* rBuff);
Comm_Ret Command_Send_And_Receive(uint8_t* wBuff, uint8_t wCnt, uint8_t* rBuff);

SecureUnit_Cmd_Ret SecureUnit_Command_Execute(SecureUnit_Command_Packet* pCMD ,SecureUnit_Response_Packet* pRESP);

#endif // _SQ7515_SECURE_UNIT_H__

