//*************************************************************************************
// file			: SQ7515_RTC.h
// version		: V1.0
// brief		: RTC header file
// note			: 
//**************************************************************************************
#ifndef _SQ7515_RTC_H__
#define _SQ7515_RTC_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned char RTC_1sec_actFlag;			  // flag for second interrupt
extern unsigned char RTC_alarm_actFlag;			  // flag for alarm interrupt
extern unsigned char RTC_timeover_actFlag;	      // flag for overtime interrupt	



/* ---------------------- user-defined macros ------------------------------ */
#define RTC_TIE    0x08
#define RTC_SIE    0x04
#define RTC_AIE    0x02
#define RTC_WREIE  0x01

// user-defined type for perpetual calendar time
typedef struct{				
    unsigned char sec;							  // second
	unsigned char min;							  // minute
	unsigned char hour;							  // hour
	unsigned char day;							  // day
	unsigned char week;							  // day of the week
	unsigned char mon;							  // month
	unsigned char year;							  // year
}RTC_PERPETUAL_CALENDAR_TIME;
// user-defined type for alarm time
typedef struct{
    unsigned char min;							  // minute
	unsigned char hour;						  	  // hour
	unsigned char day;							  // day
	unsigned char week;							  // day of thr week
}RTC_ALARM;



//------------------------------------------------------------------
void RTC_Setup();
void Alarm_Setup();
void RTC_Init();									  //  RTC initialization
void RTC_SetDate(RTC_Perpetual_Calendar_Time* prtc); // set current time
void RTC_SetAlarm(RTC_ALARM* palarm);                // set alarm time
void RTC_Refresh(RTC_Perpetual_Calendar_Time* prtc); // RTC refresh RTC time
void RTC_Output(void);                        		// RTC clock output
void RTC_IntEnable(unsigned char intsel,unsigned char enable); // enable RTC interrupt
void RTC_IntDisable(); 					 			  // disable RTC interrupt
void RTC_Start(void);                   			  // start RTC
void RTC_Stop(void);                    			  // stop RTC
void RTC_TimerSetAndEnable(void);       			  // set RTC function
void RTC_TimerStart(void);              			  // enable RTC timer function
void RTC_TimerStop(void);               			  // disable RTC timer function
void __interrupt IntRTC(void);			 			  // RTC interrupt service routine

#endif

