//*************************************************************************************
// file			: SQ7515_UART.h
// version		: V3.1
// brief		: UART header file
// note			: 
//**************************************************************************************
#ifndef _SQ7515_UART_H__
#define _SQ7515_UART_H__

#define BIT0  0x0001
#define BIT1  0x0002
#define BIT2  0x0004
#define BIT3  0x0008
#define BIT4  0x0010
#define BIT5  0x0020
#define BIT6  0x0040
#define BIT7  0x0080
#define BIT8  0x0100
#define BIT9  0x0200
#define BIT10 0x0400
#define BIT11 0x0800
#define BIT12 0x1000
#define BIT13 0x2000
#define BIT14 0x4000
#define BIT15 0x8000

#define UART_0    0
#define UART_1    1
#define UART_2    2

#define STOPbit_1bit    0x00
#define STOPbit_2bit    0x01

#define UART_PE_NONE    0x00
#define UART_PE_ODD     0x01
#define UART_PE_EVEN    0x03

#define UART_TXEn	 0x80
#define UART_RXEn    0x40

#define UARTSR_PERR    BIT7
#define UARTSR_FERR    BIT6
#define UARTSR_OERR    BIT5
#define UARTSR_RBSY    BIT3
#define UARTSR_RBFL    BIT2
#define UARTSR_TBSY    BIT1
#define UARTSR_TBFL    BIT0

// SYSCLK@1MHZ
#define SYSCLK_1MHZ_BAUD_4800		0
#define SYSCLK_1MHZ_BAUD_9600		1
#define SYSCLK_1MHZ_BAUD_19200		2
#define SYSCLK_1MHZ_BAUD_57600		3

// SYSCLK@2MHZ
#define SYSCLK_2MHZ_BAUD_4800		4
#define SYSCLK_2MHZ_BAUD_9600		5
#define SYSCLK_2MHZ_BAUD_19200		6
#define SYSCLK_2MHZ_BAUD_57600		7
#define SYSCLK_2MHZ_BAUD_115200		8
#define SYSCLK_2MHZ_BAUD_128000		9

// SYSCLK@4MHZ
#define SYSCLK_4MHZ_BAUD_4800		10
#define SYSCLK_4MHZ_BAUD_9600		11
#define SYSCLK_4MHZ_BAUD_19200		12
#define SYSCLK_4MHZ_BAUD_57600		13
#define SYSCLK_4MHZ_BAUD_115200		14
#define SYSCLK_4MHZ_BAUD_128000		15

// SYSCLK@8MHZ
#define SYSCLK_8MHZ_BAUD_4800		16
#define SYSCLK_8MHZ_BAUD_9600		17
#define SYSCLK_8MHZ_BAUD_19200		18
#define SYSCLK_8MHZ_BAUD_57600		19
#define SYSCLK_8MHZ_BAUD_115200		20
#define SYSCLK_8MHZ_BAUD_128000		21

// SYSCLK@12MHZ
#define SYSCLK_12MHZ_BAUD_4800		22
#define SYSCLK_12MHZ_BAUD_9600		23
#define SYSCLK_12MHZ_BAUD_19200		24
#define SYSCLK_12MHZ_BAUD_57600		25
#define SYSCLK_12MHZ_BAUD_115200	26
#define SYSCLK_12MHZ_BAUD_128000	27

// SYSCLK@16MHZ
#define SYSCLK_16MHZ_BAUD_4800		28
#define SYSCLK_16MHZ_BAUD_9600		29
#define SYSCLK_16MHZ_BAUD_19200		30
#define SYSCLK_16MHZ_BAUD_57600		31
#define SYSCLK_16MHZ_BAUD_115200	32
#define SYSCLK_16MHZ_BAUD_128000	33
#define SYSCLK_16MHZ_BAUD_256000	34

// SYSCLK@24MHZ
#define SYSCLK_24MHZ_BAUD_9600		35
#define SYSCLK_24MHZ_BAUD_19200		36
#define SYSCLK_24MHZ_BAUD_57600		37
#define SYSCLK_24MHZ_BAUD_115200	38
#define SYSCLK_24MHZ_BAUD_128000	39
#define SYSCLK_24MHZ_BAUD_256000	40


//--- UARTx initialization ---
void UART0_Init();
void UART1_Init();
void UART2_Init();

//--- enable UARTx interrupt ---
void UART0_IntEnable();
void UART1_IntEnable();
void UART2_IntEnable();

//--- set UARTx Baud rate --
void UART0_SetBaud rate(unsigned char baudSel);
void UART1_SetBaud rate(unsigned char baudSel);
void UART2_SetBaud rate(unsigned char baudSel);

//--- enable or disable UARTx ---
void UART0_Start();
void UART0_Stop();

void UART1_Start();
void UART1_Stop();

void UART2_Start();
void UART2_Stop();

//--- TX transmits a single byte ---
void UART0_TX_OneByte(unsigned char data);
void UART1_TX_OneByte(unsigned char data);
void UART2_TX_OneByte(unsigned char data);

//--- RX receives a single byte ---
unsigned char UART0_RX_OneByte();
unsigned char UART1_RX_OneByte();
unsigned char UART2_RX_OneByte();

//------------------------------------------------------------------
//--- UARTx initialization within parameter(s) ---
void UART_Init(unsigned char uart,unsigned char parity_en,unsigned char parity,unsigned char stopBit);

//--- enable UARTx interrupt within parameter(s) ---
void UART_IntEnable(unsigned char uart,unsigned char TRx_en);

//--- set UARTx Baud rate within parameter(s)--
void UART_SetBaud rate(unsigned char uart,unsigned char baudSel);

//--- enable or disable UARTx within parameter(s)---
void UART_Start(unsigned char uart, unsigned char uartEn);
void UART_Stop(unsigned char uart,unsigned char uartEn);

//--- read UARTx state within parameter(s)---
unsigned char UART_ReadState(unsigned char uart);

//--- TX transmits a single byte within parameter(s)---
void UART_TX_OneByte(unsigned char uart,unsigned char data);

//--- RX receives a single byte within parameter(s)---
unsigned char UART_RX_OneByte(unsigned char uart);


//--- TX transmits a single byte within parameter(s)---
// *when the data to be transferred is more than 1 Byte, user set the datar length size*//
void UART_Send(unsigned char uart,unsigned char* buf, unsigned char len);

//--- UARTx receive data within parameter(s)---
unsigned char UART_Recive(unsigned char uart);

//--- get the high and low nibbles converted to ASCII with in parameter(s), then TX transfer---
void UART_PutByte(unsigned char uart,unsigned char abyte);


void UART_PutDecNumber(unsigned int value);


//--- transmit line break characters ---
void UART_PutCrlf(void);

//--- send CString ---
void UART_SendCString(const char *pstr);

void UART_SendHex(uint8_t *pHex, uint8_t Count);


//--- interrupt service routine ---
void __interrupt IntRX0(void);
void __interrupt IntRX1(void);
void __interrupt IntRX2(void);

void __interrupt IntTX0(void);
void __interrupt IntTX1(void);
void __interrupt IntTX2(void);

#endif