//*************************************************************************************
// file			: SQ7515_MAC.c
// version		: V1.0
// brief		: MAC related functions
// note			: MAC related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char MAC_Int_Flag;		   // MAC interrupt flag

//*********************************************************************
// name			: MAC_Init()
// brief		: initialize MAC
// note			: 
//*********************************************************************
void MAC_Init(){
	PCKEN5_MAC = 1;	                    	  // enable MAC
	MACCR0_SIGN = 0;                    	  // unsigned
	MACCR0_SAT = 1;                     	  // enable saturation mode
}


//*********************************************************************
// name			: MAC_IntEnable()
// brief		: enable MAC interrupt
// note			: 
//*********************************************************************
void MAC_IntEnable(){
	__ASM("DI");							  // disable all maskable interrupts
	
	IER_MAC = 1;                       	  	  // enable MAC interrupt
	
	__ASM("EI");							  // enable all maskable interrupts
}

//*********************************************************************
// name			: __interrupt IntMAC()
// brief		: MAC interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntMAC(void){
	__asm("NOP");							  // no operation
	MAC_Int_Flag = 1;						  // clear MAC interrupt flag

}


