//*************************************************************************************
// file			: SQ7515_LVD.c
// version		: V1.0
// brief		: LVD related functions
// note			: LVD related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"


//*********************************************************************
// name			: LVD_Init()
// brief		: LVD initialization
// note			: 
//*********************************************************************
void LVD_Init(){
	LVDCR_LVDCFG = 0x02;                	  // set detection voltage to 2.65V
	
}


//*********************************************************************
// name			: LVD_IntEnable()
// brief		: start LVD interrupt
// note			: 
//*********************************************************************
void LVD_IntEnable(){
	__ASM("DI");
	IER_LVD = 1;                        	  // enable interrupt enable register of LVD
	LVDCR_LVDIEN = 1;                   	  // enable LVD interrupt
	__ASM("EI");
}


//*********************************************************************
// name			: LVD_Start()
// brief		: start LVD
// note			: 
//*********************************************************************
void LVD_Start(){
	LVDCR_LVDEN = 1;						  // enable LVD
}


//*********************************************************************
// name			: LVD_Stop()
// brief		: stop LVD
// note			: 
//*********************************************************************
void LVD_Stop(){
	LVDCR_LVDEN = 0;						   // disable LVD
}


//*********************************************************************
// name			: __interrupt IntLVD()
// brief		: IntLVD interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntLVD(void){
	__asm("NOP");							  // no operation

}

