//*************************************************************************************
// file			: SQ7515_TCA.c
// version		: V1.0
// brief		: 16BIT TCA0 related functions
// note			: 16BIT_TCA0 related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char TCA0_Int_Flag;		  	// TCA0 interrupt flag

//*********************************************************************
// name			: TCA0_Init()
// brief		: TCA0 initialization
// note			: 
//*********************************************************************
void TCA0_Init(){
//====== enable function ======
	PCKEN0_TCA0 = 1;                    // enable TCA0  *this must be enabled first, the relevant staging settings later to be useful
//====== parameter setting ======	
	TA0MOD_TAM 	= 0x00;                 // set TCA0 to timer mode
    TA0MOD_TACK = 0x00;                 // select timer source clock to fcgck/1024 (24Mz / 1024 = 23437.5Hz, about 0.0426ms)
}


//*********************************************************************
// name			: TCA0_IntEnable()
// brief		: enable TCA0 interrupt
// note			: 
//*********************************************************************
void TCA0_IntEnable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TCA0 = 1;                       // enable TCA0 interrupt
	//TA0CR_TAOVE = 0;                  // generate no TCA0 interrupt request when the counter overflow occurs
	TA0CR_TAOVE = 1;                    // generate a TCA0 interrupt request when the counter overflow occurs
	__ASM("EI");						// enable all maskable interrupts
}


//*********************************************************************
// name			: TCA0_SetPeriod()
// brief		: set TCA0 timer counter
// note			: 
//*********************************************************************
void TCA0_SetPeriod(unsigned int period){	
	TA0DRAL = period&0xFF;              // set timer counter
	TA0DRAH = (period>>8)&0xFF;
}


//*********************************************************************
// name			: TCA0_Start()
// brief		: start TCA0
// note			: 
//*********************************************************************
void TCA0_Start(){
	TA0CR_TAS = 1;                      // start TCA0
}


//*********************************************************************
// name			: TCA0_Stop()
// brief		: stop TCA0
// note			: 
//*********************************************************************
void TCA0_Stop(){
	TA0CR_TAS = 0;                      // stop and clear TCA0
}


//*********************************************************************
// name			: __interrupt IntTCA0()
// brief		: TCA0 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTCA0(void){
	__asm("NOP");						// no operation
	TCA0_Int_Flag = 1;					// set TCA0_Int_Flag to 1
	
	
}

