//*************************************************************************************
// file			: SQ7515_FMC.c
// version		: V1.0
// brief		: FMC related functions
// note			: FMC related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"


//*********************************************************************
// name			: FMC_Init()
// brief		: FMC initialization
// note			: 
      
//*********************************************************************
void FMC_Init(unsigned char sysclk)
{
	FCKDIV = sysclk - 1;
}

//*********************************************************************
// name			: FMC_PageErase()
// brief		: Flash page erase
// retval		: 0: erase successfully  
//            	  1: erase failed  
// note			: 
//*********************************************************************
unsigned char FMC_PageErase(unsigned int address)
{
    unsigned char status,tmp8;
	unsigned int  iAddr,startAddr,endAddr;
	
	FADDR0 = (unsigned char)address & 0x00FF;        	// set address register
	FADDR1 = (unsigned char)(address >> 8) & 0x00FF;
	
	FCR0_FCMD = 0x02;                                	// page erase
	
	do{	                                             	// wait for page erase to finish
	    status = FCR1;
        status &= 0x80; 		  
	}while(status);

	startAddr 	= address & 0xfe00;
	endAddr		= address | 0x01ff;	
	for(iAddr=startAddr;iAddr <=endAddr ;iAddr++){
		FMC_ReadByte(iAddr,&tmp8);	
		if( tmp8!= 0xff){
			return 1;									
		}
	}
	
	return 0;
}

//*********************************************************************
// name			: FMC_WriteByte()
// brief		: write one byte of flash data
// retval		: 0: write successfully  
//            	  1: write failed   
// note			: 
//*********************************************************************
unsigned char FMC_WriteByte(unsigned int address, unsigned char data)
{
	unsigned char status,tmp8;

	FMC_ReadByte(address,&tmp8);	
	if( tmp8 != 0xff)
		return 2;									   	// not 0xFF
	
	FCR0_DATASZ0 = 0x00;    						   	// set data length to byte
		
	FDATA0 = data;                                     	// write data to buffer 
	
	FADDR0 = (unsigned char)address & 0x00FF;         // set address
	FADDR1 = (unsigned char)(address >> 8) & 0x00FF;
	 
	FCR0_FCMD = 0x01;                                  	// write data 
	
	do{                                                 // wait for write data to finish
	    status = FCR1;
        status &= 0x80; 		  
	}while(status);
	
	FMC_ReadByte(address,&tmp8);	
	if( tmp8 != data)
		return 1;										// write failed 
	
	
	return 0;											// write successfully
	
}


//*********************************************************************
// name			: FMC_ReadByte()
// brief		: read one byte of flash data
// note			: 
//*********************************************************************
void FMC_ReadByte(unsigned int address, unsigned char* data)
{
	FADDR0 = (unsigned char)address & 0x00FF;         // set address register
	FADDR1 = (unsigned char)(address >> 8) & 0x00FF;
   
    FCR0_FCMD = 0x00;                                   // set data read command        
	*data = FDATA0;                                     // read out data register

}


//*********************************************************************
// name			: FMC_IntEnable()
// brief		: enable FMC interrupt
// note			: 
//*********************************************************************
void FMC_IntEnable(){
	__ASM("DI");						// enable all maskable interrupts
	IER_FMC = 1;                   		// enable FMC interrupt
	__ASM("EI");						// enable all maskable interrupts
}


//*********************************************************************
// name			: __interrupt IntFMC()
// brief		: FMC interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntFMC(void)
{
	__asm("NOP");						// no operation

}



