//*************************************************************************************
// file			: main.h
// version		: V1.0 2022/05/18
// brief		: header file of this example
// note			: the custom variables used are collected in this document in this header file
//**************************************************************************************

#ifndef _INCLUDES_H__
#define _INCLUDES_H__

/* ---------------------- reference header files ------------------------------ */
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "SQ7515_SFR.h"
#include "SQ7515_Delay_Loop.h"           

/* ---------------------- user-defined macros ------------------------------ */
#define BTN1_in    P3DI_P0
#define BTN2_in    P3DI_P1
#define BTN3_in    P3DI_P2

#define LED1_out   P2DO_P0		  	     // define LED1_out as P2.0 output
#define LED2_out   P3DO_P7		  	     // define LED2_out as P3.7 output
#define LED3_out   P3DO_P6               // define LED3_out as P3.6 output

#define LED1_to_LED3_turn_off() {                      \
                                    LED1_out = 1;      \
                                    LED2_out = 1;      \
                                    LED3_out = 1;      \
                                }

#define LED1_to_LED3_turn_on()  {                      \
                                    LED1_out = 0;      \
                                    LED2_out = 0;      \
                                    LED3_out = 0;      \
                                }

/* ---------------------- extern global variables ------------------------- */






/* ---------------------- extern functions ------------------------ */
extern void STARTUP(void);


#endif //#ifndef _INCLUDES_H__

