//*************************************************************************************
// file			: SQ7515_CRC.h
// version		: V1.1
// brief		: CRC header file
// note			: 
//**************************************************************************************
#ifndef _SQ7515_CRC_H__
#define _SQ7515_CRC_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned char crc_in[8];         // values to be calculated using CRC
extern unsigned char crc_out[2];        // CRC calculation result
extern unsigned char result_crc[2];     // correct CRC value for check if the calculated CRC value is correct


/* ---------------------- user-defined macros ------------------------------ */

#define CRC_ALGO_CCITT_TRUE     0x01    // ʽֵ0x1021, ʼֵ: 0x0000
#define CRC_ALGO_CCITT_FALSE    0x03    // ʽֵ0x1021, ʼֵ: 0xFFFF (*For SecureUnit.)


//------------------------------------------------------------------
void CRC_Init(void);					        	    // CRC initialization
unsigned char  Check_CRC(unsigned char *crc_ref);       // check if the calculated CRC value is correct
unsigned short CRC_Calculate(unsigned char algo, unsigned char *bpBuff, unsigned short len);


#endif // _SQ7515_CRC_H__
