//*************************************************************************************
// file			: SQ7515_CRC.c
// version		: V1.1
// brief		: CRC related functions
// note			: CRC related functions are collected in this subroutine
//**************************************************************************************
#include "main.h"


unsigned char crc_in[8] = {                     // values to be calculated using CRC
    0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
};

//----------------------------------------------------------------------------------------
unsigned char crc_out[2];                       // CRC calculation result

//-----------------------------------------------------------------------------------------
unsigned char result_crc[2] = {0x15, 0x90};     // correct CRC value for check if the calculated CRC value is correct


//*********************************************************************
// name			: CRC_Init()
// brief		: CRC initialization
// param		: none
// retval		: none
// note			:
//*********************************************************************
void CRC_Init(void){
	
    PCKEN7_CRC = 1;                     // enable CRC
    CRCCR0 = 0x00;                      // init CRCCR0
}

//*********************************************************************
// name			: CRC_Calculate()
// brief		: calculate CRC
// param		: algo:     algorithm selection (CRC_ALGO_CCITT_TRUE/CRC_ALGO_CCITT_FALSE)
//            	  bpBuff:   data buffer
//            	  len:      length of data buffer
// retval		: 16 bits CRC calculation result
// note			:
//*********************************************************************
unsigned short CRC_Calculate(unsigned char algo, unsigned char *bpBuff, unsigned short len){

    unsigned short i;

    //-------------------
    // CRC start.
    //-------------------
    CRCCR1 = 0x02;                      // CRCCR1 needs to be set to 0x02 when the program is running
    CRCCR0 = algo;                      // start CRC

    //-------------------
    // CRC data in.
    //-------------------
    for(i=0; i<len; i++){
        while(Is_CRC_Busy());           // wait for CRCCR0_DATARDY to be 1
        CRCDI = bpBuff[i];              // write to CRC 8-bit input register
    }

    while(Is_CRC_Busy());               // wait for CRCCR0_DATARDY to be 1 

    //-------------------
    // CRC get result.
    //-------------------
    ((BIT_LIST_16 *)&i)->byte[0] = CRCDO0;    // need to read CRCDO0 first, then CRCDO1
    ((BIT_LIST_16 *)&i)->byte[1] = CRCDO1;
    
    //-------------------
    // CRC stop.
    //-------------------
    CRCCR0_CRCEN = 0;                   // stop CRC

    return i;
}


//*********************************************************************
// name			: Check_CRC()
// brief		: check if the calculated CRC value is correct
// input 		: crc_ref:   data buffer
// retval		: 0: not correct, 1: correct
// note			:
//*********************************************************************
unsigned char Check_CRC(unsigned char *crc_ref){

    unsigned char j;

    for(j=0; j<sizeof(crc_out); j++){
        if (crc_ref[j] != crc_out[j]){  // if the calculated CRC is different from the correct CRC value, return 0
            return 0;
        }
    }

	return 1;                           // if the calculated CRC is the same as the correct CRC value, return 1
}

/* ------------------- end of file  ---------------------- */
