//SQ7515_ADC_LVCMP (ADC level comparison) example
//*************************************************************************************
// file			: main.c
// version		: V1.0 2022/05/23
// brief		: main program
// description	: When the AIN voltage meets the threshold condition for ADC level comparison, an ADC level comparison interrupt is generated and P2.0 output level is reversed.
//			  
// note	 		: connect P1.6 (AIN_1) to the measured voltage
// 
//			  * If the reference voltage does not use this example (3.090V),
//              you need to modify the program to convert the voltage unit according to your needs in __interrupt ADC_IRQ() ofin SQ7515_ADC_LVCMP.c.
//              ain1_mv = (ADC_Code_READ*ADC_RefScale(actual VDD voltage))/1000;
//
//			  [LED Configuration]	 LED1 (P2.0)
//
// example		:
// ain1_mv = (ADC_Code_READ*ADC_RefScale(3090000))/1000;  // ADC value is converted into unit of milli-volt if VDD voltage is 3.09V
// ain1_mv = (ADC_Code_READ*ADC_RefScale(5000000))/1000;  // ADC value is converted into unit of milli-volt if VDD voltage is 5.00V
//
// SQ7515  Ain1
// ADC refernce	: Vref = VDD	about 3.09V
// sampling mode: Single mode
// interrupt source	: ADC level comparison
//
// ADC Level Compare Threshold
// Top_Thres	:4000
// Bottom_Thres	:1000
//**************************************************************************************

#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */
unsigned char r_temp_pre_load[2];            // store the ADC values that do not reach the threshold   
int i;                                        // for Delay loop

/* ----------------------- main program --------------------------- */
void main(){

    ADCLVCMP_Int_Flag  = 0;
/* ---------------------- system initialization ------------------------ */
    PLLCR0_PLLEN  = 1;                  // enable PLL
    while(PLLCR0_PLLRDY ==0);           // wait for PLL to be ready
    CLKCR0_SCKPSC = 1;                  // system frequency divided by 2   (48M/2=24MHz) 
    CLKCR0_SCKSRC = 1;                  // switch clock source to PLL
    while(CLKCR0_SCKRDY ==0);           // wait for system clock to be ready
/* ---------------------- pin configuration initialization ------------------------ */
    P0PU = 0xFF;                        // enable all built-in pull-up resistors
    P1PU = 0xFF;
    P2PU = 0xFF;
    P3PU = 0xFF;
    P4PU = 0xFF;
    P5PU = 0xFF;

    P2OE_P0 = 1;                        // set P2.0 as output pin
    P2PU_P0 = 0;                        // disable P2.0 built-in pull-up resistor

    LED1_out = 1;                       // set LED1 to the light off
/* ---------------------- ADC initialization --------------- */
    ADC_Init();	                        // ADC initialization
    ADCLVLCMP_Init(CMP_ADCL_BETWEEN);   // ADC level comparison initialization, ADCLLV > ADC value > ADCHLV
    ADCLVLCMP_SetTh(4000,1000);         // set ADC level comparison threshold
    //ADC_IntEnable();
    ADC_IntDisable();                   // disable ADC interrupt
    ADCLVLCMP_IntEnable();              // enable ADC level comparison interrupt
	
	while(1){		
        CLR_WDT;                        // clear the watchdog timer 
     
        ADC_Convert_Single();           // wait for ADC to be ready, start ADC single mode

        /* read the ADC values that do not meet the threshold condition for ADC level comparison for subsequent ADC readings when the threshold for level comparison is reached.
           if the ADC data buffer auto overwrite is not enabled in the program (ADCSR_BUFOVR = 1), ADC values that do not reach the threshold must be read out.*/
        //while(!ADC_ConvertDone());   
        ADCCHSEL_CHSEL = 0x1;           // set Ain1 and then read ADCDRL and ADCDRH
        r_temp_pre_load[0] = ADCDRL;    // when reading ADC value,  read low byte first and then read high byte
        r_temp_pre_load[1] = ADCDRH;

        for(i=0;i<6500;i++){            // wait for a while

        }

        __asm("NOP");                   // no operation   
    }
}


/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void){
    __asm("NOP");                       // no operation
}

void __interrupt_n OnlyRetn(void){
    __asm("NOP");                       // no operation
}

void __interrupt_n IntWDT(void){
    __asm("NOP");                       // no operation
}

void __interrupt_n IntSWI(void){        // software reset interrupt service routine
    PRSTR7 = 0x5a;
    PRSTR7 = 0xa5;
    PRSTR7 = 0xc3;
    PRSTR7 = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */


/* -------------------- SQ7515 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 0xff40
void * const IntTbl1[] = {											
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : IntTCA7			*/	//interrupt source:TCA7 16-bit timer								
	OnlyReti,				/* 0xff5a : IntTCA6			*/	//interrupt source:TCA6 16-bit timer							
	OnlyReti,				/* 0xff5c : Reserved		*/									
	OnlyReti,				/* 0xff5e : Reserved		*/									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved		*/									
	OnlyReti,				/* 0xff6c : IntTX2			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : IntRX2			*/	//interrupt source:UART2 RX2							
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : IntTCA5			*/	//interrupt source:TCA5 16-bit timer								
	OnlyReti,				/* 0xff78 : IntTCA4			*/	//interrupt source:TCA4 16-bit timer								
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/									
	OnlyReti,		    	/* 0xff82 : Reserved		*/									
	OnlyReti,	    		/* 0xff84 : Reserved		*/									
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	OnlyReti,				/* 0xff8c : IntSIO1			*/	//interrupt source:SIO 1								
	OnlyReti,				/* 0xff8e : IntI2C1			*/	//interrupt source:I2C1						
	OnlyReti,				/* 0xff90 : IntTX1			*/	//interrupt source:UART1 TX1							
	OnlyReti,				/* 0xff92 : IntRX1			*/	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : Reserved		*/									
	OnlyReti,				/* 0xff9a : IntTCA3			*/	//interrupt source:TCA3 16-bit timer							
	OnlyReti,				/* 0xff9c : IntTCA2			*/	//interrupt source:TCA2 16-bit timer								
	OnlyReti,				/* 0xff9e : Reserved		*/									
	OnlyReti,				/* 0xffa0 : IntMAC			*/	//interrupt source:multiplier								
	OnlyReti,				/* 0xffa2 : IntEXT7			*/	//external interrupt7								
	OnlyReti,				/* 0xffa4 : IntEXT6			*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : IntEXT5			*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : IntEXT4			*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/							
	OnlyReti,				/* 0xffb0 : IntDIC			*/	//interrupt source:DIC								
	OnlyReti,				/* 0xffb2 : Reserved		*/							
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : IntFMC			*/	//interrupt source:flash memory controller								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : Reserved		*/									
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	IntADC,               	/* 0xffce : IntADC			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : IntEXT3			*/	//external interrupt3								
	OnlyReti,				/* 0xffd2 : IntEXT2			*/	//external interrupt2								
	OnlyReti,				/* 0xffd4 : IntEXT1			*/	//external interrupt1								
	OnlyReti,				/* 0xffd6 : IntEXT0			*/	//external interrupt0								
	OnlyReti,				/* 0xffd8 : IntSIO0			*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : IntI2C0			*/	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : IntTX0			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : IntRX0			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : Reserved		*/									
	OnlyReti,				/* 0xffe4 : Reserved		*/									
	OnlyReti,				/* 0xffe6 : IntTCA1			*/	//interrupt source:TCA1 16-bit timer								
	OnlyReti,				/* 0xffe8 : IntTCA0			*/	//interrupt source:TCA0 16-bit timer								
	OnlyReti,				/* 0xffea : Reserved		*/									
	OnlyReti,				/* 0xffec : Reserved		*/									
	OnlyReti,			    /* 0xffee : IntRTC			*/	//interrupt source:real-time clock timer								
	OnlyReti,				/* 0xfff0 : IntTBT			*/  //interrupt source:time base timer				
	OnlyReti,				/* 0xfff2 : Reserved		*/									
	OnlyReti,				/* 0xfff4 : IntCFD			*/	//interrupt source:clock fail detection								
	OnlyReti,				/* 0xfff6 : IntLVD			*/	//interrupt source:low voltage detection							
	IntWDT,					/* 0xfff8 : IntWDT			*/	//non-maskable interrupt source:watchdog timer		
	(void *)0xffff,			/* 0xfffa : Reserved		*/									
	IntSWI,					/* 0xfffc : IntSWI/INTUNDEF */	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7515 interrupt vector ---------------------- */

