//******************************************
//           This is a C Template file
//
//
//
//ע
//******************************************
#include "MQ6935.h"
#include "iApp.h"
#include "SIO.h"








//*********************************************************************
// 	: SIO_Init()
// 	:
// ע		:
//	--------:----------------------------------------------------------
//*********************************************************************
void SIO_Init(void)
{
	POFFCR2.bit.b0 = 1;

	__asm("DI");
//	ILL.bit.b6     = 0;
//	EIRL.bit.b6    = 1;		// INTSIO0
	ILH.bit.b7     = 0;
	EIRH.bit.b7    = 1;		// INTSIO0
	__asm("EI");

	SERSEL.byte = 0x01;		// SERSEL<SRSEL0>: Select UART0 or SIO0

	SIO0CR.byte	= set8bit(01111011);
	//...................|7.......| SIOEDGѡ񴥷

	//...................|.654....| SIOCKS clock 
	//...................|.654....| ------> 000fcgck/2^9
	//...................|.654....| ------> 001fcgck/2^6
	//...................|.654....| ------> 010fcgck/2^5
	//...................|.654....| ------> 011fcgck/2^4
	//...................|.654....| ------> 100fcgck/2^3
	//...................|.654....| ------> 101fcgck/2^2
	//...................|.654....| ------> 110fcgck/2^1 fs/2^3
	//...................|.654....| ------> 111ⲿ clock 

	//...................|....3...| SIODIRģʽ...
	//...................|....3...| ------> 0LSB ( bit0 ʼ)
	//...................|....3...| ------> 1MSB ( bit7 ʼ)

	//...................|.....2..| SIOSSIO /ָֹͣ
	//...................|.....2..| ------> 0ֹͣ(reserved stop)
	//...................|.....2..| ------> 1ʼ

	//...................|......10| SIOMSIO ģʽѡ
	//...................|......10| ------> 00ֹͣ(ǿֹͣ)
	//...................|......10| ------> 018 λģʽ
	//...................|......10| ------> 108 λģʽ
	//...................|......10| ------> 118 λͼģʽ


	P2CR.bit.b4 = 0;		// SI
	P2FC.bit.b4	= 1;

	P2CR.bit.b3 = 1;		// SO
	P2FC.bit.b3	= 1;

//	master mode ( SIOCKS=(000~110) ʱѡ²趨)
//	P2CR.bit.b5 = 1;
//	P2FC.bit.b5 = 1;		// SCLK
//	 SIO.h ĵУ
//	#define	SIO_SS_CR		P7CR.bit.b7
//	#define	SIO_SS_CSB		P7DR.bit.b7
//	SIO_SS_CR   = 1;
//	SIO_SS_CSB  = 1;		// SS

//	slave mode = use external clk ( SIOCKS=111 ʱѡ²趨)
	P2CR.bit.b5 = 0;
	P2FC.bit.b5 = 1;		// SCLK

}



//*********************************************************************
// 	: SIO_ByteSend()
// 	:
// ע		:
//	--------:----------------------------------------------------------
//*********************************************************************
void SIO_ByteSend(uchar *data, uchar len)
{
	uchar i;

	for( i=0; i<len; i++ )
	{
		SIO0BUF.byte = *data;					// Ƚд SIOBUF  SIO
		data++;

		if( i == 0 )							// һϴ
		{
			if( SIO0CR.bit.b2 == 0 )
			{
			//	SIO_SS_CSB = 0;					// SS(CSB) enable: ܽ
			//	delay_times(t_100us, 2);
				SIO0CR.bit.b2 = 1;				// SIOS SIO
			}
		}
		while( SIO0SR.bit.b2 == 1 )				// TBFLͶʱȴͻΪʱдһ
		{
		//	WDCDR.byte = 0x4e;					// clear wdt
		}
	}
//__asm("CPL (_P9DR).1");
	while( SIO0SR.bit.b6 == 1 )					// SEFȴһϴ
	{
	//	WDCDR.byte = 0x4e;						// clear wdt
	}
//__asm("CPL (_P9DR).1");

}



//*********************************************************************
// 	: SIO_ByteRead()
// 	:
// ע		:
//	--------:----------------------------------------------------------
//*********************************************************************
void SIO_ByteRead(uchar *data, uchar len)
{
	uchar i, dummy;

	for( i=0; i<len; i++ )
	{
		if( i == 0 )
		{
//__asm("CPL (_P8DR).1");

		//	 SIO ͬʱΪͼģʽ SIO ֮ǰ SIO0BUF дһ dummy data: 0xff
			if( ( SIO0CR.byte & 0x3 ) == 0x3 )
			{
				SIO0BUF.byte = 0xff;			//  SIO0BUF дһ dummy data: 0xff
				dummy = SIO0BUF.byte;			// read dummy data
			}
			else
			{
				dummy = SIO0BUF.byte;			// read dummy data
			}

			if( SIO0CR.bit.b2 == 0 )
			{
			//	SIO_SS_CSB = 0;					// SS(CSB) enable: ܽ
			//	delay_times(t_100us, 2);
				SIO0CR.bit.b2 = 1;				// SIOS SIO
			}
//__asm("CPL (_P8DR).1");
		}
		else
		{
//__asm("CPL (_P8DR).0");
			while( SIO0SR.bit.b4 == 0 )			// RENDBȴϣΪ 1 
			{
			//	WDCDR.byte = 0x4e;				// clear wdt
			}
//__asm("CPL (_P8DR).0");
			*data = SIO0BUF.byte;				// ȡ SIO0BUF
			data++;

			if( ( SIO0CR.byte & 0x3 ) == 0x3 )
			{
				SIO0BUF.byte = 0xff;			//  SIO0BUF дһ dummy data: 0xff
			}
		}
	}


//__asm("CPL (_P8DR).1");
	while( SIO0SR.bit.b4 == 0 )					// RENDBȴϣΪ 1 
	{
	//	WDCDR.byte = 0x4e;						// clear wdt
	}
//__asm("CPL (_P8DR).1");

//	һ֮ǰ reserved stopΪ MQ6812 ȡд SIOBUF ٴδ SIO clock
//__asm("CPL (_P8DR).0");
	SPI_Reserved_Stop_Wait();

//	һ֮ȡ
	*data = SIO0BUF.byte;						// ȡ SIO0BUF
	data++;
//__asm("CPL (_P8DR).0");

}




//*********************************************************************
// 	: SPI_Reserved_Stop_Wait()
// 	:
// ע		:  SIOS=0(ֹͣ SIO)(reserved stop) ж SIOF  (ȴ SIO ֹͣ)
//	--------:----------------------------------------------------------
//*********************************************************************
void SPI_Reserved_Stop_Wait(void)
{
	SIO0CR.bit.b2 = 0;				// SIOS=0: reserved stop

	while( SIO0SR.bit.b7 == 1 )		// SIOF: ȴ SIO ֹͣ(SIOF=0)
	{
	//	WDCDR.byte = 0x4e;			// clear wdt
	}

//	delay_times(t_100us, 2);
//	SIO_SS_CSB = 1;					// SS(CSB) disable: ܽ
}


















