/*****************************************************************
;*        Sample SFR/Vector File for TLCS-870/C1 Series          *
;*               Memory Style: Within 64K byte                   *
;*---------------------------------------------------------------*
;*  (C)Copyright TOSHIBA CORPORATION 2008  All rights reserved   *
;*****************************************************************/

#include "MQ6935.h"
#include "iApp.h"
#include "SIO.h"


extern uchar Device_ID[16];
extern uchar wBUF_data[16];
extern uchar rBUF_data[16];
extern uchar pLoop;
extern uchar Device_CMD;
extern uchar flag_CMD;

void startup(void);	//defined by startup.asm
/*========================================================
  [ Declare interrupt function ]
  ========================================================*/
void __interrupt Int0(void);
void __interrupt Int1(void);
void __interrupt Int2(void);
void __interrupt Int3(void);
void __interrupt Int4(void);
void __interrupt Int5(void);
void __interrupt IntTC00(void);
void __interrupt IntTC01(void);
void __interrupt IntTC02(void);
void __interrupt IntTC03(void);
void __interrupt IntTCC0T(void);
void __interrupt IntTCC0P(void);
void __interrupt IntTEMG0(void);
void __interrupt IntTCA0(void);
void __interrupt IntTCA1(void);
void __interrupt IntSBI0_SIO0(void);
void __interrupt IntRTC(void);
void __interrupt IntADC(void);
void __interrupt IntVLTD(void);
void __interrupt IntRXD0_SIO0(void);
void __interrupt IntTXD0(void);
void __interrupt IntRXD1(void);
void __interrupt IntTXD1(void);
void __interrupt IntRXD2(void);
void __interrupt IntTXD2(void);
void __interrupt IntTBT(void);
void __interrupt IntWUC(void);
void __interrupt_n IntWDT(void);
void __interrupt_n IntSWI(void);


/*========================================================
  [ Dummy function for interrupt ]
  ========================================================*/
void __interrupt		Int_dummy(void){ }
void __interrupt_n		Int_n_dummy(void){ }

/*========================================================
  [ Implement interrupt function]
  ========================================================*/

//----------<External interrupt	routine>
void __interrupt Int0(void)
{
	//Add your interrupt handler code here
}
void __interrupt Int1(void)
{
	//Add your interrupt handler code here
}
void __interrupt Int2(void)
{
	//Add your interrupt handler code here
}
void __interrupt Int3(void)
{
	//Add your interrupt handler code here
}
void __interrupt Int4(void)
{
	//	 P77 Ϊ 0 ʱ SIO 
		if( EINTCR4.bit.b4 == 0 )			//	INT4LVL: жʱ֮Ѷŵƽ
		{
			SIO0BUF.byte  = 0xff;
			SIO0CR.bit.b2 = 1;				// SIOS SIO
		}
	//	ֹͣ SIO 
		else
		{
			SIO0CR.byte  &= 0xfC;			// SIOM: 00 ǿֹͣ SIO
			SIO0CR.byte  |= 0x03;			// SIOM: Ϊͼģʽ
			flag_CMD      = 0x00;
			Device_CMD    = 0x00;
		}
	//Add your interrupt handler code here
}
void __interrupt Int5(void)
{
	//Add your interrupt handler code here
}

//----------<8 bit timer counter interrupt routine>
void __interrupt IntTC00(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTC01(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTC02(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTC03(void)
{
	//Add your interrupt handler code here
}

//----------<16 bit timer counter interrupt routine>
void __interrupt IntTCA0(void)
{
	//Add your interrupt handler code here
}

//----------<10 bit timer TCC series interrupt routine>
void __interrupt IntTCC0T(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTCC0P(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTEMG0(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTCA1(void)
{
	//Add your interrupt handler code here
}

//----------<Serial Bus/Synchronous Serial interrupt routine>
void __interrupt IntSBI0_SIO0(void)
{
	uchar tempBUF = 0xff;


	if( flag_CMD == 0x00 )						// ʼ SIO ֮һ CMD ж
	{
		tempBUF = SIO0BUF.byte;					// ȡ SIO0BUF

	//	 Master ˽յȡָ (0x9f) 󣬽ظ -> 0xaa -> 0x68 -> 0x12
		if( tempBUF == 0x9f )
		{
			Device_CMD = tempBUF;
			pLoop = 0;
			flag_CMD = 0xff;
		}
	//	 Master ˽յȡָ (0x03) 󣬽ظ 10  rBUF_data[0] ~ rBUF_data[9] ֮
		else if( tempBUF == 0x03 )
		{
			Device_CMD = tempBUF;
			pLoop = 0;
			flag_CMD = 0xff;
		}
	//	 Master ˽յдָ (0x02) 󣬽յظд rBUF_data[0] ~ rBUF_data[9] ֮
		else if( tempBUF == 0x02 )
		{
			Device_CMD = tempBUF;
			pLoop = 0;
			flag_CMD = 0xff;
			return;								// ˱ʽյΪд CMDȴһʲҪд
		}
	//	δָ֮ǿֹͣ SIO
/*		else
		{
			SIO0CR.byte  &= 0xf8;				// SIOM: 00 ǿֹͣ SIO
			__asm("NOP");
			SIO0CR.byte  |= 0x03;				// SIOM: Ϊͼģʽ
			flag_CMD      = 0x00;
			Device_CMD    = 0x00;
			return;								// SIO ֹͣ뿪жϳ
		}
*/
	}


//	 Master ˽յȡָ (0x9f) 󣬽ظ -> 0xaa -> 0x68 -> 0x12
	if( Device_CMD == 0x9f )
	{
		if( SIO0SR.bit.b6 == 0 )				// SEFȴһϴ
		{
			SIO0BUF.byte = Device_ID[pLoop];
			pLoop++;
			pLoop %= 0x03;						// ظͬ 3  Devic ID 
		}
	}
//	 Master ˽յȡָ (0x03) 󣬽ظ 10  rBUF_data[0] ~ rBUF_data[9] ֮
	else if( Device_CMD == 0x03 )
	{
		if( SIO0SR.bit.b6 == 0 )				// SEFȴһϴ
		{
			SIO0BUF.byte = rBUF_data[pLoop];
			pLoop++;
			pLoop %= 0x10;						// ظͬ 10  rBUF_data[0] ~ rBUF_data[9] ֮
		}
	}
//	 Master ˽յдָ (0x02) 󣬽յظд rBUF_data[0] ~ rBUF_data[9] ֮
	else if( Device_CMD == 0x02 )
	{
		if( SIO0SR.bit.b6 == 0 )				// SEFȴһϴ
		{
			rBUF_data[pLoop] = SIO0BUF.byte;
			pLoop++;
			pLoop %= 0x10;						// ظд rBUF_data[0] ~ rBUF_data[9] ֮
		}
	}
	//Add your interrupt handler code here
}

//----------<Real time clock interrupt routine>
void __interrupt IntRTC(void)
{
	//Add your interrupt handler code here
}

//----------<A/D converter interrupt routine>
void __interrupt IntADC(void)
{
	//Add your interrupt handler code here
}

//----------<Voltage Detect interrupt routine>
void __interrupt IntVLTD(void)
{
	//Add your interrupt handler code here
}

//----------<Asynchronous/Synchronous Serial interrupt routine>
void __interrupt IntRXD0_SIO0(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTXD0(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntRXD1(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTXD1(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntRXD2(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTXD2(void)
{
	//Add your interrupt handler code here
}

//----------<Time base timer interrupt routine>
void __interrupt IntTBT(void)
{
	//Add your interrupt handler code here
}

//----------<Warm-up counter interrupt routine>
void __interrupt IntWUC(void)
{
	//Add your interrupt handler code here
}

//----------<Watch dog timer interrupt routine>
void __interrupt_n IntWDT(void)
{
	//Add your interrupt handler code here
}

//----------<Software interrupt routine>
void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2.byte=0x10;	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}      
/*============================================
  [ Define interrupt table ]
    This part must be rewrite.
  ============================================*/
#pragma section const INT_VECTOR1
void * const IntTbl1[] = {
    IntTCC0T,			/* 0xffc2 : IntTCC0T */
	IntTCC0P,			/* 0xffc4 : IntTCC0P */
	IntTEMG0,			/* 0xffc6 : IntTEMG0 */
	IntTXD2,			/* 0xffc8 : IntTXD2 */
	IntRXD2,			/* 0xffca : IntRXD2 */
	IntTC03,			/* 0xffcc : IntTC03 */
    IntTC02,			/* 0xffce : IntTC02 */
    IntTXD1,			/* 0xffd0 : IntTXD1 */
    IntRXD1,			/* 0xffd2 : IntRXD1 */
    IntTCA1,			/* 0xffd4 : IntTCA1 */
    Int4,				/* 0xffd6 : Int4 */
    Int3,				/* 0xffd8 : Int3 */
    Int2,				/* 0xffda : Int2 */
    Int1,				/* 0xffdc : Int1 */
    Int0,				/* 0xffde : Int0 */
    IntSBI0_SIO0,		/* 0xffe0 : IntSBI0_SIO0 */
    IntTCA0,			/* 0xffe2 : IntTCA0  */
    IntTC01,			/* 0xffe4 : IntTC01 */
    IntTC00,			/* 0xffe6 : IntTC00 */
    IntRTC,				/* 0xffe8 : IntRTC */
    IntADC,				/* 0xffea : IntADC */
    IntVLTD,			/* 0xffec : IntVLTD */
    Int5,				/* 0xffee : Int5 */
    IntTXD0,			/* 0xfff0 : IntTXD0 */
    IntRXD0_SIO0,		/* 0xfff2 : IntRXD0_SIO0 */
    IntTBT,				/* 0xfff4 : IntTBT */
    IntWUC,	    		/* 0xfff6 : IntWUC */
    IntWDT,				/* 0xfff8 : IntWDT */
    (void *)0xffff,		/* 0xfffa : Reserved */
    IntSWI,	   			/* 0xfffc : IntSWI/INTUNDEF */
    startup		    	/* 0xfffe : RESET */
};
#pragma section const   /* return to default */
