
#ifndef __I2C_H_
#define __I2C_H_


//-- 庯 --//
void  I2C_set(void);
void  I2C_start(  uchar data, uchar address);
void  I2C_restart(uchar data);
void  I2C_stop(void);
void  I2C_ByteWrite(uchar *data, uchar len);
void  I2C_ByteRead( uchar *data, uchar len);
void  I2C_set_slave_addr(uchar addr);

extern uchar TempSBI0SR2[16];
extern uchar iTemp;






//----------------------------------//
//	SBI0SR2*************************//
//----------------------------------//
//extern TYPE_BYTE sSBI0SR2;
typedef struct {
	uchar	MST:1;		// b7. MST: Master/Slave selection status monitor.==> 0).Slave, 1).Master
	uchar	TRX:1;		// b6. TRX: Transmitter/Receiver selection status monitor.==> 0).Receiver, 1).Transmitter
	uchar	BB :1;		// b5. BB : Bus status monitor.==> 0).Bus free, 1).Bus busy
	uchar	PIN:1;		// b4. PIN: Interrupt service requests status monitor.==> 0).Requesting interrupt service, 1).Releasing interrupt service request
	uchar	AL :1;		// b3. AL : Arbitration lost detection monitor
	uchar	AAS:1;		// b2. AAS: Slave address match detection monitor
	uchar	AD0:1;		// b1. AD0: "GENERAL CALL" detection monitor
	uchar	LRB:1;		// b0. LRB: Last received bit monitor
}	BIT_SBI0SR2;
typedef union {
	uchar		byte;
	BIT_SBI0SR2	bit;
}	BYTE_SBI0SR2;


typedef struct {
	uchar	NA7:1;
	uchar	NA6:1;
	uchar	NA5:1;
	uchar	NA4:1;
	uchar	NA3:1;
	uchar	NA2:1;
	uchar	R1W0:1;			// read:1, write:0
	uchar	match_addr:1;	// slave address match detection
}	BIT_flag;
typedef union {
	uchar		byte;
	BIT_flag	bit;
}	BYTE_flag;


typedef struct {
	BYTE_SBI0SR2 	sSBI0SR2;
	BYTE_flag	 	sFlag;

	uchar			I2C_wBuf[16];	// д from master
	uchar			I2C_rBuf[16];	//  from slave
	uchar			iAddr_st;		// ʼλַ
	uchar			iAddr_pt;		//
	uchar			iByte;			// ϱ16
}	User_I2C;

extern User_I2C  sI2C;

#endif
