
#ifndef __SIO_H_
#define __SIO_H_



#define SPI_RX_RISE_TX_FALL			0x00
#define SPI_RX_FALL_TX_RISE			0x80

#define SPI_MASTER_FCGCK_DIV_512	0x00
#define SPI_MASTER_FCGCK_DIV_64		0x10
#define SPI_MASTER_FCGCK_DIV_32		0x20
#define SPI_MASTER_FCGCK_DIV_16		0x30
#define SPI_MASTER_FCGCK_DIV_8		0x40
#define SPI_MASTER_FCGCK_DIV_4		0x50
#define SPI_MASTER_FCGCK_DIV_2		0x60
#define SPI_MASTER_FS_DIV_8	        0x60
#define SPI_SLAVE					0x70

#define	SPI_DIR_LSB					0x00
#define	SPI_DIR_MSB					0x08

#define SPI_MODE_TX					0x01
#define SPI_MODE_RX					0x02
#define SPI_MODE_TX_RX				0x03

#define SPI_FORCED_STOP				0x00
#define SPI_RESERVED_STOP			0x01

//	MQ6935 SIO  SS ܽţԹܽ SS(CSB) ƽʵ
#define	SIO_SS_CR		P7CR.bit.b7
#define	SIO_SS_CSB		P7DR.bit.b7


void SIO_Init(void);
void SIO_ByteSend(uchar *data, uchar len);
void SIO_ByteRead(uchar *data, uchar len);

void SPI_Reserved_Stop_Wait(void);


#endif


















