
#include "MQ6935.h"
#include "iApp.h"
#include "I2C.h"


User_I2C  sI2C;
uchar TempSBI0SR2[16]={0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
uchar iTemp=0;

//*********************************************************************
// 	: I2C_set_slave_addr()
// 	: SBI0
// ע		:
//*********************************************************************
void I2C_set_slave_addr(uchar addr)
{
	I2C0AR.byte = addr & 0xfe;		// SA0[7:1]: Slave address setting
									// &0xfe   : and clear bit0
}


//*********************************************************************
// 	: I2C_set()
// 	: SBI0
// ע		:
//*********************************************************************
void I2C_set(void)
{
	P2CR.bit.b3  = 0;
	P2CR.bit.b4  = 0;
	POFFCR1.bit.b4  = 1;		// SBI0 Enable
	while( P2PRD.bit.b3==0 || P2PRD.bit.b4==0 ){ WDCDR.byte = 0x4e; }	// ȴΪߵλ
	P2DR.bit.b3    = 0;
	P2DR.bit.b4    = 0;
	P2FC.bit.b3    = 1;
	P2FC.bit.b4    = 1;
	P2CR.bit.b3    = 1;
	P2CR.bit.b4    = 1;

//----------------------------------//
	SBI0CR2.byte = 0x18;
	SBI0CR1.byte = 0x10;
//----------------------------------//
//	SBI0CR1*************************//
//----------------------------------//
//	SBI0CR1.bit.b[7:5]			// BC: Number of data bits
//	SBI0CR1.bit.b[4] = 1;		// ACK
//	SBI0CR1.bit.b[3] = 0;		// NOACK: Master: Don't care
//								//        Slave:  0). disable
//								//                1). enable the slave address match detection and the GENERAL CALL detection
//	SBI0CR1.bit.b[2:0]			// SCK
//...............................|-------------------------------------------
//...............................| SCK | tHIGH     | tLOW      |
//...............................| SCK | (m/fcgck) | (n/fcgck) | fcgck=8MHz
//...............................|-------------------------------------------
//...............................| 000 |    9      |   12      | 381KHz
//...............................| 001 |   11      |   14      | 320KHz
//...............................| 010 |   15      |   18      | 242KHz
//...............................| 011 |   23      |   26      | 163KHz
//...............................| 100 |   39      |   42      |  99KHz
//...............................| 101 |   71      |   74      |  55KHz
//...............................| 110 |  135      |  138      |  29KHz
//...............................| 111 |  263      |  266      |  15KHz
//...............................|-------------------------------------------

//----------------------------------//
//	SBI0CR2: byte operation not bit //
//----------------------------------//
//	SBI0CR2.bit.b7  = 0;		// MST: 0.Slave, 1.Master
//	SBI0CR2.bit.b6  = 0;		// TRX: 0.Receiver, 1.Transmitter
//	SBI0CR2.bit.b5  = 0;		// BB:  Generate the condition, 0.stop, 1.start
//	SBI0CR2.bit.b4  = 1;		// PIN: 1.Cancel interrupt service request
//	SBI0CR2.bit.b3  = 1;		// SBIM: 0.Port mode, 1.Serial bus interface mode
//	SBI0CR2.bit.b2  = 0;		// NA
//	SBI0CR2.bit.b[1:0]			// SWRST: Software reset start bit: by first writing "10" and next writing "01"
//                              // Sequence as below:
//                              // 1. I2C_stop();
//                              // 2. SBI0CR2 = 0x1A;
//                              // 3. SBI0CR2 = 0x19;
//----------------------------------//
//	I2C0AR**************************//
//----------------------------------//
//	I2C0AR.byte[7:1]			// [7:1] SA0: Slave address setting
}

//----------------------------------//
//	SBI0SR2*************************//
//----------------------------------//
//	SBI0SR2.bit.b7;	// MST: Master/Slave selection status monitor.==> 0).Slave, 1).Master
//	SBI0SR2.bit.b6;	// TRX: Transmitter/Receiver selection status monitor.==> 0).Receiver, 1).Transmitter
//	SBI0SR2.bit.b5;	// BB : Bus status monitor.==> 0).Bus free, 1).Bus busy
//	SBI0SR2.bit.b4;	// PIN: Interrupt service requests status monitor.==> 0).Requesting interrupt service, 1).Releasing interrupt service request
//	SBI0SR2.bit.b3;	// AL : Arbitration lost detection monitor
//	SBI0SR2.bit.b2;	// AAS: Slave address match detection monitor
//	SBI0SR2.bit.b1;	// AD0: "GENERAL CALL" detection monitor
//	SBI0SR2.bit.b0;	// LRB: Last received bit monitor
//	sI2C.sSBI0SR2.bit.LRB


//*********************************************************************
// 	: I2C_start()
// 	: I2C_start
// ע		:
//*********************************************************************
void I2C_start(uchar data, uchar address)
{
	uchar tWait = 0;

	while( SBI0SR2.bit.b5 == 1 ){}		// SBI0SR2.BB: confirms bus is free

	SBI0CR1.byte = 0x10;				// ÿһ I2C_start趨SBI0CR1
//****** Write data to the registers before the start condition is generated ******
	SBI0DBR.byte = data;				// 趨 slave Device ID
	SBI0CR2.byte = 0xf8;				// Write "1" to SBI0CR2<MST>, <TRX>, <BB>, <PIN>  and <SBIM>to "1"
	while( SBI0SR2.bit.b4 == 1 ){}		// ȴbyte, PINΪ0
	while( SBI0SR2.bit.b0 == 1 )		// check <LRB>  ӻӦźACK
	{									// Ӧ,  ==> SCKһֱ
		tWait++;
		if( tWait>250 )					// Ӧѭ
		{
			I2C_stop();					// I2C stop -> release SCK
			break;
		}
	}

//... 趨 slave start address..................
	tWait = 0;
	SBI0DBR.byte = address;				// 趨 slave start address
	while( SBI0SR2.bit.b4 == 1 ){}		// ȴbyte, PINΪ0
	while( SBI0SR2.bit.b0 == 1 )		// check <LRB>  ӻӦźACK
	{									// Ӧ,  ==> SCKһֱ
		tWait++;
		if( tWait>250 )					// Ӧѭ
		{
			I2C_stop();					// I2C stop -> release SCK
			break;
		}
	}
}


//*********************************************************************
// 	: I2C_restart()
// 	: I2C_restart
// ע		:
//*********************************************************************
void I2C_restart(uchar data)
{
	uchar tWait = 0;

	SBI0CR2.byte = 0x18;
	while( SBI0SR2.bit.b5 == 1 ){}		// SBI0SR2.BB: confirms bus is free
	while( SBI0SR2.bit.b0 == 0 ){}		// wait <LRB>=1**********************

//****** Write data to the registers before the start condition is generated ******
	SBI0DBR.byte = data;
	SBI0CR2.byte = 0xf8;				// Write "1" to SBI0CR2<MST>, <TRX>, <BB>, <PIN>  and <SBIM>to "1"
	while( SBI0SR2.bit.b4 == 1 ){}		// ȴbyte, PINΪ0
	while( SBI0SR2.bit.b0 == 1 )		// check <LRB>  ӻӦźACK
	{									// Ӧ,  ==> SCKһֱ
		tWait++;
		if( tWait>250 )					// Ӧѭ
		{
			I2C_stop();					// I2C stop -> release SCK
			break;
		}
	}
}


//*********************************************************************
// 	: I2C_stop()
// 	: I2C_stop
// ע		:
//*********************************************************************
void I2C_stop(void)
{
	SBI0CR2.byte = 0xd8;				// Set SBI0CR2<MST>, <TRX> and <PIN> to "1" and SBI0CR2<BB> to "0"
	while( SBI0SR2.bit.b5 == 1 ){}		// SBI0SR2.BB: confirms bus is free
}


//*********************************************************************
// 	: I2C_ByteWrite()
// 	: byte write * len
// ע		:
//*********************************************************************
void I2C_ByteWrite(uchar *data, uchar len)
{
	uchar i, tWait;

	for( i=0; i<len; i++ )
	{
		tWait = 0;
		SBI0DBR.byte = *data;
		data++;
		while( SBI0SR2.bit.b4 == 1 ){}	// ȴbyte, PINΪ0
		while( SBI0SR2.bit.b0 == 1 )	// check <LRB>  ӻӦźACK
		{								// Ӧ,  ==> SCKһֱ
			tWait++;
			if( tWait>250 )				// Ӧѭ
			{
				I2C_stop();				// I2C stop -> release SCK
				break;
			}
		}
	}

}


//*********************************************************************
// 	: I2C_ByteRead()
// 	: byte read * len
// ע		:
//*********************************************************************
void I2C_ByteRead(uchar *data, uchar len)
{
	uchar i;

	len -= 1;
//...(len-1)byte..................
	for( i=0; i<len; i++ )
	{
	//	SBI0CR1.bit.b4 = 1;				// ACK=1
		SBI0DBR.byte   = 0x00;			// write dummy data to set PIN = 1
		while( SBI0SR2.bit.b4 == 1 ){}	// ȴbyte, PINΪ0
		*data = SBI0DBR.byte;
		data++;
	}

//...һbyte..................
	SBI0CR1.bit.b4 = 0;					// ACK=0
	SBI0DBR.byte   = 0x00;				// write dummy data to set PIN = 1
	while( SBI0SR2.bit.b4 == 1 ){}		// ȴbyte, PINΪ0
	*data = SBI0DBR.byte;

//	Termination of data transfer by master mode
//	Sent 1 bit negative acknowledge............
	SBI0CR1.bit.b5 = 1;					// BC, bit count = 1
	SBI0DBR.byte   = 0x00;				// write dummy data to set PIN = 1
	while( SBI0SR2.bit.b4 == 1 ){}		// ȴbyte, PINΪ0
}











