//******************************************
//  ƣ MQ6906_SFR_addr.h
//  汾     V1.0 02/20/2020
//      
//  ע     1. ĴλԪܹ֮
//           2. ⹦ܼĴӳλַ
//******************************************

#ifndef _MQ6906_SFR_ADDR_H_
#define _MQ6906_SFR_ADDR_H_

/* This definition is for I/O variable and extern definition */
/* So please do not use the name "IO_MEM".*/
#ifdef IO_MEM
#define EXTERN
#else
#define EXTERN extern
#endif


//****************************************************
#ifndef	uchar
#define uchar unsigned char
#endif
#ifndef	uint
#define uint  unsigned int
#endif
#ifndef	ulong
#define ulong unsigned long
#endif
//****************************************************


//****************************************************
//  1. ĴλԪܹ֮ **************
//****************************************************

//****************************************************
//===  Bit λ֮ ======
typedef struct
{
    uchar   b7:1;
    uchar   b6:1;
    uchar   b5:1;
    uchar   b4:1;
    uchar   b3:1;
    uchar   b2:1;
    uchar   b1:1;
    uchar   b0:1;
} BIT8_LIST;
typedef struct
{
    uint    b15:1;
    uint    b14:1;
    uint    b13:1;
    uint    b12:1;
    uint    b11:1;
    uint    b10:1;
    uint    b9:1;
    uint    b8:1;
    uint    b7:1;
    uint    b6:1;
    uint    b5:1;
    uint    b4:1;
    uint    b3:1;
    uint    b2:1;
    uint    b1:1;
    uint    b0:1;
} BIT16_LIST;

//****************************************************
//===  Bit λ֮ ======
typedef struct {                uchar b7_6:2;   uchar bd:6; } BIT8_7_6;
typedef struct {                uchar b7_5:3;   uchar bd:5; } BIT8_7_5;
typedef struct {                uchar b7_4:4;   uchar bd:4; } BIT8_7_4;
typedef struct {                uchar b7_3:5;   uchar bd:3; } BIT8_7_3;
typedef struct {                uchar b7_2:6;   uchar bd:2; } BIT8_7_2;
typedef struct {                uchar b7_1:7;   uchar bd:1; } BIT8_7_1;

typedef struct { uchar bu:1;    uchar b6_5:2;   uchar bd:5; } BIT8_6_5;
typedef struct { uchar bu:1;    uchar b6_4:3;   uchar bd:4; } BIT8_6_4;
typedef struct { uchar bu:1;    uchar b6_3:4;   uchar bd:3; } BIT8_6_3;
typedef struct { uchar bu:1;    uchar b6_2:5;   uchar bd:2; } BIT8_6_2;
typedef struct { uchar bu:1;    uchar b6_1:6;   uchar bd:1; } BIT8_6_1;
typedef struct { uchar bu:1;    uchar b6_0:7;               } BIT8_6_0;

typedef struct { uchar bu:2;    uchar b5_4:2;   uchar bd:4; } BIT8_5_4;
typedef struct { uchar bu:2;    uchar b5_3:3;   uchar bd:3; } BIT8_5_3;
typedef struct { uchar bu:2;    uchar b5_2:4;   uchar bd:2; } BIT8_5_2;
typedef struct { uchar bu:2;    uchar b5_1:5;   uchar bd:1; } BIT8_5_1;
typedef struct { uchar bu:2;    uchar b5_0:6;               } BIT8_5_0;

typedef struct { uchar bu:3;    uchar b4_3:2;   uchar bd:3; } BIT8_4_3;
typedef struct { uchar bu:3;    uchar b4_2:3;   uchar bd:2; } BIT8_4_2;
typedef struct { uchar bu:3;    uchar b4_1:4;   uchar bd:1; } BIT8_4_1;
typedef struct { uchar bu:3;    uchar b4_0:5;               } BIT8_4_0;

typedef struct { uchar bu:4;    uchar b3_2:2;   uchar bd:2; } BIT8_3_2;
typedef struct { uchar bu:4;    uchar b3_1:3;   uchar bd:1; } BIT8_3_1;
typedef struct { uchar bu:4;    uchar b3_0:4;               } BIT8_3_0;

typedef struct { uchar bu:5;    uchar b2_1:2;   uchar bd:1; } BIT8_2_1;
typedef struct { uchar bu:5;    uchar b2_0:3;               } BIT8_2_0;

typedef struct { uchar bu:6;    uchar b1_0:2;               } BIT8_1_0;

//****************************************************
//=== ϶֮ BIT 8 LIST ======
typedef union
{
    uchar       byte;
    BIT8_LIST   bit;
    BIT8_7_6    b7_6;
    BIT8_7_5    b7_5;
    BIT8_7_4    b7_4;
    BIT8_7_3    b7_3;
    BIT8_7_2    b7_2;
    BIT8_7_1    b7_1;
    BIT8_6_5    b6_5;
    BIT8_6_4    b6_4;
    BIT8_6_3    b6_3;
    BIT8_6_2    b6_2;
    BIT8_6_1    b6_1;
    BIT8_6_0    b6_0;
    BIT8_5_4    b5_4;
    BIT8_5_3    b5_3;
    BIT8_5_2    b5_2;
    BIT8_5_1    b5_1;
    BIT8_5_0    b5_0;
    BIT8_4_3    b4_3;
    BIT8_4_2    b4_2;
    BIT8_4_1    b4_1;
    BIT8_4_0    b4_0;
    BIT8_3_2    b3_2;
    BIT8_3_1    b3_1;
    BIT8_3_0    b3_0;
    BIT8_2_1    b2_1;
    BIT8_2_0    b2_0;
    BIT8_1_0    b1_0;
} BIT_LIST_8;

//****************************************************
//=== ϶֮ BIT 16 LIST ======
typedef union
{
    uint        word;
    uchar       byte[2];
    BIT16_LIST  bit;
} BIT_LIST_16;

//****************************************************
//   --> ĴλԪܹ֮ ********
//****************************************************







//****************************************************
//  2. ⹦ܼĴӳλַ ******************
//****************************************************
//***[SFR1 --> 0x0000 ~ 0x003f] **********************
volatile EXTERN BIT_LIST_8              __io(0x0000)    _0x0000;
volatile EXTERN BIT_LIST_8              __io(0x0001)    _0x0001;
volatile EXTERN BIT_LIST_8              __io(0x0002)    _0x0002;

volatile EXTERN BIT_LIST_8              __io(0x0004)    _0x0004;
volatile EXTERN BIT_LIST_8              __io(0x0005)    _0x0005;

volatile EXTERN BIT_LIST_8              __io(0x0007)    _0x0007;
volatile EXTERN BIT_LIST_8              __io(0x0008)    _0x0008;
volatile EXTERN BIT_LIST_8              __io(0x0009)    _0x0009;

volatile EXTERN BIT_LIST_8              __io(0x000B)    _0x000B;

volatile EXTERN BIT_LIST_8              __io(0x000D)    _0x000D;
volatile EXTERN BIT_LIST_8              __io(0x000E)    _0x000E;
volatile EXTERN BIT_LIST_8              __io(0x000F)    _0x000F;

//------------------------0x0010-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0011)    _0x0011;
volatile EXTERN BIT_LIST_8              __io(0x0012)    _0x0012;

volatile EXTERN BIT_LIST_8              __io(0x0014)    _0x0014;
volatile EXTERN BIT_LIST_8              __io(0x0015)    _0x0015;
volatile EXTERN BIT_LIST_8              __io(0x0016)    _0x0016;

volatile EXTERN BIT_LIST_8              __io(0x0018)    _0x0018;

volatile EXTERN BIT_LIST_8              __io(0x001A)    _0x001A;
volatile EXTERN BIT_LIST_8              __io(0x001B)    _0x001B;
volatile EXTERN BIT_LIST_8              __io(0x001C)    _0x001C;
volatile EXTERN BIT_LIST_8              __io(0x001D)    _0x001D;
volatile EXTERN BIT_LIST_8              __io(0x001E)    _0x001E;
volatile EXTERN BIT_LIST_8              __io(0x001F)    _0x001F;

//------------------------0x0020-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0020)    _0x0020;
volatile EXTERN BIT_LIST_8              __io(0x0021)    _0x0021;
volatile EXTERN BIT_LIST_8              __io(0x0022)    _0x0022;
volatile EXTERN BIT_LIST_8              __io(0x0023)    _0x0023;
volatile EXTERN BIT_LIST_8              __io(0x0024)    _0x0024;
volatile EXTERN BIT_LIST_8              __io(0x0025)    _0x0025;
volatile EXTERN BIT_LIST_8              __io(0x0026)    _0x0026;
volatile EXTERN BIT_LIST_8              __io(0x0027)    _0x0027;
volatile EXTERN BIT_LIST_8              __io(0x0028)    _0x0028;
volatile EXTERN BIT_LIST_8              __io(0x0029)    _0x0029;
volatile EXTERN BIT_LIST_8              __io(0x002A)    _0x002A;
volatile EXTERN BIT_LIST_8              __io(0x002B)    _0x002B;
volatile EXTERN BIT_LIST_8              __io(0x002C)    _0x002C;

volatile EXTERN BIT_LIST_16             __io(0x002D)    _0x002D;
//volatile EXTERN BIT_LIST_8            __io(0x002E)    _0x002E;
volatile EXTERN BIT_LIST_16             __io(0x002F)    _0x002F;

//------------------------0x0030-----------------------
//volatile EXTERN BIT_LIST_8              __io(0x0030)    _0x0030;
volatile EXTERN BIT_LIST_8              __io(0x0031)    _0x0031;
volatile EXTERN BIT_LIST_8              __io(0x0032)    _0x0032;
volatile EXTERN BIT_LIST_8              __io(0x0033)    _0x0033;
volatile EXTERN BIT_LIST_8              __io(0x0034)    _0x0034;
volatile EXTERN BIT_LIST_8              __io(0x0035)    _0x0035;
volatile EXTERN BIT_LIST_16             __io(0x0036)    _0x0036;
//volatile EXTERN BIT_LIST_8              __io(0x0037)    _0x0037;
volatile EXTERN BIT_LIST_8              __io(0x0038)    _0x0038;
volatile EXTERN BIT_LIST_8              __io(0x0039)    _0x0039;
volatile EXTERN BIT_LIST_8              __io(0x003A)    _0x003A;
volatile EXTERN BIT_LIST_8              __io(0x003B)    _0x003B;
volatile EXTERN BIT_LIST_8              __io(0x003C)    _0x003C;
volatile EXTERN BIT_LIST_8              __io(0x003D)    _0x003D;

volatile EXTERN BIT_LIST_8              __io(0x003F)    _0x003F;



//***[SFR3 --> 0x0e40 ~ 0x0eff] **********************



//***[SFR2 --> 0x0f00 ~ 0x0fff] **********************

volatile EXTERN BIT_LIST_8              __io(0x0F1A)    _0x0F1A;
volatile EXTERN BIT_LIST_8              __io(0x0F1B)    _0x0F1B;
volatile EXTERN BIT_LIST_8              __io(0x0F1C)    _0x0F1C;

volatile EXTERN BIT_LIST_8              __io(0x0F1E)    _0x0F1E;
volatile EXTERN BIT_LIST_8              __io(0x0F1F)    _0x0F1F;

//------------------------0x0F20-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0F21)    _0x0F21;
volatile EXTERN BIT_LIST_8              __io(0x0F22)    _0x0F22;
volatile EXTERN BIT_LIST_8              __io(0x0F23)    _0x0F23;

volatile EXTERN BIT_LIST_8              __io(0x0F25)    _0x0F25;

volatile EXTERN BIT_LIST_8              __io(0x0F27)    _0x0F27;
volatile EXTERN BIT_LIST_8              __io(0x0F28)    _0x0F28;
volatile EXTERN BIT_LIST_8              __io(0x0F29)    _0x0F29;

volatile EXTERN BIT_LIST_8              __io(0x0F2B)    _0x0F2B;

//------------------------0x0F30-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0F30)    _0x0F30;

volatile EXTERN BIT_LIST_8              __io(0x0F34)    _0x0F34;

volatile EXTERN BIT_LIST_8              __io(0x0F36)    _0x0F36;

volatile EXTERN BIT_LIST_8              __io(0x0F38)    _0x0F38;
volatile EXTERN BIT_LIST_8              __io(0x0F39)    _0x0F39;

volatile EXTERN BIT_LIST_8              __io(0x0F3B)    _0x0F3B;
volatile EXTERN BIT_LIST_8              __io(0x0F3C)    _0x0F3C;
volatile EXTERN BIT_LIST_8              __io(0x0F3D)    _0x0F3D;

//------------------------0x0F40-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0F43)    _0x0F43;

volatile EXTERN BIT_LIST_8              __io(0x0F4A)    _0x0F4A;

//------------------------0x0F50-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0F54)    _0x0F54;
volatile EXTERN BIT_LIST_8              __io(0x0F55)    _0x0F55;
volatile EXTERN BIT_LIST_8              __io(0x0F56)    _0x0F56;
volatile EXTERN BIT_LIST_8              __io(0x0F57)    _0x0F57;
volatile EXTERN BIT_LIST_8              __io(0x0F58)    _0x0F58;

volatile EXTERN BIT_LIST_8              __io(0x0F5A)    _0x0F5A;
volatile EXTERN BIT_LIST_8              __io(0x0F5B)    _0x0F5B;
volatile EXTERN BIT_LIST_8              __io(0x0F5C)    _0x0F5C;
volatile EXTERN BIT_LIST_8              __io(0x0F5D)    _0x0F5D;
volatile EXTERN BIT_LIST_8              __io(0x0F5E)    _0x0F5E;

//------------------------0x0F70-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0F70)    _0x0F70;
volatile EXTERN BIT_LIST_8              __io(0x0F71)    _0x0F71;
volatile EXTERN BIT_LIST_8              __io(0x0F72)    _0x0F72;

volatile EXTERN BIT_LIST_8              __io(0x0F74)    _0x0F74;
volatile EXTERN BIT_LIST_8              __io(0x0F75)    _0x0F75;
volatile EXTERN BIT_LIST_8              __io(0x0F76)    _0x0F76;
volatile EXTERN BIT_LIST_8              __io(0x0F77)    _0x0F77;

//------------------------0x0F80-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0F88)    _0x0F88;
volatile EXTERN BIT_LIST_8              __io(0x0F89)    _0x0F89;
volatile EXTERN BIT_LIST_8              __io(0x0F8A)    _0x0F8A;
volatile EXTERN BIT_LIST_8              __io(0x0F8B)    _0x0F8B;
volatile EXTERN BIT_LIST_8              __io(0x0F8C)    _0x0F8C;
volatile EXTERN BIT_LIST_8              __io(0x0F8D)    _0x0F8D;
volatile EXTERN BIT_LIST_8              __io(0x0F8E)    _0x0F8E;

//------------------------0x0FA0-----------------------
volatile EXTERN BIT_LIST_16              __io(0x0FA8)    _0x0FA8;
//volatile EXTERN BIT_LIST_8              __io(0x0FA9)    _0x0FA9;
volatile EXTERN BIT_LIST_16              __io(0x0FAA)    _0x0FAA;
//volatile EXTERN BIT_LIST_8              __io(0x0FAB)    _0x0FAB;
volatile EXTERN BIT_LIST_8              __io(0x0FAC)    _0x0FAC;
volatile EXTERN BIT_LIST_8              __io(0x0FAD)    _0x0FAD;
volatile EXTERN BIT_LIST_8              __io(0x0FAE)    _0x0FAE;

//------------------------0x0FC0-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0FC4)    _0x0FC4;
volatile EXTERN BIT_LIST_8              __io(0x0FC5)    _0x0FC5;
volatile EXTERN BIT_LIST_8              __io(0x0FC6)    _0x0FC6;
volatile EXTERN BIT_LIST_8              __io(0x0FC7)    _0x0FC7;
volatile EXTERN BIT_LIST_8              __io(0x0FC8)    _0x0FC8;

volatile EXTERN BIT_LIST_8              __io(0x0FCB)    _0x0FCB;
volatile EXTERN BIT_LIST_8              __io(0x0FCC)    _0x0FCC;
volatile EXTERN BIT_LIST_8              __io(0x0FCD)    _0x0FCD;
volatile EXTERN BIT_LIST_8              __io(0x0FCE)    _0x0FCE;
volatile EXTERN BIT_LIST_8              __io(0x0FCF)    _0x0FCF;

//------------------------0x0FD0-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0FD0)    _0x0FD0;
volatile EXTERN BIT_LIST_8              __io(0x0FD1)    _0x0FD1;
volatile EXTERN BIT_LIST_8              __io(0x0FD2)    _0x0FD2;
volatile EXTERN BIT_LIST_8              __io(0x0FD3)    _0x0FD3;
volatile EXTERN BIT_LIST_8              __io(0x0FD4)    _0x0FD4;
volatile EXTERN BIT_LIST_8              __io(0x0FD5)    _0x0FD5;
volatile EXTERN BIT_LIST_8              __io(0x0FD6)    _0x0FD6;
volatile EXTERN BIT_LIST_8              __io(0x0FD7)    _0x0FD7;
volatile EXTERN BIT_LIST_8              __io(0x0FD8)    _0x0FD8;
volatile EXTERN BIT_LIST_8              __io(0x0FD9)    _0x0FD9;
volatile EXTERN BIT_LIST_8              __io(0x0FDA)    _0x0FDA;
volatile EXTERN BIT_LIST_8              __io(0x0FDB)    _0x0FDB;
volatile EXTERN BIT_LIST_8              __io(0x0FDC)    _0x0FDC;
volatile EXTERN BIT_LIST_8              __io(0x0FDD)    _0x0FDD;
volatile EXTERN BIT_LIST_8              __io(0x0FDE)    _0x0FDE;
volatile EXTERN BIT_LIST_8              __io(0x0FDF)    _0x0FDF;

//------------------------0x0FE0-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0FE0)    _0x0FE0;
volatile EXTERN BIT_LIST_8              __io(0x0FE1)    _0x0FE1;
volatile EXTERN BIT_LIST_8              __io(0x0FE2)    _0x0FE2;
volatile EXTERN BIT_LIST_8              __io(0x0FE3)    _0x0FE3;

//------------------------0x0FF0-----------------------
volatile EXTERN BIT_LIST_8              __io(0x0FF0)    _0x0FF0;
volatile EXTERN BIT_LIST_8              __io(0x0FF1)    _0x0FF1;
volatile EXTERN BIT_LIST_8              __io(0x0FF2)    _0x0FF2;
volatile EXTERN BIT_LIST_8              __io(0x0FF3)    _0x0FF3;
volatile EXTERN BIT_LIST_8              __io(0x0FF4)    _0x0FF4;
volatile EXTERN BIT_LIST_8              __io(0x0FF5)    _0x0FF5;

//****************************************************
//   --> ⹦ܼĴӳλַ ************
//****************************************************

#endif //_MQ6906_SFR_ADDR_H_











