//*************************************************
//  ƣ MQ6906_TC0_16Bit
//  汾     V 1.00 02/24/2020
//       TC00 TC01 16Bit Timer,PPG ʹú
//  ע    
//*************************************************

#include "main.h"



//*********************************************************************
//    : T001_16bitTimer_Init
//  : T001_16bitTimer_Init ʼʽ
// ע     :
//*********************************************************************
void T001_16bitTimer_Init(void)
{
//====== ܽųʼ ======	
	
	
//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // ȿݴò

//====== 趨 ======
    T001CR_TCAS     = 1;                // x񌢃ɂ8λMӋrMʹ
    T01MOD_TFF      = 1;                // Oʼֵ"ߜλ"ռձ    
	
    T01MOD_TCM      = 0;                // 趨Ϊ 16 λʱģʽ   
    T01MOD_DBE      = 1;                // ʹp
    T01MOD_TCK      = 5;                // fcgck/4 = 1MHz= 0.5us =0.0005ms   
    
    T00REG          = 100;
    T01REG          = 200;              // Timer Period =    51300        / 2MHz =25.65ms
                                        //               (200*256 + 100)
										//                   51300*0.001ms=25.65ms
	
    NOP;                                // ָ
}

//*********************************************************************
//    : T001_16bitEvent_Init
//  : T001_16bitEvent_Init ʼʽ
// ע     :
//*********************************************************************
void T001_16bitEvent_Init(void)
{
//====== ܽųʼ ======	
	P7CR_P0 = 0;						//O P70 ¼Ӌλ
	
//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // ȿݴò

//====== 趨 ======
    T001CR_TCAS     = 1;                // x񌢃ɂ8λMӋrMʹ
    T01MOD_TFF      = 1;                // Oʼֵ"ߜλ"ռձ    
	
    T01MOD_TCM      = 0;                // 趨Ϊ 16 λʱģʽ   
    T01MOD_EIN      = 1;                // ŵ½
	T01MOD_DBE      = 0;                // ʹp
                  
    T00REG          = 160;
    T01REG          = 15;               // ¼Ӌ趨ֵ = 4000        
                                        //       (15*256 + 160)=4000
										//                    
	
    NOP;                                // ָ
}


//*********************************************************************
//    : T001_16bitPPG_Init
//  : T001_16bitPPG_Init ʼʽ
// ע     :
//*********************************************************************
void T001_16bitPPG_Init(void)
{
//====== ܽųʼ ======
    P7DR_P1         = 1;                // ܽʼ P71ߵƽ  **ͬ PPG ĳʼֵ(T0xMOD_TFF)
    P7CR_P1         = 1;                // P71ܽ趨Ϊ
//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // ȿݴò

//====== 趨 ======
    T001CR_TCAS     = 1;                // x񌢃ɂ8λMӋrMʹ
    T01MOD_TFF      = 1;                // Oʼֵ"ߜλ"ռձ    
//  ***PxFC ùţڳʼֵ趨֮ PxFC
    P7FC_P1         = 1;                // лP71Ϊ⹦ܽ,ܽ趨Ϊ PPG 
    
    T01MOD_TCM      = 3;                // 趨Ϊ 16 λɱ PPG ģʽ
	T01MOD_EIN      = 0;
	
	
    T01MOD_TCK      = 7;                // TCK = fcgck/1 = 8MHz=0.125us=0.000125ms  
    T01MOD_DBE      = 1;                // ʹp
		
    T00REG          = 50;
    T01REG          = 100;              // Timer Period =    25650          /  8MHz  =  3.2 ms  (3.20625ms)
                                        //               (100*256 + 50)
    
    T00PWM          = 40;   
    T01PWM          = 80;               // REG  = (80*256+40) =  20520
										// Duty = PWM/REG
										// Duty = 20520 / 25650  = 80%
    
    NOP;                                // ָ
}


//*********************************************************************
//    : T001_16bit_Start
//  : T001_16bit_Start 
// ע     :
//*********************************************************************
void T001_16bit_Start(void)
{
    T001CR_T01RUN = 1;
}





//*********************************************************************
//    : T001_16bit_Stop
//  : T001_16bit_Stop ֹͣ
// ע     :
//*********************************************************************
void T001_16bit_Stop(void)
{
    T001CR_T01RUN = 0;
}


//*********************************************************************
//    : T001_16bit_IntEnable
//  : TC01 ж
// ע     : ִкῪж(IMF)
//*********************************************************************
void T001_16bit_IntEnable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    IL_INTTC01 = 0;                     // ж
    EI_INTTC01 = 1;                     // 趨ж
    EI;                                 // пж // EIRL_IMF=1
}

//*********************************************************************
//    : T001_16bit_IntDisable
//  : TC01 жϳ
// ע     : ִкῪж(IMF)
//*********************************************************************
void T001_16bit_IntDisable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    EI_INTTC01 = 0;                     // ж
    IL_INTTC01 = 0;                     // ж
    EI;                                 // пж // EIRL_IMF=1
}


//*********************************************************************
//    : T001_16bit_SetDuty
//  : Oռձ
// ע     : ռձ = [T01PWM:T00PWM] / [T01REG:T00REG]
//*********************************************************************
void T001_16bit_SetDuty(uint pwmDuty)
{    
    T00PWM = pwmDuty&0xff;              // Oλ
    T01PWM = pwmDuty>>8;                // Oλ
}

//*********************************************************************
//    : T001_16bit_SetPeriod
//  : OL
// ע     : 
//*********************************************************************
void T001_16bit_SetPeriod(uint period)
{    
    T00REG = period&0xff;               // Oλ
    T01REG = period>>8;                 // Oλ
}

//*********************************************************************
//    : IntTC01
//  : TC01 жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntTC01(void)
{    
	P8DR_P4 = !P8DR_P4;					// 趨P84
    NOP;                                // ָ
    
    
}











