//******************************************
//  : MQ6906_8BIT_TC0x
// 汾     : V 1.00 02/24/2020
//      : TC00ʹú
// ע     :
//******************************************

#include "main.h"




//*********************************************************************
//    : TC00_Timer_Init
//  : TC00 8λrģʽr50us
// ע     :
//*********************************************************************
void TC00_Timer_Init(void)
{
//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // ȿݴò

//====== 趨 ======
    T00MOD_TCM      = 0;                // 趨Ϊ 8 λʱģʽ
    T00MOD_TCK      = 5;                // fcgck/4 = 2MHz = 0.5us
    T00MOD_DBE      = 1;                // ʹ˫
    
    T00REG          = 100;              // 趨ֵ: ÿ 100 * 0.5us жһ (ֵ=T00REG*T00MOD_TCK)
}

//*********************************************************************
//    : TC00_Event_Init
//  : TC00 8λ¼ģʽ
// ע     :
//*********************************************************************
void TC00_Event_Init(void)
{
//====== ù ======
	P7CR_P0 = 0;			//OrԴݔ_TC00

//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // ȿݴò

//====== 趨 ======
    T00MOD_TCM      = 0;                // 趨Ϊ 8 λģʽ
    //T00MOD_TCK      = 0;              // fcgck/4 = 2MHz = 0.5us
    T00MOD_EIN      = 1;                //TC00 ŵ½
    T00MOD_DBE      = 1;                // ʹ˫
    
    T00REG          = 100;              // 趨ֵ: ÿ 100 COUNT жһ 
}


//*********************************************************************
//    : TC00_PPG_Init
//  : TC00 8λPPGģʽL100usռձ50%
// ע     :
//*********************************************************************
void TC00_PPG_Init(void)
{
//====== ܽųʼ ======
    P7DR_P0         = 1;                // ܽʼ P70ߵƽ  **ͬ PPG ĳʼֵ(T0xMOD_TFF)
    P7CR_P0         = 1;                // P70ܽ趨Ϊ

//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // ȿݴò

//====== 趨 ======
    T00MOD_TFF      = 1;                // 趨ʼֵΪ"׼λ"ռձ
//	***PxFC ùţڳʼֵ趨֮ PxFC
    P7FC_P0         = 1;                // лP70Ϊ⹦ܽ,ܽ趨Ϊ PPG 

    T00MOD_TCM      = 3;                // 趨Ϊ 8 λɱ PPG ģʽ
    T00MOD_TCK      = 5;                // fcgck/4 = 2MHz = 0.5us
    T00MOD_DBE      = 1;                // ʹ˫

    T00REG          = 100;              // 趨 PPG  = 50us   (PPG=T00REG*T00MOD_TCK)
    T00PWM          = 50;               // 趨 PPG ռձ = 50/100 = 50%
}


//*********************************************************************
//    : TC00_PWM_Init
//  : TC00 8λPWMģʽL128usռձ50%
// ע     :
//*********************************************************************
void TC00_PWM_Init(void)
{
//====== ܽųʼ ======
    P7DR_P0         = 1;                // P070ܽʼͬ PWM ĳʼֵ(T0xMOD_TFF)
    P7CR_P0         = 1;                // P070ܽ趨Ϊ

//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // ȿݴò

//====== 趨 ======
    T00MOD_TFF      = 1;                // 趨ʼֵΪ"׼λ"ռձ
//	***PxFC ùţڳʼֵ趨֮ PxFC
    P7FC_P0         = 1;                // лP70Ϊ⹦ܽ,ܽ趨Ϊ PWM 

    T00MOD_TCM      = 2;                // 趨Ϊ 8 λɱ PWM ģʽ
    T00MOD_TCK      = 5;                // fcgck/4 = 2MHz = 0.5us
    T00MOD_DBE      = 1;                // ʹ˫

// ***ʹ PWM ʱڼ̶Ϊ 128T00REG 趨
// 128 * 1us = 128us
//  T00PWM          = 128;              // 2019/0125 DEL
	T00PWM_PWMDUTY  = 64;               // 趨 PWM ռձ = 64/128 = 50%   //2019/0125

}


//*********************************************************************
//    : TC00_SetDuty
//  : }ֵ
// ע     : ռձ : T00PWM/T00REG      (8λPPGģʽ)
//                   : T00PWM_PWMDUTY/128 (8λPWMģʽ)
//*********************************************************************
void TC00_SetDuty(uchar duty)
{
    T00PWM          = duty;
}

//*********************************************************************
//    : TC00_SetPeriod
//  : Lڼֵ
// ע     : 
//*********************************************************************
void TC00_SetPeriod(uchar period)
{
    T00REG          = period;
}

//*********************************************************************
//    : TC00_Start
//  : TC00
// ע     :
//*********************************************************************
void TC00_Start(void)
{
    T001CR_T00RUN   = 1;                // ʱTimmer00
}


//*********************************************************************
//    : TC00_Stop
//  : ֹͣTC00
// ע     :
//*********************************************************************
void TC00_Stop(void)
{
    T001CR_T00RUN   = 0;                // ֹͣʱTimmer00
}


//*********************************************************************
//    : TC00_IntEnable
//  : TC00ж
// ע     : ִкῪж(IMF)
//*********************************************************************
void TC00_IntEnable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    IL_INTTC00      = 0;                // ж
    EI_INTTC00      = 1;                // 趨ж
    EI;                                 // пж // EIRL_IMF=1
}




//*********************************************************************
//    : TC00_IntDisable
//  : ֹTC00ж
// ע     : ִкῪж(IMF)
//*********************************************************************
void TC00_IntDisable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    EI_INTTC00      = 0;                // ж
    IL_INTTC00      = 0;                // ж
	EI;                                 // пж // EIRL_IMF=1
}




//*********************************************************************
//    : IntTC00
//  : жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntTC00(void)
{
    P8DR_P4 = !P8DR_P4; 				// 趨P8.4
    NOP;                                // ָ
}





