//******************************************
//  : main
// 汾     : V1.0 02/20/2020
//      : 
// ע     : SIO ش/շ,"SIO_Slave"
//            ΪMQ6906 SIO 䣬оƬMQ6906 MasterһMQ6906Slave;
//			  MasterоƬʹñ
//			  SlaveоƬʹSIO_Slave
// 			  P23-SO  (Serial Out, DO)  ©ţ10K Ohm
// 			  P24-SI  (Serial In , DI)  ©ţ10K Ohm
// 		      P25-SCLK(Serial CLocK)
//******************************************
#ifndef IO_MEM
#define IO_MEM
#endif

#include "main.h"


/* ----------------------  ------------------------ */
BIT_LIST_8  _flag_8bit;
BIT_LIST_16 _flag_16bit;
uchar buf2[10];

/* ----------------------  -------------------------- */
void main(){
    /* ---------------------- ϵͳʼ ------------------------ */
    System_Init();    
    
    /* ---------------------- ܳʼ ------------------- */
    Delay_Times(t_1ms, 100);
    SIO_Init(); 						//IOSIOģʽ

//------------------------------------------------------------------------
//  1. Ϊ SIO Master 
//  2. ɴ¼ SIO_Slave ֮оƬͨѶд뼰ȡ֮
//  3. ָ£
//     3-1. 0x9f Ϊ Master ȡ Device ID 磺0xaa 0x69 0x06
//     3-2. 0x03 Ϊ Master ȡ Slave Data
//     3-3. 0x02 Ϊ Master д Slave Data

//  ָ (0x9f) Ϊȡ Device ID 磺0xaa 0x69 0x06
    wBUF_data[0] = 0x9f;                // дһ byte command
    SIO_ByteSend(wBUF_data, 1);
    SIO_ByteRead(rBUF_data, 3);
    CLR_WDT;                            // Źʱ (ι)
    Delay_Times(t_1ms, 1);


//   0x03 Ϊȡ Slave Data
    wBUF_data[0] = 0x03;                // дһ byte command
    SIO_ByteSend(wBUF_data, 1);
    SIO_ByteRead(rBUF_data, 10);
    CLR_WDT;                            // Źʱ (ι)
    Delay_Times(t_1ms, 1);


//   0x02 Ϊд Slave Data
    wBUF_data[0] = 0x02;                // дһ byte command
    wBUF_data[1] = 0x5a;                // PGM data 0
    wBUF_data[2] = 0xa5;                // PGM data 1
    wBUF_data[3] = 0x12;                // PGM data 2
    wBUF_data[4] = 0x37;                // PGM data 3
    wBUF_data[5] = 0x89;                // PGM data 4

    SIO_ByteSend(wBUF_data, 6);
    SIO_ReservedStopWait();
    CLR_WDT;                            // Źʱ (ι)
    Delay_Times(t_1ms, 1);


//   0x03 Ϊȡ Slave Data
    wBUF_data[0] = 0x03;                // дһ byte command
    SIO_ByteSend(wBUF_data, 1);
    SIO_ByteRead(rBUF_data, 10);
    CLR_WDT;                            // Źʱ (ι)
    Delay_Times(t_1ms, 1);
    //-----------------------------------    


//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *    
    while(1){
        CLR_WDT;                        // Źʱ (ι)

        NOP;                            // ָ
        NOP;                            // ָ
        NOP;                            // ָ
    }
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}




/*---------------------- жϷ ------------------------*/
void __interrupt OnlyReti(void)
{
    NOP;                                // ָ
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2=0x10;	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}      
/* -------------------  жϷʽ ------------------ */

/* -------------------- MQ6906ж ------------------ */
//[ ж ] Ҫжид
//  1. ʹ֮߳жж֮OnlyRetiΪӦж
//  2. ӦڵַжƣֱӸ
//
//ʹⲿж0ӦжϱеOnlyRetiΪInt0
//      Int0,            /* 0xffde : Int0 */        //ⲿж0
#pragma section const INT_VECTOR1     //0xffc8
void * const IntTbl1[] = {  
    OnlyReti,           /* 0xffc8 : IntTXD2 */
    OnlyReti,           /* 0xffca : IntRXD2 */
    OnlyReti,           /* 0xffcc : IntTC03 */
    OnlyReti,           /* 0xffce : IntTC02 */
    OnlyReti,           /* 0xffd0 : IntTXD1 */
    OnlyReti,           /* 0xffd2 : IntRXD1 */
    OnlyReti,           /* 0xffd4 : IntTCA1 */	
    OnlyReti,           /* 0xffd6 : Int4 */
    OnlyReti,           /* 0xffd8 : Int3 */
    OnlyReti,           /* 0xffda : Int2 */
    OnlyReti,           /* 0xffdc : Int1 */
    OnlyReti,           /* 0xffde : Int0 */
    OnlyReti,           /* 0xffe0 : IntSBI0_SIO0 */
    OnlyReti,           /* 0xffe2 : IntTCA0  */
    OnlyReti,           /* 0xffe4 : IntTC01 */
    OnlyReti,           /* 0xffe6 : IntTC00 */
    OnlyReti,           /* 0xffe8 : IntRTC */
    OnlyReti,           /* 0xffea : IntADC */
    OnlyReti,           /* 0xffec : IntVLTD */
    OnlyReti,           /* 0xffee : Int5 */
    OnlyReti,           /* 0xfff0 : IntTXD0 */
    OnlyReti,           /* 0xfff2 : IntRXD0_SIO0 */
    OnlyReti,           /* 0xfff4 : IntTBT */
    OnlyReti,           /* 0xfff6 : IntWUC */
    IntWDT,             /* 0xfff8 : IntWDT */
    (void *)0xffff,     /* 0xfffa : Reserved */
    IntSWI,             /* 0xfffc : IntSWI/INTUNDEF */     
    STARTUP             /* 0xfffe : RESET */					
};
#pragma section const
/*-------------------  ж ------------------------*/






//*********************************************************************
//    : System_Init(void)
//  : IO, CGCR ʼ P10/P40/P41 ڷʱ֮趨
// ע     :
//*********************************************************************
void System_Init(void)
{

//=============================================================================
//  Set CGCR
//=============================================================================
//  ============================================
//  پƵãCGCR                                  fc   =  8MHz
//  ============================================
//  CGCR_FCGCKSEL = 0x00;           // (ϵͳ Clock) fcgck = fc/4 =  2Mhz(ϵͳĬ)
//  CGCR_FCGCKSEL = 0x01;           // (ϵͳ Clock) fcgck = fc/2 =  4Mhz
    CGCR_FCGCKSEL = 0x02;           // (ϵͳ Clock) fcgck = fc   =  8Mhz
//  CGCR_FCGCKSEL = 0x03;           //  Reserved
//  ============================================
//  *** 벻Ҫڵģʽ(SLOW1/SLOW2) ı CGCR<FCGCKSEL> Ĵֵ
//  ============================================

#ifdef _DEBUG   //...  _DEBUG(ģʽ): ڷ ev board
//------------------------------------------------------------------
//  (ϵͳĬ): ʱP10趨ΪReset PinԱӰ漰¼.
//  SET_P10_RESET_PIN;
//------------------------------------------------------------------
    
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ) P10(RESET) λΪһ IO 
//------------------------------------------------------------------
//-- P10趨ΪһIO ------
    SET_P10_IO_PIN;
//------------------------------------------------------------------
#endif



//-- ʼ IO  (λ)------
#ifdef _DEBUG   //...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//   P10/P40/P41  Debug modeڷʱ趨Ϊ룬
//  ԱӰ漰¼.
    P1DR = 0x00;
    P1CR = set8bit(11111110);           //  P10 Ϊ
    P4DR = 0x00;
    P4CR = set8bit(11111100);           //  P40/P41 Ϊ
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;
//------------------------------------------------------------------
#endif

//-- ʼ IO  ------
    P0DR = 0x00;
    P0CR = set8bit(11111100);
//  P1DR = 0x00;
//  P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//  P4DR = 0x00;
//  P4CR = 0xff;    
    P7DR = 0x00;
    P7CR = 0xff;
    P8DR = 0x00;
    P8CR = 0xff;
    P9DR = 0x00;
    P9CR = 0xff;
    CLR_WDT;                            // Źʱ (ι)

}



//*********************************************************************
//    :
//  : ʱ
// ע     : ==> t_1ms   = 0;          // ӳʱ䵥λ ms
//          : ==> t_100us = 1;          // ӳʱ䵥λ usϴ
//          : ɹ̶Ȧʱһʱ䣬ʹ÷£
//          : Delay_Times(t_1ms, 800);  // ӳ 800ms
//*********************************************************************
void Delay_Times(uchar tBase, uint x)
{
    uint  i, cgcrT;

    uchar cgcrF[4]={ 2, 4,  8, 1 };     // پƵΪ  8MHz ʱʹô
//  uchar cgcrF[4]={ 4, 8, 16, 2 };     // پƵΪ 16MHz ʱʹô

//  ϵͳڸʱ(ͨ1ͨ2ģʽ) ʱ
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  ϵͳڵʱ(12ģʽ) ʱϴ󣬲οʹã
    else for(; x>0; x--){}

    CLR_WDT;                            // Źʱ (ι)
}









