//*********************************************************************
//  : MQ6906_I2C_EEPROM.c
// 汾     : V1.0 02/24/2020
//      : I2Cʹú
// ע     : I2Cغ㼯ڱ
//*********************************************************************

#include "main.h"

//*********************************************************************
// 	: I2C_SetSlaveAddr
// 	: ôģʽַ
// ע		:
//*********************************************************************
void I2C_SetSlaveAddr(uchar addr)
{
	I2C0AR = addr & 0xfe;				// SA0[7:1]: Slave address setting
										// 0Xfe	1111 1110		
										// &0xfe   : and clear bit0  
}

//*********************************************************************
// 	: I2C_Init
// 	: OÁKI2C
// ע		: initial
//*********************************************************************
void I2C_Init(void)
{	//====== ܽųʼ ======
	P2CR_P3  = 0;						// 趨 P23 
	P2CR_P4  = 0;						// 趨 P24 
	//====== ܿ( Enable) ======
	POFFCR1_SBI0EN  = 1;				// ȿݴò,SBI0 Enable
	
	while( P2PRD_P3==0 || P2PRD_P4==0 ){// ȴΪߵλ
		CLR_WDT; 						// Źʱ (ι)
	}	
	//====== 趨 ======
	
	P2DR_P3    = 0; 				    //  P23 ͵ƽ
	P2DR_P4    = 0;						//  P24 ͵ƽ
	
	P2FC_P3    = 1;						// лP23Ϊ⹦ܽ
	P2FC_P4    = 1;						// лP24Ϊ⹦ܽ
	
	P2CR_P3    = 1; 					//  P23 Ϊ
	P2CR_P4    = 1; 					//  P24 Ϊ

//-----------------------------------------------------------------------
//------------bit7 | bit6 | bit5 | bit4  |  bit3  | bit2 | bit1~bit0 ----
//--- SBI0CR2 <MST>, <TRX>, <BB>, <PIN> and <SBIM>  <NA>   <SWRST>
//            <MST>   1 : Master
//                    0 : Slave
// 			  <TRX>   1 :    ; 0: 
// 			  <BB>    1 : ʼ
//       	          0 : ֹͣ
//			  <PIN>	  1 : ȡжϷ
//
//			  <SBIM>  1 : Serial bus interface mode(ģʽ) / 0:Port mode
//            <SWRST> ÿʼλ   	

	SBI0CR2 = 0x18;						// 0001 1000
	SBI0CR1 = 0x10;						// 0001 0000

}

//*********************************************************************
// 	: I2C_IntEnable
// 	: SI2CД
// ע		: ִкῪж(IMF)
//*********************************************************************
void I2C_IntEnable(void)
{
	DI;
	IL_INTSBI0  = 0;
	EI_INTSBI0  = 1;
	EI;
}


//*********************************************************************
// 	: I2C_IntDisable 
// 	: ֹI2CД
// ע		: ִкῪж(IMF)
//*********************************************************************
void I2C_IntDisable(void)
{
	DI;
	EI_INTSBI0  = 0;
	IL_INTSBI0  = 0;	
	EI;
}


//*********************************************************************
// 	: I2C_Start
// 	: _ʼl푑ַһֹ
// ע		:
//*********************************************************************
//------------bit7 | bit6 | bit5 | bit4  |  bit3  | bit2 | bit1~bit0 ----
//--- SBI0CR2 <MST>, <TRX>, <BB>, <PIN> and <SBIM>  <NA>   <SWRST>
//            <MST>   1 : Master
//                    0 : Slave
// 			  <TRX>   1 :    ; 0: 
// 			  <BB>    1 : ʼ
//       	          0 : ֹͣ
//			  <PIN>	  1 : ȡжϷ
//
//			  <SBIM>  1 : Serial bus interface mode(ģʽ) / 0:Port mode
//            <SWRST> ÿʼλ  

void I2C_Start(uchar data, uchar address)
{
	uchar tWait = 0;

	while( SBI0SR2_BB == 1 ){}			// SBI0SR2.BB: Bus status confirms is free ; 1 :busy  0: free

	SBI0CR1 = 0x10;						// ***ÿһ I2C_Start趨SBI0CR1
//****** Write data to the registers before the start condition is generated ******
	SBI0DBR = data;						// 趨 slave Device ID
	SBI0CR2 = 0xf8;						// Write "1" to SBI0CR2<MST>, <TRX>, <BB>, <PIN>  and <SBIM>to "1"
										// 1111 1000
										// Set master,,ʼ,ȡжϷ and ģʽ
	
	
	while( SBI0SR2_PIN == 1 ){}			// ȴbyte, PINΪ0	
	while( SBI0SR2_LRB == 1 ){			// check <LRB> յλ, ӻӦźACK									
		tWait++;						// Ӧ,  ==> SCKᱣ
		if( tWait>250 ){				// Ӧѭ		
			I2C_Stop();					// I2C stop -> release SCK
			break;
		}
	}

//... 趨 slave start address..................
	tWait = 0;
	SBI0DBR = address;					// 趨 slave start address
	while( SBI0SR2_PIN == 1 ){}			// ȴbyte, PINΪ0
	while( SBI0SR2_LRB == 1 ){			// check <LRB>  ӻӦźACK										
		tWait++;						// Ӧ,  ==> SCKһֱ
		if( tWait>250 ){				// Ӧѭ		
			I2C_Stop();					// I2C stop -> release SCK
			break;
		}
	}
}


//*********************************************************************
// 	: I2C_Restart 
// 	: Restart푑ַ
// ע		:
//*********************************************************************
//------------bit7 | bit6 | bit5 | bit4  |  bit3  | bit2 | bit1~bit0 ----
//--- SBI0CR2 <MST>, <TRX>, <BB>, <PIN> and <SBIM>  <NA>   <SWRST>
//            <MST>   1 : Master
//                    0 : Slave
// 			  <TRX>   1 :    ; 0: 
// 			  <BB>    1 : ʼ
//       	          0 : ֹͣ
//			  <PIN>	  1 : ȡжϷ
//
//			  <SBIM>  1 : Serial bus interface mode(ģʽ) / 0:Port mode
//            <SWRST> ÿʼλ  

void I2C_Restart(uchar data)
{
	uchar tWait = 0;

	SBI0CR2 = 0x18;						// 0001 1000
										// Set master,,ʼ,ȡжϷ and ģʽ
										
	while( SBI0SR2_BB == 1 ){}			// SBI0SR2.BB: Bus status confirms is free ; 1 :busy  0: free
	while( SBI0SR2_LRB == 0 ){}			// wait <LRB>=1**********************

//****** Write data to the registers before the start condition is generated ******
	SBI0DBR = data;
	SBI0CR2 = 0xf8;						// Write "1" to SBI0CR2<MST>, <TRX>, <BB>, <PIN>  and <SBIM>to "1"
	while( SBI0SR2_PIN == 1 ){}			// ȴbyte, PINΪ0
	while( SBI0SR2_LRB == 1 ){			// check <LRB>  ӻӦźACK										
		tWait++;						// Ӧ,  ==> SCKһֱ
		if( tWait>250 ){				// Ӧѭ		
			I2C_Stop();					// I2C stop -> release SCK
			break;
		}
	}
}


//*********************************************************************
// 	: I2C_Stop 
// 	: ֹͣl
// ע		:
//*********************************************************************
//------------bit7 | bit6 | bit5 | bit4  |  bit3  | bit2 | bit1~bit0 ----
//--- SBI0CR2 <MST>, <TRX>, <BB>, <PIN> and <SBIM>  <NA>   <SWRST>
//            <MST>   1 : Master
//                    0 : Slave
// 			  <TRX>   1 :    ; 0: 
// 			  <BB>    1 : ʼ
//       	          0 : ֹͣ
//			  <PIN>	  1 : ȡжϷ
//
//			  <SBIM>  1 : Serial bus interface mode(ģʽ) / 0:Port mode
//            <SWRST> ÿʼλ  

void I2C_Stop(void)
{
	SBI0CR2 = 0xd8;						// Set SBI0CR2<MST>, <TRX> and <PIN> to "1" and SBI0CR2<BB> to "0"
										// 1101 1000
										// Set master,,ֹͣ,ȡжϷ and Portģʽ
										
	while( SBI0SR2_BB == 1 ){}			// SBI0SR2.BB: Bus status confirms is free ; 1 :busy  0: free
}


//*********************************************************************
// 	: I2C_ByteWrite 
// 	: byte write * len
// ע		:
//*********************************************************************
void I2C_ByteWrite(uchar *data, uchar len)
{
	uchar i, tWait;

	for( i=0; i<len; i++ ){	
		tWait = 0;
		SBI0DBR = *data;
		data++;
		while( SBI0SR2_PIN == 1 ){}		// ȴbyte, PINΪ0
		while( SBI0SR2_LRB == 1 ){		// check <LRB>  ӻӦźACK	// Ӧ,  ==> SCKһֱ
			tWait++;	
			if( tWait>250 ){			// Ӧѭ			
				I2C_Stop();				// I2C stop -> release SCK
				break;
			}
		}
	}

}


//*********************************************************************
// 	: I2C_ByteRead 
// 	: byte read * len
// ע		:
//*********************************************************************
void I2C_ByteRead(uchar *data, uchar len)
{
	uchar i;

	len -= 1;
//...(len-1)byte..................
	for( i=0; i<len; i++ ){
		SBI0DBR   = 0x00;				// write dummy data to set PIN = 1
		while( SBI0SR2_PIN == 1 ){}		// ȴbyte, PINΪ0
		*data = SBI0DBR;
		data++;
	}

//...һbyte..................
	SBI0CR1_ACK = 0;					// ACK=0
	SBI0DBR   = 0x00;					// write dummy data to set PIN = 1
	while( SBI0SR2_PIN == 1 ){}			// ȴbyte, PINΪ0
	*data = SBI0DBR;

//	Termination of data transfer by master mode
//	Sent 1 bit negative acknowledge............
	SBI0CR1_BC = 1;						// BC, bit count = 1
	SBI0DBR   = 0x00;					// write dummy data to set PIN = 1
	while( SBI0SR2_PIN == 1 ){}			// ȴbyte, PINΪ0
}




//*********************************************************************
//   : IntSBI0_SIO0
//  : I2CД
// ע       :
//*********************************************************************
void __interrupt IntSBI0_SIO0(void)
{
    
}



//*********************************************************************
// 	: I2C_ByteWrite_FF 
// 	: byte write * len
// ע		:
//*********************************************************************
void I2C_ByteWrite_FF()
{
	uchar i, tWait;

	for( i=0; i<10; i++ ){	
		tWait = 0;
		SBI0DBR = 0xFF;
		while( SBI0SR2_PIN == 1 ){}		// ȴbyte, PINΪ0
		while( SBI0SR2_LRB == 1 ){		// check <LRB>  ӻӦźACK	// Ӧ,  ==> SCKһֱ
			tWait++;	
			if( tWait>250 ){			// Ӧѭ			
				I2C_Stop();				// I2C stop -> release SCK
				break;
			}
		}
	}

}



