//******************************************
//  : MQ6906_ADC.h
// 汾     : V1.0 02/24/2020
//      : ADCͷļ
// ע     :
//******************************************
#ifndef _MQ6906_ADC_H_
#define _MQ6906_ADC_H_



#define     AD_TIMES       16

/******************
 * 1st Argument
 * ****************/
#define     ADC_Forcibly_STOP   0x0 // ǿֹͣADת  //20190107

#define     ADC_SINGLE      0x1 // תģʽ
#define     ADC_REPEAT      0x3 // תģʽ
/******************
 * 2nd Argument
 * ****************/
#define     AIN_DIS         0x0 // ֹģź
#define     AIN_EN          0x1 // ģź
/******************
 * 3rd Argument
 * ****************/
#define     AIN0            0x0 // ѡⲿѹAIN0
#define     AIN1            0x1 // ѡⲿѹAIN1
#define     AIN2            0x2 // ѡⲿѹAIN2
#define     AIN3            0x3 // ѡⲿѹAIN3
#define		AIN4			0x4	// ѡⲿѹAIN4
#define		AIN5			0x5	// ѡⲿѹAIN5
#define		AIN6			0x6	// ѡⲿѹAIN6
#define		AIN7			0x7	// ѡⲿѹAIN7
#define     AIN8            0x8 // ѡⲿѹAIN8
#define     AIN9            0x9 // ѡⲿѹAIN9
#define     AIN10           0xa // ѡⲿѹAIN10
#define     AIN11           0xb // ѡⲿѹAIN11
#define     AIN12           0xc // ѡⲿѹAIN12
#define     AIN13           0xd // ѡⲿѹAIN13
#define     AIN14           0xe // ѡⲿѹAIN14
#define     AIN15           0xf // ѡⲿѹAIN15

/******************
 * 4th Argument
 * ****************/
// fcgck= 8M    ... Conv156CLK(19.5us) ~ Conv1248CLK(156us)
// fcgck= 4M    ... Conv78CLK (19.5us) ~ Conv624CLK (156us)
// fcgck= 2M    ... Conv39CLK (19.5us) ~ Conv312CLK (156us)
// fcgck= 1M    ... Conv39CLK (39us)   ~ Conv156CLK (156us)
// fcgck= 0.5M  ... Conv39CLK (78us)   ~ Conv78CLK  (156us)
// fcgck= 0.25M ... Conv39CLK (156us) 
#define     Conv39CLK       0x0 // ADתʱ-  39ʱ
#define     Conv78CLK       0x1 // ADתʱ-  78ʱ
#define     Conv156CLK      0x2 // ADתʱ- 156ʱ
#define     Conv312CLK      0x3 // ADתʱ- 312ʱ
#define     Conv624CLK      0x4 // ADתʱ- 624ʱ
#define     Conv1248CLK     0x5 // ADתʱ-1248ʱ
                                // (*עתʱӦ趨19.5us ~ 156us Χ)



extern uint  vref_l, vref_h, iReal_Vref, ADC_Code_READ;



void ADC_Init(uchar SAIN);
void ADC_Start(void);
void ADC_Stop(void);
void ADC_IntEnable(void);
void ADC_IntDisable(void);


uint ADC_SingleDetect(uchar SAIN);
uint ADC_RepeatDetect(uchar SAIN);

void __interrupt IntADC(void);






#endif








