//******************************************
//           This is a C Template file
//ߣ
//
//
//ע
//******************************************
//******************************************
//Stack Pointer	=	0x83f (If use mq6905_x_startup.asm)
//Ram range = 0x240~0x83f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "MQ6905.h"
#include "iApp.h"
#include "OPmode.h"
#include "KWU.h"
#include "ExtINT.h"
#include "ADC.h"





//--------------------------------------------------------------------------------------------------//
//	 <OPmode.h> ⲿ ( or ), ο˵
//	ⲿپ HXTAL(P00/P01)
//	ⲿپ LXTAL(P02/P03)
//.....................................................................................
//#undef	XTAL_High		// ⲿپ: #define(ʹþ) / #undef(þ) :
//#define	XTAL_Low		// ⲿپ: #define(ʹþ) --> MQ6905 ڲپѡⲿ :
//--------------------------------------------------------------------------------------------------//



void SYSTEM_INIT(void);



void main()
{
//----------------------------------------------------------------------//
//****** IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨 ****************//
//----------------------------------------------------------------------//
	SYSTEM_INIT();		// IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨
//----------------------------------------------------------------------//
	WDCDR.byte = 0x4e;				// clear wdt





//*********************************************************************
// 			: Each Mode Switch Sequence
//	Normal1	:----------------------------------------------------------
//			: --> Normal1
//			: --> IDLE0(INTTBT release)		--> Normal1
//			: --> IDLE1(Interrupt release)	--> Normal1
//			: --> STOP (ȴ)			--> Normal1
//	Normal2	:----------------------------------------------------------
//			: --> Normal2
//			: --> IDLE2(ȴж)			--> Normal2
//			: --> STOP (ȴ)			--> Normal2
//	SLOW2	:----------------------------------------------------------
//			: --> SLOW2
//	SLOW1	:----------------------------------------------------------
//			: --> SLOW1
//			: --> SLEEP0(INTTBT release)	--> SLOW1
//			: --> SLEEP1(Interrupt release)	--> SLOW1
//			: --> STOP  (ȴ)			--> SLOW1
//	--------:----------------------------------------------------------
//*********************************************************************


//----------------------------------------//
//	˷ KWI5  STOP mode
	d_KWU_05_EnL;
//......|..| EnL/EnH/Dis: stop mode release level, or Disable
//......| 00~15: KWU00~KWU15

//----------------------------------------//
//****** Entry SLOW1 mode ****************//
//----------------------------------------//
	OpMode_Change_to(iSlow1);		// ѡҪĹģʽ (iNor1/iNor2/iSlow2/iSlow1) ֮һ

//	SLOW1 entry stop mode ............
	Active_STOP;					// ˷ KWI5  STOP mode


	WDCDR.byte = 0x4e;				// clear wdt
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt

		__asm("CPL (_P8DR).1");		// toggle IO
		__asm("CPL (_P8DR).1");		// toggle IO
		__asm("CPL (_P8DR).1");		// toggle IO
		__asm("CPL (_P8DR).1");		// toggle IO
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}



//*********************************************************************
// 	: SYSTEM_INIT(void)
// 	: IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨
// ע		:
//*********************************************************************
void SYSTEM_INIT(void)
{
#ifdef _DEBUG	//...  _DEBUG(ģʽ): ڷ ev board
//------------------------------------------------------------------
//	(ϵͳĬ): ʱP10趨ΪReset PinԱӰ漰¼.
//	SYSCR3.byte   = 0x00;	// SYSCR3.bit.b0=1: P10趨ΪһIO, SYSCR3.bit.b0=0(Ԥֵ): P10Ϊ Reset Pin
//	SYSCR4.byte   = 0xB2;	// 0xB2:  SYSCR3.bit.b0 ֮趨ֵ
//------------------------------------------------------------------
#else			//...  һϵܳ(Ƿģʽ) P10(RESET) λΪһ IO 
//------------------------------------------------------------------
//-- P10趨ΪһIO ------
	SYSCR3.byte = 0x01;		// SYSCR3.bit.b0=1: P10趨ΪһIO, SYSCR3.bit.b0=0(Ԥֵ): P10Ϊ Reset Pin
	SYSCR4.byte = 0xB2;		// 0xB2:  SYSCR3.bit.b0 ֮趨ֵ
//------------------------------------------------------------------
#endif



//-- ʼ IO  (λ)------
#ifdef _DEBUG	//...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//	 P10/P20/P21  Debug modeڷʱ趨Ϊ룬
//	ԱӰ漰¼.
	P1DR.byte = 0x00;
	P1CR.byte = set8bit(11111110);		//  P10 Ϊ
	P2DR.byte = 0x00;
	P2CR.byte = set8bit(11111100);		//  P20/P21 Ϊ
//------------------------------------------------------------------
#else			//...  һϵܳ(Ƿģʽ)
//------------------------------------------------------------------
	P1DR.byte = 0x00;
	P1CR.byte = 0xff;
	P2DR.byte = 0x00;
	P2CR.byte = 0xff;
//------------------------------------------------------------------
#endif

//-- ʼ IO  ------
	P0DR.byte = 0x00;
	P0CR.byte = 0xff;
//	P1DR.byte = 0x00;
//	P1CR.byte = 0xff;
//	P2DR.byte = 0x00;
//	P2CR.byte = 0xff;
	P4DR.byte = 0x00;
	P4CR.byte = 0xff;
	P7DR.byte = 0x00;
	P7CR.byte = 0xff;
	P8DR.byte = 0x00;
	P8CR.byte = 0xff;
	P9DR.byte = 0x00;
	P9CR.byte = 0xff;
	PBDR.byte = 0x00;
	PBCR.byte = 0xff;
//	look_data(IRSTSR.byte);		// IRSTSR: ڲظλ״̬Ĵ
	WDCDR.byte = 0x4e;			// clear wdt


//	============================================
//	پƵãCGCR				;MQ6905 fc = 8MHz
//	============================================
	CGCR.byte = 0x00;			// ==> fcgck = fc/4 =  2Mhz(ϵͳĬ)
//	CGCR.byte = 0x01;			// ==> fcgck = fc/2 =  4Mhz
//	CGCR.byte = 0x02;			// ==> fcgck = fc   =  8Mhz
//	============================================
//	*** 벻Ҫڵģʽ(SLOW1/SLOW2) ı CGCR<FCGCKSEL> Ĵֵ
//	============================================


//--------------------------------------------------------------------------------------------------//
//	 <OPmode.h> ⲿ ( or ), ο˵
//	ⲿپ HXTAL(P00/P01)
//	ⲿپ LXTAL(P02/P03)
//.....................................................................................
//#undef	XTAL_High		// ⲿپ: #define(ʹþ) / #undef(þ) :
//#define	XTAL_Low		// ⲿپ: #define(ʹþ) --> MQ6905 ڲپѡⲿ :
//--------------------------------------------------------------------------------------------------//
//	кѡǷлⲿپ
	XTAL_High_Config();

}



void all_operation_mode_seq(void)
{
//----------------------------------------//
//****** Power on Ϊ Normal1 mode ******//
//----------------------------------------//

//	Normal1 entry stop mode ............
	__asm("CPL (_P8DR).1");
	Active_STOP;					// ˷ KWI5  STOP mode
	__asm("CPL (_P8DR).1");

//	Normal1 entry IDLE0 mode ............
	__asm("CPL (_P8DR).0");
	INTTBT_Init_OP();				// initial TBT timer setting
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	Active_IDLE0;					// TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	__asm("CPL (_P8DR).0");

//	Normal1 entry IDLE1 mode ............
	__asm("CPL (_P9DR).1");
	INTTBT_Init_OP();				// initial TBT timer setting
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	Active_IDLE1;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	__asm("CPL (_P9DR).1");

//----------------------------------------//
//****** Entry Normal2 mode **************//
//----------------------------------------//
	OpMode_Change_to(iNor2);		// ѡҪĹģʽ (iNor1/iNor2/iSlow2/iSlow1) ֮һ

//	Normal2 entry stop mode ............
	__asm("CPL (_P8DR).1");
	Active_STOP;					// ˷ KWI5  STOP mode
	__asm("CPL (_P8DR).1");

//	Normal2 entry IDLE2 mode ............
	__asm("CPL (_P9DR).1");
	INTTBT_Init_OP();				// initial TBT timer setting
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	Active_IDLE2;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	__asm("CPL (_P9DR).1");

//----------------------------------------//
//****** Entry SLOW2 mode ****************//
//----------------------------------------//
	OpMode_Change_to(iSlow2);		// ѡҪĹģʽ (iNor1/iNor2/iSlow2/iSlow1) ֮һ

//----------------------------------------//
//****** Entry SLOW1 mode ****************//
//----------------------------------------//
	OpMode_Change_to(iSlow1);		// ѡҪĹģʽ (iNor1/iNor2/iSlow2/iSlow1) ֮һ

//	SLOW1 entry stop mode ............
	__asm("CPL (_P8DR).1");
	Active_STOP;					// ˷ KWI5  STOP mode
	__asm("CPL (_P8DR).1");

//	SLOW1 entry SLEEP0 mode ............
	__asm("CPL (_P8DR).0");
	INTTBT_Init_OP();				// initial TBT timer setting
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	Active_SLEEP0;					// TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	__asm("CPL (_P8DR).0");

//	SLOW1 entry SLEEP1 mode ............
	__asm("CPL (_P9DR).1");
	INTTBT_Init_OP();				// initial TBT timer setting
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	Active_SLEEP1;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	__asm("CPL (_P9DR).1");
//----------------------------------------//
//----------------------------------------//
}



