
#include "MQ6905.h"
#include "iApp.h"
#include "IOI2C.h"




//*********************************************************************
// 	: IOI2C_set()
// 	:
// ע		:
//*********************************************************************
void IOI2C_set(void)
{
	P2OUTCR.bit.b6 = 1;		// SCL Ϊ©
	P2OUTCR.bit.b7 = 1;		// SDA Ϊ©

	I2C_SCL        = 1;
	I2C_SDA        = 1;
	I2C_SCL_CR     = 0;
	I2C_SDA_CR     = 0;

//	ȴ I2C_SDA  I2C_SCL Ϊ 1ʾ߿
	while( I2C_SCL_R==0 || I2C_SDA_R==0 ){ WDCDR.byte = 0x4e; }	

	I2C_SCL_CR     = 1;		// SCL Ϊ
	I2C_SDA_CR     = 1;		// SDA Ϊ
}



//*********************************************************************
// 	: IOI2C_start()
// 	: ʼźţ I2C_SCL źڸߵƽڼ I2C_SDA źŲһ½
// ע		: ʼ֮ I2C_SDA  I2C_SCL Ϊ0
//*********************************************************************
void IOI2C_start(void)
{
	I2C_SDA = 1;
	delay_times(t_100us, 1);
	I2C_SCL = 1;
	delay_times(t_100us, 1);

	I2C_SDA = 0;
	delay_times(t_100us, 1);
	I2C_SCL = 0;
	delay_times(t_100us, 1);
}


//*********************************************************************
// 	: IOI2C_stop()
// 	: ֹźţ I2C_SCL źŸߵƽڼ I2C_SDA źŲһ
// ע		: ֮󱣳 I2C_SDA  I2C_SCL Ϊ 1ʾ߿
//*********************************************************************
void IOI2C_stop(void)
{
	I2C_SDA = 0;
	delay_times(t_100us, 1);
	I2C_SCL = 1;
	delay_times(t_100us, 1);
	I2C_SDA = 1;
	delay_times(t_100us, 1);
}


//*********************************************************************
// 	: IOI2C_ByteSend()
// 	: byte write * len
// ע		:
//*********************************************************************
uchar IOI2C_ByteSend(uchar data, uchar ack)
{
	uchar a = 0, b = 0;

	for( a=0; a<8; a++ )		// Ҫ 8 λλʼ
	{
		I2C_SDA = data >> 7;	// ʼź֮ I2C_SCL=0ԿֱӸı I2C_SDA ź
		data <<= 1;
		delay_times(t_100us, 1);
		I2C_SCL = 1;
		delay_times(t_100us, 1);
		I2C_SCL = 0;
		delay_times(t_100us, 1);
	}
	I2C_SDA    = 1;
	I2C_SDA_CR = 0;				//  I2C_SDA Ϊ룬ȴӻ ACK Ѷ֮ж
	delay_times(t_100us, 1);
	I2C_SCL    = 1;
	while( I2C_SDA_R && ( ack == 1 ) )	// ȴ豸 I2C_SDA ӦѶ
	{
		delay_times(t_100us, 1);
		b++;
		if( b > 10 )
		{
			I2C_SCL    = 0;
			I2C_SDA_CR = 1;			//  I2C_SDA Ϊ
			return 0;
		}
	}

	I2C_SCL    = 0;
	I2C_SDA_CR = 1;				//  I2C_SDA Ϊ
	delay_times(t_100us, 1);
	return 1;
}


//*********************************************************************
// 	: IOI2C_ByteRead()
// 	: byte read * len
// ע		:
//*********************************************************************
uchar IOI2C_ByteRead(void)
{
	uchar a = 0, data = 0;

	I2C_SDA_CR = 0;				//  I2C_SDA Ϊ룬ȡ
	delay_times(t_100us, 1);

	for( a=0; a<8; a++ )		//  8 λ
	{
		I2C_SCL = 1;
		delay_times(t_100us, 1);
		data  <<= 1;
		data   |= I2C_SDA_R;
		delay_times(t_100us, 1);
		I2C_SCL = 0;
		delay_times(t_100us, 1);
	}

	I2C_SDA    = 1;
	I2C_SDA_CR = 1;				//  I2C_SDA Ϊ
	return data;
}


//*********************************************************************
// 	: At24Cxx_Write()
// 	: д 24Cxx һַ
// ע		:
//*********************************************************************
void At24Cxx_Write(uchar addr, uchar data)
{
	IOI2C_start();
	IOI2C_ByteSend(0xa0, 1);	// дַ
	IOI2C_ByteSend(addr, 1);	// Ҫдڴַ
	IOI2C_ByteSend(data, 1);	// 
	IOI2C_stop();
}


//*********************************************************************
// 	: At24Cxx_Read()
// 	: ȡ 24Cxx һַ
// ע		:
//*********************************************************************
uchar At24Cxx_Read(uchar addr)
{
	uchar num;

	IOI2C_start();
	IOI2C_ByteSend(0xa0, 1);	// дַ
	IOI2C_ByteSend(addr, 1);	// Ҫȡڴַ
	IOI2C_start();
	IOI2C_ByteSend(0xa1, 1);	// Ͷַ
	num = IOI2C_ByteRead();		// ȡ
	IOI2C_stop();

	return num;
}










