//***************************************************
//  : MQ6903_10BIT_TCC0.c
// 汾     : V1.0 2019/05/03MQ6903
//      : 10BIT TCC0 PPG ʹú
// ע     : 10BIT TCC0 PPG غ㼯ڱӳ
//****************************************************

#include "main.h"


//*********************************************************************
//    : TCC0_PPGC0x_Init
//  : TCC0 PPGC01/PPGC02 ռձȿɵģʽ
// ע     :
//          : ʹÿݼĴ
//          : 1. ģʽ : TCxCR1, TCxCR2
//          : 2. ʱ估ݼĴ: TCxDRA, TCxDRB, TCxDRD, TCxDRE (ֻеصģʽʹòҪ)
//          : 3. ڲݼĴ: TCxDRC
//          : 4. ʱ//ֹͣ: TCxCR3
//*********************************************************************
void TCC0_PPGC0x_Init(void)
{
//====== ܽųʼ ======
    P4CR_P4 = 1;                        // P44(PPGC01B)Ϊģʽ
    P4CR_P5 = 1;                        // P45(PPGC02B)Ϊģʽ

//====== ܿ( Enable) ======
    POFFCR0_TCC0EN = 1;		            // ȿݴò

//====== 趨 ======
	UATCNG_UAT2IO = 0;
	

//------ ------ ------ ------ ------ ------
// 1. ģʽ : TC0CR1, TC0CR2
//------ ------ ------ ------ ------ ------
    TC0CR1_TCCCK    =  0x02;            // TCCCK: ѡԴʱ
                    // 0x00: fcgck
                    // 0x01: fcgck/2
                    // 0x02: fcgck/2^2
                    // 0x03: fcgck/2^3
    TC0CR1_PPGC1INI = 0;                //  PPGCxINI ʼֵ,PPGC01 ʼֵΪ"͵ƽ"߼Ϊ"߼"
    TC0CR1_PPGC2INI = 0;                //  PPGCxINI ʼֵ,PPGC02 ʼֵΪ"͵ƽ"߼Ϊ"߼"
//	PxFC ùţڳʼֵ趨֮ PxFC
    P4FC_P4 = 1;                        // лP44(PPGC01B)Ϊ⹦ܽ
    P4FC_P5 = 1;                        // лP45(PPGC02B)Ϊ⹦ܽ

//------ ------ ------ ------ ------ ------
    TC0CR2_TCCOUT   =  0x00;            // TCCOUT: ѡȡģʽ
                    // 0x00: PPGC01/PPGC02
                    // 0x01: *ϵͳ
                    // 0x02: ռձȿɵ
                    // 0x03: ռձȹ̶50%

//------ ------ ------ ------ ------ ------
// 2. ʱ估ݼĴ: TC0DRA, TC0DRB, TC0DRD, TC0DRE (ֻеصģʽʹòҪ)
//------ ------ ------ ------ ------ ------
    TC0DRAL         = 0x06;             // ʱ1趨Ĵ(λ)   6
    TC0DRAH         = 0x00;             // ʱ1趨Ĵ(λ)

    TC0DRBL         = 0x20;             // 1趨Ĵ(λ)      32
    TC0DRBH         = 0x00;             // 1趨Ĵ(λ)

    TC0DRDL         = 0x10;             // ʱ2趨Ĵ(λ)   16
    TC0DRDH         = 0x00;             // ʱ2趨Ĵ(λ)

    TC0DREL         = 0x80;             // 2趨Ĵ(λ)      128
    TC0DREH         = 0x00;             // 2趨Ĵ(λ)

//------ ------ ------ ------ ------ ------
// 3. ڲݼĴ: TC0DRC
//------ ------ ------ ------ ------ ------
    TC0DRCL         = 0x80;             // 趨Ĵ(λ)        128
    TC0DRCH         = 0x00;             // 趨Ĵ(λ)

//------ ------ ------ ------ ------ ------
// 4. ʱ//ֹͣ: TC0CR3
//------ ------ ------ ------ ------ ------
    TC0CR3_STM      = 0x00;             // STM: ѡȡֹͣ״̬ / ѡȡһ
                //  --------|------------|----------------------------------
                //          | TCCST=1    | TCCST=0
                //  --------|------------|----------------------------------
                //    0x00: |    | ֹͣصʼ
                //    0x02: |    | ֹͣά״̬
                //    0x04: | һ   | ɵڵֹͣ
                //    0x06: | ϵͳ   | ϵͳ
                //  --------|------------|----------------------------------

}


//*********************************************************************
//    : TCC0_PPGC0x_Start
//  : TCC0
// ע     :
//*********************************************************************
void TCC0_PPGC0x_Start(void)
{
    TC0CR3_TCCST    = 1;                // 
}


//*********************************************************************
//    : TCC0_PPGC0x_Stop
//  : ֹͣTCC0
// ע     : 
//*********************************************************************
void TCC0_PPGC0x_Stop(void)
{
    TC0CR3_TCCST    = 0;                // ֹͣ
}


//*********************************************************************
//    : TCC0_PPGC0x_IntEnable
//  :  TCC0P,TCC0T ж
// ע     :
//*********************************************************************
void TCC0_PPGC0x_IntEnable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    IL_INTTCC0T     = 0;                // ж
    EI_INTTCC0T     = 1;                // 趨ж
    IL_INTTCC0P     = 0;                // ж
    EI_INTTCC0P     = 1;                // 趨ж
    EI;                                 // пж // EIRL_IMF=1
}



//*********************************************************************
//    : TCC0_PPGC0x_IntDisable
//  : ֹ TCC0P,TCC0T ж
// ע     :
//*********************************************************************
void TCC0_PPGC0x_IntDisable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    IL_INTTCC0T     = 0;                // ж
    EI_INTTCC0T     = 0;                // ж
    IL_INTTCC0P     = 0;                // ж
    EI_INTTCC0P     = 0;                // ж
    EI;                                 // пж // EIRL_IMF=1
}



//*********************************************************************
//    : IntTCC0T
//  : жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntTCC0T(void)
{
    NOP;                                // ָ
}



//*********************************************************************
//    : IntTCC0P
//  : жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntTCC0P(void)
{
    NOP;                                // ָ
}




