//*************************************************************
//  : main.c
// 汾     : V1.0 2019/05/03MQ6903
//      : 
// ע     : ģʽ÷(ʱ)
//*************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif

#include "main.h"

/* ----------------------  ------------------------------ */
BIT_LIST_8  _flag_8bit;
BIT_LIST_16 _flag_16bit;

/* ----------------------  -------------------------------- */
void main(){
    /* ---------------------- ϵͳʼ ------------------------ */
    System_Init();


    /* ---------------------- ܳʼ ------------------------ */	
	//  P42 KWI2 ͵ƽͷֹͣģʽ
	KWI_Enable();
	
	TBT_Init();
	
//----------------------------------------
//****** λΪ ͨ1(Normal1)ģʽ******
//----------------------------------------
//	[1.a]Normal1 >> stop mode -------------------------------------------------------------------
	//  P42 KWI2 ͵ƽͷ			
	ENTRY_STOP;						// ֹͣģʽ(Stop Mode)
	
									// ˷ KWI2  STOP mode
    //  P42  KWI2͵ƽϵͳֹͣģʽ(Stop Mode)	

//	[1.b]Normal1 >> IDLE0 mode ------------------------------------------------------------------									
                    				// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode	
	
	ENTRY_IDLE0;					// TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode	

//	[1.c]Normal1 >> IDLE1 mode ------------------------------------------------------------------	
	TBT_IntEnable();				
	TBT_Start();					// ˷ TBT Interrupt  IDLE1/IDLE2/SLEEP1 mode									
	ENTRY_IDLE1;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
	
	TBT_Stop(); 

//----------------------------------------
//******  Normal2 mode ************** 
//----------------------------------------
//  [2.a] >> Normal2 mode ("ⲿ"ʱ)
//	entry Normal2 by XTAL_Low
//  MQ6903 ֻʹⲿپ LXTAL(P02/P03)
    P0CR_P2 = 0;				// P02Ϊܽ,P02:XTIN  
	P0CR_P3 = 0;				// P03Ϊܽ,P03:XTOUT
	//	__asm("DI");
			DI;							
			
			WUCCR = 0x0e;				// 趨WUCʱԴķƵ״̬ 0x0c + 0x02
										// WUCDIV: (0x00/0x04/0x08/0x0c) source clock division (0/2/4/8)
										// WUCSEL: (0x00/0x01/0x02), (HIRC/HXtal/LIRC_LXtal)
			WUCDR = 0x26;				// WUCʱ趨
			IL_INTWUC   = 0;			// WUCж
			EI_INTWUC   = 1;			// WUCжϹ
			P0FC_P2   	= 1;			// лP02Ϊ⹦ܽ,ⲿ
			SYSCR2_XTEN = 1;			// ⲿʱ(XTEN=1),WUCʼ
			
		#ifdef _DEBUG					//...  _DEBUG: ڷ ev board
			Delay_Times(t_1ms, 800);
			Delay_Times(t_1ms, 800);
		#else
			while( IL_INTWUC == 0 ){
				   WDCDR = 0x4e; }		// ȴINTWUC
		#endif
			IL_INTWUC = 0;				// WUCж״̬    
			EI_INTWUC = 0;				// رWUCжϹ


//	[2.b]Normal2 >> stop mode ---------------------------------------------------------------------	
	//  P42 KWI2 ͵ƽͷ
	ENTRY_STOP;						// ֹͣģʽ(Stop Mode)
	
									// ˷ KWI2  STOP mode
	//  P42  KWI2͵ƽϵͳֹͣģʽ(Stop Mode)
	
//	[2.c]Normal2 >> IDLE2 mode --------------------------------------------------------------------
	TBT_Start();					// initial TBT timer setting
	
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	ENTRY_IDLE2;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
	TBT_Stop();						// clear INTTBT setting after release IDLE0/SLEEP0 mode	

//----------------------------------------
//******  SLOW2 mode **************** 
//----------------------------------------
//	[3.a] >> SLOW2 mode
//	entry Normal2 by XTAL_Low
//  MQ6903 ֻʹⲿپ LXTAL(P02/P03)
    P0CR_P2 = 0;				// P02Ϊܽ,P02:XTIN  
	P0CR_P3 = 0;				// P03Ϊܽ,P03:XTOUT
	//	__asm("DI");
			DI;							
			
			WUCCR = 0x0e;				// 趨WUCʱԴķƵ״̬ 0x0c + 0x02
										// WUCDIV: (0x00/0x04/0x08/0x0c) source clock division (0/2/4/8)
										// WUCSEL: (0x00/0x01/0x02), (HIRC/HXtal/LIRC_LXtal)
			WUCDR = 0x26;				// WUCʱ趨
			IL_INTWUC   = 0;			// WUCж
			EI_INTWUC   = 1;			// WUCжϹ
			P0FC_P2   	= 1;			// лP02Ϊ⹦ܽ,ⲿ
			SYSCR2_XTEN = 1;			// ⲿʱ(XTEN=1),WUCʼ
			
		#ifdef _DEBUG					//...  _DEBUG: ڷ ev board
			Delay_Times(t_1ms, 800);
			Delay_Times(t_1ms, 800);
		#else
			while( IL_INTWUC == 0 ){
				   WDCDR = 0x4e; }		// ȴINTWUC
		#endif
			IL_INTWUC = 0;				// WUCж״̬    
			EI_INTWUC = 0;				// رWUCжϹ
	
	SYSCR2_SYSCK = 1;				// [SYSCK]=1 ϵͳʱΪʱӣ SLOW2

	
//----------------------------------------
//******  SLOW1 mode **************** 
//----------------------------------------
//	[3.b] >> SLOW1 mode	
	SYSCR2_OSCEN = 0;				// رոʱӣ SLOW1
	
//	[3.c]SLOW1 >> stop mode -------------------------------------------------------------------------	
	
	ENTRY_STOP;						// ˷ KWI2  STOP mode
		
//	[3.d]SLOW1  SLEEP0 mode -------------------------------------------------------------------------	
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	ENTRY_SLEEP0;					// TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode	
	
//	[3.e]SLOW1  SLEEP1 mode -------------------------------------------------------------------------
	TBT_Start();					// initial TBT timer setting									
									
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode	
	ENTRY_SLEEP1;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
	TBT_Stop();				
	
//----------------------------------------
//----------------------------------------
	

//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1){
	
		CLR_WDT;
		NOP;
		NOP;
		NOP;
	}
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}


















/*---------------------- жϷ ------------------------*/
//=============== Dummy function for interrupt ============
void __interrupt Int_dummy(void)
{

}
//=========================================================
void __interrupt OnlyReti(void)
{
    NOP;                                // ָ
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10;    	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}     
/*-----------------  жϷ ------------------------*/

/*------------------------ MQ6903ж ------------------------*/
#pragma section const INT_VECTOR 0xffc2
void * const IntTbl1[] = {  
    OnlyReti,           // 0xffc2 : IntTCC0T
    OnlyReti,           // 0xffc4 : IntTCC0P
    OnlyReti,           // 0xffc6 : IntTEMG0
    OnlyReti,           // 0xffc8 : IntTXD2
    OnlyReti,           // 0xffca : IntRXD2
    Int_dummy,          // 0xffcc : Reserved
    Int_dummy,          // 0xffce : Reserved
    OnlyReti,           // 0xffd0 : IntTXD1
    OnlyReti,           // 0xffd2 : IntRXD1
    Int_dummy,          // 0xffd4 : Reserved
    Int_dummy,          // 0xffd6 : Reserved
    OnlyReti,           // 0xffd8 : Int3
    OnlyReti,           // 0xffda : Int2
    OnlyReti,           // 0xffdc : Int1
    OnlyReti,           // 0xffde : Int0
    OnlyReti,           // 0xffe0 : IntSBI0 / IntSIO0
    OnlyReti,           // 0xffe2 : IntTCA0
    OnlyReti,           // 0xffe4 : IntTC01
    OnlyReti,           // 0xffe6 : IntTC00
    OnlyReti,           // 0xffe8 : IntRTC
    OnlyReti,           // 0xffea : IntADC
    OnlyReti,            // 0xffec : IntVLTD
    OnlyReti,           // 0xffee : Int5
    OnlyReti,           // 0xfff0 : IntTXD0
    OnlyReti,           // 0xfff2 : IntRXD0
    OnlyReti,           // 0xfff4 : IntTBT
    OnlyReti,           // 0xfff6 : IntWUC
    IntWDT,             // 0xfff8 : IntWDT
    (void *)0xffff,     // 0xfffa : Reserved
    IntSWI,             // 0xfffc : IntSWI/INTUNDEF
    STARTUP             // 0xfffe : RESET					
};
#pragma section const
/*-------------------  MQ6903ж ------------------------*/

















//*********************************************************************
//    : System_Init(void)
//  : IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨
// ע     :
//*********************************************************************
void System_Init(void)
{


    
#ifdef _DEBUG   //...  _DEBUG(ģʽ): ڷ ev board
//------------------------------------------------------------------
//  (ϵͳĬ): ʱP10趨ΪReset PinԱӰ漰¼.
//  SET_P10_RESET_PIN;
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ) P10(RESET) λΪһ IO 
//------------------------------------------------------------------
//-- P10趨ΪһIO ------
    SET_P10_IO_PIN;
//------------------------------------------------------------------
#endif



//-- ʼ IO  (λ)------
#ifdef _DEBUG   //...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//   P10/P20/P21  Debug modeڷʱ趨Ϊ룬
//  ԱӰ漰¼.
    P1DR = 0x00;
    P1CR = set8bit(11111110);           //  P10 Ϊ
    P2DR = 0x00;
    P2CR = set8bit(11111100);           //  P20/P21 Ϊ
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//------------------------------------------------------------------
#endif

//-- ʼ IO  ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
//  P2DR = 0x00;
//  P2CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;    
    P7DR = 0x00;
    P7CR = 0xff;
    P9DR = 0x00;
    P9CR = 0xff;

    CLR_WDT;                            // Źʱ (ι)
}



//*********************************************************************
//    : Delay_Times
//  : ʱ
// ע     : ==> t_1ms   = 0;          // ӳʱ䵥λ ms
//          : ==> t_100us = 1;          // ӳʱ䵥λ usϴ
//          : ɹ̶Ȧʱһʱ䣬ʹ÷£
//          : Delay_Times(t_1ms, 800);  // ӳ 800ms
//*********************************************************************
void Delay_Times(uchar tBase, uint x)
{
    uint  i, cgcrT;

    uchar cgcrF[4]={ 2, 4,  8, 1 };     // پƵΪ  8MHz ʱʹô
//  uchar cgcrF[4]={ 4, 8, 16, 2 };     // پƵΪ 16MHz ʱʹô

//  ϵͳڸʱ(ͨ1ͨ2ģʽ) ʱ
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  ϵͳڵʱ(12ģʽ) ʱϴ󣬲οʹã
    else for(; x>0; x--){}

    CLR_WDT;                            // Źʱ (ι)
}














