//*******************************************************************
//  : main.c
// 汾     : V1.0 2019/05/03MQ6903
//      : 
// ע     : FLASH 洢
// 		 ***  ȷFLASHʽִǰоƬϵ硢λ
//********************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif

#include "main.h"


/* ----------------------------------  ------------------------------------------ */
#pragma section const DataFlashArea	0xD000
const uchar dataflash[0x580] = {
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  0
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  1
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  2
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  3
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  4
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  5
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  6
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  7
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  8
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  9
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	// 10
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	// 11
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	// 12
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	// 13
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	// 14
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88	// 15
							   };
#pragma section const

uchar varlist[0x81] = {
						0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
						0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38
	 				  };
					
uchar varbyte = 0x55;


/* ---------------------------------------  --------------------------------------- */
void main()
{
//----------------------------------------------------------------------//
//****** IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨 ****************//
//----------------------------------------------------------------------//
	System_Init();   		
//----------------------------------------------------------------------//
	CLR_WDT;                        			// Źʱ (ι)

	Flash_SEC_ERS(0xD000, Erase_128byte);		// ַ0xD000ʼ128 byte֮data
	
	Flash_PGM_Byte(0xD000,   1, &varbyte);		// 0xD000ַд0x55 

	Flash_PGM_Byte(0xD002,   1, &varlist[5]);	// 0xD002ַд0x16 
	Flash_PGM_Byte(0xD005,   3, &varlist[2]);	// 0xD005ַʼΪ3,дvarlist[2]~[4]֮data
												// 0xD005д0x13
												// 0xD006д0x14
												// 0xD007д0x15
	Flash_PGM_Byte(0xD010,   5, &varlist[0]);	// 0xD010ַʼΪ5,дvarlist[0]~[4]֮data
												// 0xD010д0x11
												// 0xD011д0x12
												// 0xD012д0x13
												// 0xD013д0x14
												// 0xD014д0x15
	varbyte = FlashReadByte(0xD010);			// varbyte = 0x11
	FlashReadSequence(0xD002,   1, &varbyte);	// 0xD002ַʼȡ FLASH ﳤ Ϊ1ϣvarbyte

	FlashReadSequence(0xD002,   1, varlist);
	FlashReadSequence(0xD002,   1, &varlist[1]);// 0xD002ַʼȡ FLASH ﳤ Ϊ1ϣvarlist[1]
	FlashReadSequence(0xD00f,  10, &varlist[2]);// 0xD00Fַʼȡ FLASH ﳤ Ϊ10ϣvarlist[2]~[11]
												// ȡ 0xD00FַFLASHϣvarlist[2]
												// ȡ 0xD010ַFLASHϣvarlist[3]
												// ȡ 0xD011ַFLASHϣvarlist[4]
												// ȡ 0xD012ַFLASHϣvarlist[5]
												// ȡ 0xD013ַFLASHϣvarlist[6]
												// ....

	Flash_SEC_ERS(0xD000, Erase_1024byte);		// ַ0xD000ʼ1024byte֮data
	Flash_PGM_Byte(0xD000, 129, varlist);

	CLR_WDT;                        			// Źʱ (ι)


	Flash_SEC_ERS(0xD000, Erase_128byte);		// ַ0xD000ʼ128 byte֮data

	Flash_PGM_Byte(0xD000, 8, varlist);			// 0xD000ַʼΪ8,дvarlist[0]~[7]֮data

	Flash_SEC_ERS(0xD000, Erase_1024byte);		// ַ0xD000ʼ1024byte֮data	


	CLR_WDT;                        			// Źʱ (ι)
	
	
    //-----------------------------------------------------------------------------------
    //-----------------------------------------------------------------------------------       
	
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
	while(1)
    {
        CLR_WDT;                        		// Źʱ (ι)

        NOP;                            		// ָ
        NOP;                            		// ָ
        NOP;                            		// ָ
    }
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 

}
















/*---------------------------------- жϷ ------------------------------------*/
//=============== Dummy function for interrupt ============
void __interrupt Int_dummy(void)
{

}
//=========================================================
void __interrupt OnlyReti(void)
{
    NOP;                                // ָ
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10;    	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}     
/*-----------------------------  жϷ ------------------------------------*/

/*------------------------ MQ6903ж ------------------------*/
#pragma section const INT_VECTOR 0xffc2
void * const IntTbl1[] = {  
    OnlyReti,           // 0xffc2 : IntTCC0T
    OnlyReti,           // 0xffc4 : IntTCC0P
    OnlyReti,           // 0xffc6 : IntTEMG0
    OnlyReti,           // 0xffc8 : IntTXD2
    OnlyReti,           // 0xffca : IntRXD2
    Int_dummy,          // 0xffcc : Reserved
    Int_dummy,          // 0xffce : Reserved
    OnlyReti,           // 0xffd0 : IntTXD1
    OnlyReti,           // 0xffd2 : IntRXD1
    Int_dummy,          // 0xffd4 : Reserved
    Int_dummy,          // 0xffd6 : Reserved
    OnlyReti,           // 0xffd8 : Int3
    OnlyReti,           // 0xffda : Int2
    OnlyReti,           // 0xffdc : Int1
    OnlyReti,           // 0xffde : Int0
    OnlyReti,           // 0xffe0 : IntSBI0 / IntSIO0
    OnlyReti,           // 0xffe2 : IntTCA0
    OnlyReti,           // 0xffe4 : IntTC01
    OnlyReti,           // 0xffe6 : IntTC00
    OnlyReti,           // 0xffe8 : IntRTC
    OnlyReti,           // 0xffea : IntADC
    OnlyReti,           // 0xffec : IntVLTD
    OnlyReti,           // 0xffee : Int5
    OnlyReti,           // 0xfff0 : IntTXD0
    OnlyReti,           // 0xfff2 : IntRXD0
    OnlyReti,           // 0xfff4 : IntTBT
    OnlyReti,           // 0xfff6 : IntWUC
    IntWDT,             // 0xfff8 : IntWDT
    (void *)0xffff,     // 0xfffa : Reserved
    IntSWI,             // 0xfffc : IntSWI/INTUNDEF
    STARTUP             // 0xfffe : RESET					
};
#pragma section const
/*-------------------  MQ6903ж ------------------------*/




//*********************************************************************
//    : System_Init(void)
//  : IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨
// ע     :
//*********************************************************************
void System_Init(void)
{


    
#ifdef _DEBUG   //...  _DEBUG(ģʽ): ڷ ev board
//------------------------------------------------------------------
//  (ϵͳĬ): ʱP10趨ΪReset PinԱӰ漰¼.
//  SET_P10_RESET_PIN;
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ) P10(RESET) λΪһ IO 
//------------------------------------------------------------------
//-- P10趨ΪһIO ------
    SET_P10_IO_PIN;
//------------------------------------------------------------------
#endif



//-- ʼ IO  (λ)------
#ifdef _DEBUG   //...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//   P10/P20/P21  Debug modeڷʱ趨Ϊ룬
//  ԱӰ漰¼.
    P1DR = 0x00;
    P1CR = set8bit(11111110);           //  P10 Ϊ
    P2DR = 0x00;
    P2CR = set8bit(11111100);           //  P20/P21 Ϊ
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//------------------------------------------------------------------
#endif

//-- ʼ IO  ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
//  P2DR = 0x00;
//  P2CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;    
    P7DR = 0x00;
    P7CR = 0xff;
    P9DR = 0x00;
    P9CR = 0xff;

    CLR_WDT;                            // Źʱ (ι)
}


//*********************************************************************
//    : Delay_Times
//  : ʱ
// ע     : ==> t_1ms   = 0;          // ӳʱ䵥λ ms
//          : ==> t_100us = 1;          // ӳʱ䵥λ usϴ
//          : ɹ̶Ȧʱһʱ䣬ʹ÷£
//          : Delay_Times(t_1ms, 800);  // ӳ 800ms
//*********************************************************************
void Delay_Times(uchar tBase, uint x)
{
    uint  i, cgcrT;

    uchar cgcrF[4]={ 2, 4,  8, 1 };     // پƵΪ  8MHz ʱʹô
//  uchar cgcrF[4]={ 4, 8, 16, 2 };     // پƵΪ 16MHz ʱʹô

//  ϵͳڸʱ(ͨ1ͨ2ģʽ) ʱ
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  ϵͳڵʱ(12ģʽ) ʱϴ󣬲οʹã
    else for(; x>0; x--){}

    CLR_WDT;                            // Źʱ (ι)
}

