//******************************************
//  : MQ6902_UART
// 汾     : V 1.00
//      : UARTʹú
// ע     :
//******************************************

#include "main.h"


unsigned char RX_DATA,recvCnt;
extern unsigned char recvBuf[10];	

//*********************************************************************
//    : UART0_Init
//  : IO,UARTʼ
// ע     : ģʽΪNormal1,Normal2
//*********************************************************************
void UART0_Init(void)
{
//====== ܽųʼ ======	
    P2CR_P1 = 0;                        // 趨P21
    P2CR_P0 = 1;                        // 趨P20
    P2FC_P0 = 1;                        // лP20Ϊ⹦ܽ

 	SERSEL_SRSEL0 = 0;					// ѡUART0 I2C0 
    UATCNG_UAT0IO = 0;                  // 0: 趨 P20 TX, P21 RX  ,1: 趨 P21 TX, P20 RX

//====== ܿ( Enable) ======
    POFFCR1_UART0EN = 1;                // ȿݴò

//====== 趨 ======
	UART0CR1_PE		= 0;				// żУλ
	UART0CR1_STOPBT	= 0;				// TXֹͣλ : 1λ
	UART0CR2_STOPBR	= 0;				// RXֹͣλ : 1λ
	UART0CR1_BRG	= 0;				// 0: շʱ = fcgck
										// 1: շʱ = TCA0  (ɴɼBaud rate)

//------ Baud rate = 9600
//--- fcgck @ 16MHz
/* 
    UART0CR2_RTSEL = 0x01;
    UART0DR        = 0x64;
 */	
//--- fcgck @ 8MHz
/* 
    UART0CR2_RTSEL = 0x04;
    UART0DR        = 0x30;
 */
//--- fcgck @ 4MHz
/*
    UART0CR2_RTSEL = 0x00;
    UART0DR        = 0x19;
*/	
//--- fcgck @ 2MHz
 
    UART0CR2_RTSEL = 0x00;
    UART0DR        = 0x0c;


//------ Baud rate = 115200
//--- fcgck @ 16MHz
/* 
    UART0CR2_RTSEL = 0x03;
    UART0DR        = 0x08;
 */
//--- fcgck @ 8MHz
/* 
    UART0CR2_RTSEL = 0x04;
    UART0DR        = 0x03;
 */
//--- fcgck @ 4MHz
/* 
    UART0CR2_RTSEL = 0x04;
    UART0DR        = 0x01;
 */
//--- fcgck @ 2MHz
/* 
    UART0CR2_RTSEL = 0x04;
    UART0DR        = 0x00;
 */

}


//*********************************************************************
//    : UART0_Start
//  : UART
// ע     :
//*********************************************************************
void UART0_Start(void)
{
    UART0CR1_TXE = 1;                   //  TX
    UART0CR1_RXE = 1;                   //  RX
}


//*********************************************************************
//    : UART0_Stop
//  : ֹͣUART
// ע     :
//*********************************************************************
void UART0_Stop(void)
{
    UART0CR1_TXE = 0;                   // ֹͣ TX
    UART0CR1_RXE = 0;                   // ֹͣ RX
}


//*********************************************************************
//    : UART0_IntEnable
//  : UARTж
// ע     : ִкῪж(IMF)
//*********************************************************************
void UART0_IntEnable(void)
{
    DI;                                 // ֹпж 
/* 	
    IL_INTTXD0      = 0;                // TXж
    EI_INTTXD0      = 1;                // 趨TXж
 */	
    IL_INTRXD0      = 0;                // RXж
    EI_INTRXD0      = 1;                // 趨RXж
    EI;                                 // пж 
}


//*********************************************************************
//    : UART0_IntDisable
//  : ֹUARTж
// ע     : ִкῪж(IMF)
//*********************************************************************
void UART0_IntDisable(void)
{
    DI;                                 // ֹпж 
/* 	
    EI_INTTXD0      = 0;                // TXж
	IL_INTTXD0      = 0;                // TXж    
 */	
    EI_INTRXD0      = 0;                // RXж
	IL_INTRXD0      = 0;                // RXж    
    EI;                                 // пж 
}



//*********************************************************************
//    : IntRXD0_SIO0
//  : жӳ
// ע     :
//*********************************************************************
void __interrupt IntRXD0_SIO0(void)
{
	BIT_LIST_8 uart_flag;
	
	uart_flag.byte = UART0SR;   		// get flag data
	
	 									// get flag data [PERR, FERR, OERR, -, RBSY, RBFL, TBSY, TBFL]
                                        // PERR    żУ   0: żУ
                                        //                            1: żУ
                                        // RFERR   շ     0: շ
                                        //                            1: շ
                                        // OERR           0: 
                                        //                            1: 
                                        // RBSY    æµ       0: ǰչ
                                        //                            1: 
                                        // RBFL    ջ 0: ջΪ
                                        //                            1: ջ
                                        // TBSY    æµ       0: ǰ͹
                                        //                            1: 
                                        // TBFL    ͻ 0: ͻΪ
                                        //                            1: ͻ
										
	RX_DATA = RD0BUF;				    // get Rx data and clear UART0SR flag										
	// Error handle
	if(uart_flag.bit.b7 == 1){
										// żУ
	}
	else if(uart_flag.bit.b6 == 1){
										// շ
	}
	else if(uart_flag.bit.b5 == 1){
										// 
	}
	else{
		recvBuf[(recvCnt++)%10]= RX_DATA;		// No Error, store the data
		
	}
	
	
	
}





//*********************************************************************
//    : UART0_SendData
//  : UART0 ䷶
// ע     :
//*********************************************************************
void UART0_SendData(const uchar * buf,uint length)
{
    uint sendloop;

    for( sendloop = 0; sendloop < length; sendloop++ ){
        while( UART0SR_TBFL ){          // ȴͻΪգٴдҪʹ֮        
            CLR_WDT;                    // Źʱ (ι)
        }
        TD0BUF = buf[sendloop];
    }

    while( UART0SR_TBSY ){               // ȴ͹    
        CLR_WDT;                        // Źʱ (ι)
    }
}


