//******************************************
//  ƣ MQ6902_TC0_16Bit
//  汾     V 1.00
//       TC00 TC01 16Bit Timer,PPG ʹú
//  ע    
//******************************************

#include "main.h"

//*********************************************************************
//    : T001_16BitTimer_Init
//  : T001_16BitTimer_Init ʼʽ
// ע     :
//*********************************************************************
void T001_16BitTimer_Init(void)
{
//====== ܽųʼ ======

//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // @_, PO

//====== 趨 ======
    T001CR_TCAS     = 1;                // x񌢃ɂ8λMӋrMʹ
    T01MOD_TFF      = 1;                // Oʼֵߜλռձ    

    T01MOD_TCM      = 0;                // 趨Ϊ 16 λʱģʽ   
    T01MOD_DBE      = 1;                // ʹp
    T01MOD_TCK      = 5;                // fcgck/4 = 1MHz,   
    
    T00REG          = 100;
    T01REG          = 200;              // Timer Period =    51300          / 1MHz = 51.3 ms
                                        //               (200*256 + 100)
    
    NOP;                                // ָ
}

//*********************************************************************
//    : T001_16BitPPG_Init
//  : T001_16BitPPG_Init ʼʽ
// ע     :
//*********************************************************************
void T001_16BitPPG_Init(void)
{
//====== ܽųʼ ======
    P7DR_P1         = 1;                // ܽʼͬ PPG ĳʼֵ(T0xMOD_TFF)
    P7CR_P1         = 1;                // ܽ趨Ϊ

//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // @_, PO

//====== 趨 ======
    T001CR_TCAS     = 1;                // x񌢃ɂ8λMӋrMʹ
    T01MOD_TFF      = 1;                // Oʼֵߜλռձ    
//  PxFC ùţڳʼֵ趨֮ PxFC
    P7FC_P1         = 1;                // ܽ趨Ϊ PPG 
    
    T01MOD_TCM      = 3;                // 趨Ϊ 16 λɱ PPG ģʽ
    T01MOD_DBE      = 1;                // ʹp
    T01MOD_TCK      = 7;                // TCK = fcgck = 8MHz,   
    
    T00REG          = 50;
    T01REG          = 100;              // Timer Period =    25650          /  8MHz  =  3.2 ms
                                        //               (100*256 + 50)
    
    T00PWM          = 40;   
    T01PWM          = 80;               // Duty = 20520 / 25650  = 80%
    
    NOP;                                // ָ
}


//*********************************************************************
//    : T001_16Bit_Start
//  : T001_16Bit_Start 
// ע     :
//*********************************************************************
void T001_16Bit_Start(void)
{
    T001CR_T01RUN = 1;
}


//*********************************************************************
//    : T001_16Bit_Stop
//  : T001_16Bit_Stop ֹͣ
// ע     :
//*********************************************************************
void T001_16Bit_Stop(void)
{
    T001CR_T01RUN = 0;
}


//*********************************************************************
//    : T001_16Bit_IntEnable
//  : TC01 ж
// ע     : ִкῪж(IMF)
//*********************************************************************
void T001_16Bit_IntEnable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    IL_INTTC01 = 0;                     // ж
    EI_INTTC01 = 1;                     // 趨ж
    EI;                                 // пж // EIRL_IMF=1
}

//*********************************************************************
//    : T001_16Bit_IntDisable
//  : TC01 жϳ
// ע     : ִкῪж(IMF)
//*********************************************************************
void T001_16Bit_IntDisable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    EI_INTTC01 = 0;                     // ж
    IL_INTTC01 = 0;                     // ж
    EI;                                 // пж // EIRL_IMF=1
}

//*********************************************************************
//    : T001_16Bit_SetDuty
//  : Oռձ
// ע     : ռձ = [T01PWM:T00PWM] / [T01REG:T00REG]
//*********************************************************************
void T001_16Bit_SetDuty(uint pwmDuty)
{    
    T00PWM = pwmDuty&0xff;              // Oλ
    T01PWM = pwmDuty>>8;                // Oλ
}

//*********************************************************************
//    : T001_16Bit_SetPeriod
//  : OL
// ע     : 
//*********************************************************************
void T001_16Bit_SetPeriod(uint period)
{    
    T00REG = period&0xff;               // Oλ
    T01REG = period>>8;                 // Oλ
}

//*********************************************************************
//    : IntTC01
//  : TC01 жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntTC01(void)
{   
    P7DR_P0 = !P7DR_P0;
    NOP;                                // ָ
}


























