//******************************************
//  : main
// 汾     : V1.0
//      : 
// ע     : ģʽ÷(ʱ)
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif

#include "main.h"

/* ----------------------  ------------------------ */
BIT_LIST_8  _flag_8bit;
BIT_LIST_16 _flag_16bit;

/* ----------------------  -------------------------- */
void main(){
    /* ---------------------- ϵͳʼ ------------------------ */
    System_Init();


    /* ---------------------- ܳʼ ------------------- */	
	//  P42 KWI2 ͵ƽͷֹͣģʽ
	KWI_Enable();
	
	TBT_Init();
	
//----------------------------------------//
//****** λΪ Normal1 mode ******//
//----------------------------------------//


				//----------------------------------------------- 
				//  ΪNormal1 to Stop/Idle0/Idle1 
                // 	ҪNormal1/Normal2/Slow2/Slow1лɲִг
				//----------------------------------------------- 
				//	Normal1 ---> stop mode ............					
					
					ENTRY_STOP;						// ˷ KWI2  STOP mode					
					// KWI2 ѺϵͳصNormal1
					
				//	Normal1 ---> IDLE0 mode ............									
													// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode	
					
					ENTRY_IDLE0;					// TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode	
					// TBT ѺϵͳصNormal1

				//	Normal1 ---> IDLE1 mode ............	
					TBT_IntEnable();				
					TBT_Start();					// ˷ TBT Interrupt  IDLE1/IDLE2/SLEEP1 mode									
					
					
					ENTRY_IDLE1;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
					// TBT ѺϵͳصNormal1
					
					TBT_Stop();   
				//----------------------------------------------- 	
				//  Normal1 to Stop/Idle0/Idle1 
				//----------------------------------------------- 		
					
//----------------------------------------//
//****** Normal1 ---> Normal2 mode *******//
//----------------------------------------//
	// Normal2 mode (ⲿʱ)
    // ⲿʱ(fs=32768Hz)ʹ WUC ůⲿʱӣȷƵȶ  
    P0CR_P2      = 0;                   // P00:XTIN
    P0CR_P3      = 0;                   // P01:XTOUT 
    WUCCR_WUCSEL = 2;                   // ѡʱΪԴʱ     0:HIRC     1:ⲿʱ
    WUCCR_WUCDIV = 0;                   // Դʱ / 1                                                
    WUCDR        = 0x33;                // üֵ        
    IL_INTWUC    = 0;                   // WUCж
    EI_INTWUC    = 0;                   // ֹCPUWUCжź
    P0FC_P2      = 1;                                       
    SYSCR2_XTEN  = 1;                   // ⲿʱ(XTEN=1)  WUC ʼ
                                        
    while( IL_INTWUC == 0 ){            
        CLR_WDT;                        // ȴWUC INTWUC 0 -> 1
										// ůʱ= (0x33 * 64) * (1/32768)P100ms
    }                                   
    IL_INTWUC    = 0;                   // ůWUCж
	
	
				//----------------------------------------------- 
				//  ΪNormal2 to Stop/Idle2 
                // 	ҪNormal1/Normal2/Slow2/Slow1лɲִг
				//----------------------------------------------- 	
				//	Normal2 ---> stop mode ............	
					
					ENTRY_STOP;					// ˷ KWI2  STOP mode
					// KWI2 ѺϵͳصNormal2
					
				//	Normal2 ---> IDLE2 mode ............
					TBT_Start();					// initial TBT timer setting
																						
													
					ENTRY_IDLE2;					// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
													// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
					// TBT ѺϵͳصNormal2							
													
					TBT_Stop();						// clear INTTBT setting after release IDLE0/SLEEP0 mode	
				//----------------------------------------------- 	
				//  Normal2 to Stop/Idle2 
				//----------------------------------------------- 		
				
//----------------------------------------//
//****** Normal2 ---> Slow2 mode *********//
//----------------------------------------//	
	SYSCR2_SYSCK = 1;				// лϵͳʱ  ⲿʱӣ SLOW2

	
	
	
//----------------------------------------//
//****** Slow2   ---> Slow1 mode *********//
//----------------------------------------//	
	SYSCR2_OSCEN = 0;				// رոʱӣ SLOW1
	
	
				//----------------------------------------------- 
				//  ΪSlow1 to Stop/Sleep0/Sleep1 
                // 	ҪNormal1/Normal2/Slow2/Slow1лɲִг
				//----------------------------------------------- 
				//	SLOW1 entry stop mode ............	
					
					ENTRY_STOP;					// ˷ KWI5  STOP mode
					// KWI2 ѺϵͳصSlow1	
				//	SLOW1 entry SLEEP0 mode ............	
													// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
					ENTRY_SLEEP0;					// TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode	
					// TBT ѺϵͳصSlow1
				//	SLOW1 entry SLEEP1 mode ............
					TBT_Start();					// initial TBT timer setting									
													
													// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode	
					ENTRY_SLEEP1;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
					// TBT ѺϵͳصSlow1
					
					TBT_Stop();		
				//----------------------------------------------- 	
				//  Slow1 to Stop/Sleep0/Sleep1 
				//----------------------------------------------- 			


//----------------------------------------//
//****** Slow1   ---> Slow2 mode *********//
//----------------------------------------//
  // ڲʱ(fosc = 8MHz)ʹ WUC ůڲʱӣȷƵȶ  
    WUCCR_WUCSEL = 0;                   // ѡڲʱΪԴʱ
    WUCCR_WUCDIV = 0;                   // Դʱ / 1                                                
    WUCDR        = 0x26;                // üֵ        
    IL_INTWUC    = 0;                   // WUCж
    EI_INTWUC    = 0;                   // ֹCPUWUCжź    
    SYSCR2_OSCEN = 1;                   // ڲʱ(OSCEN=1)  WUC ʼ
                                        
    while( IL_INTWUC == 0 ){            
        CLR_WDT;                        // ȴWUC INTWUC 0 -> 1
									    // ůʱ= (0x26 * 64) * (1/8M)P300 us
    }                                   
    IL_INTWUC    = 0;                   // ůWUCж


//----------------------------------------//
//****** Slow2   ---> Normal2 mode *********//
//----------------------------------------//
	SYSCR2_SYSCK = 0;				    // лϵͳʱ  ʱӣ Normal2

	
//----------------------------------------//
//****** Normal2   ---> Normal1 mode *********//
//----------------------------------------//
	SYSCR2_XTEN  = 0;				    // رյʱӣ Normal1
	
	
	
//----------------------------------------//
//----------------------------------------//
	

//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1){
	
		CLR_WDT;
		NOP;
		NOP;
		NOP;
	}
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}












/*---------------------- жϷ ------------------------*/
void __interrupt OnlyReti(void)
{
    NOP;                                // ָ
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10;    	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}      
/*-----------------  жϷ ------------------------*/

// -------------------- MQ6902 ж ----------------------
//  [ ж ] Ҫжид
//  1. ʹ֮߳жж֮OnlyRetiΪӦж
//  2. ӦڵַжƣֱӸ
//
//  ʹⲿж2ӦжϱеOnlyRetiΪ Int2
//   Int2,                /* 0xffda : Int2*/  (ⲿж2)
// ----------------------------------------------------------------
/*------------------------ ж ------------------------*/
#pragma section const INT_VECTOR  0xffc2
void * const IntTbl1[] = {  
    OnlyReti,           /* 0xffc2 : IntTCC0T*/
    OnlyReti,           /* 0xffc4 : IntTCC0P*/
    OnlyReti,           /* 0xffc6 : IntEMG0*/
    OnlyReti,           /* 0xffc8 : Reserved*/
    OnlyReti,           /* 0xffca : Reserved*/
    OnlyReti,           /* 0xffcc : IntTC03 */
    OnlyReti,           /* 0xffce : IntTC02 */
    OnlyReti,           /* 0xffd0 : Reserved */
    OnlyReti,           /* 0xffd2 : Reserved */
    OnlyReti,           /* 0xffd4 : Reserved */	
    OnlyReti,           /* 0xffd6 : Reserved */
    OnlyReti,           /* 0xffd8 : Reserved */
    OnlyReti,           /* 0xffda : Int2 */ //only for MQ6902_32 Pin Package.
    OnlyReti,           /* 0xffdc : Int1 */
    OnlyReti,           /* 0xffde : Int0 */
    OnlyReti,           /* 0xffe0 : IntSBI0_SIO0 */
    OnlyReti,           /* 0xffe2 : IntTCA0  */
    OnlyReti,           /* 0xffe4 : IntTC01 */
    OnlyReti,           /* 0xffe6 : IntTC00 */
    OnlyReti,           /* 0xffe8 : IntRTC */
    OnlyReti,           /* 0xffea : IntADC */
    OnlyReti,           /* 0xffec : IntVLTD */
    OnlyReti,           /* 0xffee : Int5 */
    OnlyReti,           /* 0xfff0 : IntTXD0 */
    OnlyReti,           /* 0xfff2 : IntRXD0_SIO0 */
    OnlyReti,           /* 0xfff4 : IntTBT */
    OnlyReti,           /* 0xfff6 : IntWUC */
    IntWDT,             /* 0xfff8 : IntWDT */
    (void *)0xffff,     /* 0xfffa : Reserved */
    IntSWI,             /* 0xfffc : IntSWI/INTUNDEF */     
    STARTUP             /* 0xfffe : RESET */					
};
#pragma section const
/*-------------------  ж ------------------------*/

















//*********************************************************************
//    : System_Init(void)
//  : IO, CGCR ʼ P10/P40/P41 ڷʱ֮趨
// ע     :
//*********************************************************************
void System_Init(void)
{

//=============================================================================
//  Set CGCR
//=============================================================================
//  ============================================
//  پƵãCGCR                                  fc   =  8MHz
//  ============================================
    CGCR_FCGCKSEL = 0x00;           // (ϵͳ Clock) fcgck = fc/4 =  2Mhz(ϵͳĬ)
//  CGCR_FCGCKSEL = 0x01;           // (ϵͳ Clock) fcgck = fc/2 =  4Mhz
//  CGCR_FCGCKSEL = 0x02;           // (ϵͳ Clock) fcgck = fc   =  8Mhz
//  CGCR_FCGCKSEL = 0x03;           // (Reserved)
//  ============================================
//  *** 벻Ҫڵģʽ(SLOW1/SLOW2) ı CGCR<FCGCKSEL> Ĵֵ
//  ============================================


#ifdef _DEBUG   //...  _DEBUG(ģʽ): ڷ ev board
//------------------------------------------------------------------
//  (ϵͳĬ): ʱP10趨ΪReset PinԱӰ漰¼.
//  SET_P10_RESET_PIN;
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ) P10(RESET) λΪһ IO 
//------------------------------------------------------------------
//-- P10趨ΪһIO ------
    SET_P10_IO_PIN;
//------------------------------------------------------------------
#endif



//-- ʼ IO  (λ)------
#ifdef _DEBUG   //...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//   P10/P40/P41  Debug modeڷʱ趨Ϊ룬
//  ԱӰ漰¼.
    P1DR = 0x00;
    P1CR = set8bit(11111110);           //  P10 Ϊ
    P4DR = 0x00;
    P4CR = set8bit(11111100);           //  P40/P41 Ϊ
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;
//------------------------------------------------------------------
#endif

//-- ʼ IO  ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//  P4DR = 0x00;
//  P4CR = 0xff;
    P7DR = 0x00;
    P7CR = 0xff;
    P8DR = 0x00;
    P8CR = 0xff; 
    CLR_WDT;                            // Źʱ (ι)

}



//*********************************************************************
//    :
//  : ʱ
// ע     : ==> t_1ms   = 0;          // ӳʱ䵥λ ms
//          : ==> t_100us = 1;          // ӳʱ䵥λ usϴ
//          : ɹ̶Ȧʱһʱ䣬ʹ÷£
//          : Delay_Times(t_1ms, 800);  // ӳ 800ms
//*********************************************************************
void Delay_Times(uchar tBase, uint x)
{
    uint  i, cgcrT;

    uchar cgcrF[4]={ 2, 4,  8, 1 };     // پƵΪ  8MHz ʱʹô
//  uchar cgcrF[4]={ 4, 8, 16, 2 };     // پƵΪ 16MHz ʱʹô

//  ϵͳڸʱ(ͨ1ͨ2ģʽ) ʱ
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  ϵͳڵʱ(12ģʽ) ʱϴ󣬲οʹã
    else for(; x>0; x--){}

    CLR_WDT;                            // Źʱ (ι)
}














