//******************************************
//  : main
// 汾     : V1.0
//      : 
// ע     : FLASH 洢
//******************************************
#ifndef IO_MEM
#define IO_MEM
#endif

#include "main.h"


//==============================================================================
// ¶巽ʽɽ 0x8000~0xffff(ռóռ) ڷóʼֵ
// עconst uchar code_flash[0x400]     ռռС 1KBַ0xe000~0xe3ff
//     const uchar code_flash_128B[0x80] ռռС 128Bַ0xf000~0xf07f
//==============================================================================
#pragma section const code_flash 0xE000
const uchar code_flash[0x400] = {
    0X12, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X99
    };
#pragma section const
#pragma section const code_flash_128B 0xF000
const uchar code_flash_128B[0x80] = {
    0X12, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X99
    };
#pragma section const

//==============================================================================

uchar readData;
uchar readBuf[0x80];
extern void * const  IntSWI_In_Flash_Start ;  // Label, "void __interrupt_n IntSWI(void)" 
extern void * const  IntSWI_In_Flash_End ;	   // Label, "void __interrupt_n IntSWI(void)" 
void* pfnSecErase;                             // λSRAMϵFlash section erase ַ

/* ----------------------  -------------------------- */
void main(){
	unsigned int* pDst;
	unsigned int* pSrc;
	unsigned int vectorAddr,sramMapStart,sramMapTmp,sramMapEnd;
	unsigned int copyLength,tmpLength;	
	void * foo;
	unsigned char c1=1,c2=2,c3=5;

    /* ---------------------- ϵͳʼ ------------------------ */
    System_Init();

	
    /* ---------------------- ܳʼ ------------------- */

	// ʹںʽǰ(Flash_SectionErase(...))
	// жжϴʽʽSRAMС	
	
	// 1. INTSWIжϴʽSRAM
	//    ( Flash_SectionErase(...) ʽУпжϺʱرտŹ
	//     ֻ账INTSWI                                                   )
	sramMapStart         = 0x400;
	pDst                 = (uint *)sramMapStart;
	pSrc                 = (uint *)(&IntSWI_In_Flash_Start);
	copyLength           = (uint)(&IntSWI_In_Flash_End)-(uint)(&IntSWI_In_Flash_Start); 
	vectorAddr           = 0xfffc;	
	MapINTtoSRAM( pDst, pSrc, copyLength, vectorAddr);	
	
	
	// 2. ʽSRAM
	sramMapTmp           = sramMapStart + copyLength;
	pfnSecErase          = (void *)sramMapTmp;	
	tmpLength            = MapEraseSecFunctoSRAM( pfnSecErase);
	sramMapEnd           = sramMapTmp + tmpLength;
	
	// ɺSRAMַ 0x01fc         ~   0x01fd     INTSWIж
	//                  sramMapStart   ~   sramMapEnd INTSWIжϺʽʽ
	
//==============================================================================
//  0x8000~0xffff(ռóռ)
//==============================================================================

//******  ******
// õַ ( 1024 Byte Ϊλ)
    Flash_SectionErase(pfnSecErase,0xe000,SIZE_1KB); // 0xe000~0xe3ff	
    NOP;                                // ָ
    NOP;                                // ָ

//****** д뺯 ******
// ע: дǰ횴_ԓַ֮Ѳ
    Flash_WriteByte(0xe003, 0x26);
    NOP;                                // ָ
    NOP;                                // ָ

//****** ȡ ******
    readData = Flash_ReadByte(0xe003);
    NOP;                                // ָ
    NOP;                                // ָ

//****** д뺯 ******
// ע: дǰ횴_ԓַ֮Ѳ
    Flash_WriteByte(0xe403, 0x62);
    NOP;                                // ָ
    NOP;                                // ָ

//****** ȡ ******
    readData = Flash_ReadByte(0xe403);
    NOP;                                // ָ
    NOP;                                // ָ

//****** ȡ ******
    Flash_ReadSequence(0xe403, readBuf, 1);
    NOP;                                // ָ
    NOP;                                // ָ

//******  ******
// õַ ( 1024 Byte Ϊλ)
    Flash_SectionErase(pfnSecErase,0xe403,SIZE_1KB); // 0xe400~0xe7ff
    NOP;                                // ָ
    NOP;                                // ָ

//****** ȡ ******
    readData = Flash_ReadByte(0xe403);
    NOP;                                // ָ
    NOP;                                // ָ
	
//******  ******
// õַ ( 128 Byte Ϊλ)
	Flash_SectionErase(pfnSecErase,0xf000,SIZE_128B); // 0xf000~0xf07f
    NOP;                                // ָ
    NOP;                                // ָ		

//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    while(1)
    {
        CLR_WDT;                        // Źʱ (ι)

        NOP;                            // ָ
        NOP;                            // ָ
        NOP;                            // ָ
    }
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}


















/*---------------------- жϷ ------------------------*/
void __interrupt OnlyReti(void)
{
    NOP;                                // ָ
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntWDT(void)
{

    NOP;                                // ָ
}

__ASM("_IntSWI_In_Flash_Start:");
__ASM("Public _IntSWI_In_Flash_Start");
void __interrupt_n IntSWI(void)
{    
    SYSCR2 = 0x10;                      // system clock reset    
}
__ASM("_IntSWI_In_Flash_End:");
__ASM("Public _IntSWI_In_Flash_End");



/*-----------------  жϷ ------------------------*/

// -------------------- MQ6902 ж ----------------------
//  [ ж ] Ҫжид
//  1. ʹ֮߳жж֮OnlyRetiΪӦж
//  2. ӦڵַжƣֱӸ
//
//  ʹⲿж2ӦжϱеOnlyRetiΪ Int2
//   Int2,                /* 0xffda : Int2*/  (ⲿж2)
// ----------------------------------------------------------------
/*------------------------ ж ------------------------*/
#pragma section const INT_VECTOR  0xffc2
void * const IntTbl1[] = {  
    OnlyReti,           /* 0xffc2 : IntTCC0T*/
    OnlyReti,           /* 0xffc4 : IntTCC0P*/
    OnlyReti,           /* 0xffc6 : IntEMG0*/
    OnlyReti,           /* 0xffc8 : Reserved*/
    OnlyReti,           /* 0xffca : Reserved*/
    OnlyReti,           /* 0xffcc : IntTC03 */
    OnlyReti,           /* 0xffce : IntTC02 */
    OnlyReti,           /* 0xffd0 : Reserved */
    OnlyReti,           /* 0xffd2 : Reserved */
    OnlyReti,           /* 0xffd4 : Reserved */	
    OnlyReti,           /* 0xffd6 : Reserved */
    OnlyReti,           /* 0xffd8 : Reserved */
    OnlyReti,           /* 0xffda : Int2 */ //only for MQ6902_32 Pin Package.
    OnlyReti,           /* 0xffdc : Int1 */
    OnlyReti,           /* 0xffde : Int0 */
    OnlyReti,           /* 0xffe0 : IntSBI0_SIO0 */
    OnlyReti,           /* 0xffe2 : IntTCA0  */
    OnlyReti,           /* 0xffe4 : IntTC01 */
    OnlyReti,           /* 0xffe6 : IntTC00 */
    OnlyReti,           /* 0xffe8 : IntRTC */
    OnlyReti,           /* 0xffea : IntADC */
    OnlyReti,           /* 0xffec : IntVLTD */
    OnlyReti,           /* 0xffee : Int5 */
    OnlyReti,           /* 0xfff0 : IntTXD0 */
    OnlyReti,           /* 0xfff2 : IntRXD0_SIO0 */
    OnlyReti,           /* 0xfff4 : IntTBT */
    OnlyReti,           /* 0xfff6 : IntWUC */
    IntWDT,             /* 0xfff8 : IntWDT */
    (void *)0xffff,     /* 0xfffa : Reserved */
    IntSWI,             /* 0xfffc : IntSWI/INTUNDEF */     
    STARTUP             /* 0xfffe : RESET */					
};
#pragma section const
/*-------------------  ж ------------------------*/









//*********************************************************************
//    : System_Init(void)
//  : IO, CGCR ʼ P10/P40/P41 ڷʱ֮趨
// ע     :
//*********************************************************************
void System_Init(void)
{

//=============================================================================
//  Set CGCR
//=============================================================================
//  ============================================
//  پƵãCGCR                                  fc   =  8MHz
//  ============================================
    CGCR_FCGCKSEL = 0x00;           // (ϵͳ Clock) fcgck = fc/4 =  2Mhz(ϵͳĬ)
//  CGCR_FCGCKSEL = 0x01;           // (ϵͳ Clock) fcgck = fc/2 =  4Mhz
//  CGCR_FCGCKSEL = 0x02;           // (ϵͳ Clock) fcgck = fc   =  8Mhz
//  CGCR_FCGCKSEL = 0x03;           // (Reserved)
//  ============================================
//  *** 벻Ҫڵģʽ(SLOW1/SLOW2) ı CGCR<FCGCKSEL> Ĵֵ
//  ============================================

#ifdef _DEBUG   //...  _DEBUG(ģʽ): ڷ ev board
//------------------------------------------------------------------
//  (ϵͳĬ): ʱP10趨ΪReset PinԱӰ漰¼.
//  SET_P10_RESET_PIN;
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ) P10(RESET) λΪһ IO 
//------------------------------------------------------------------
//-- P10趨ΪһIO ------
    SET_P10_IO_PIN;
//------------------------------------------------------------------
#endif



//-- ʼ IO  (λ)------
#ifdef _DEBUG   //...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//   P10/P40/P41  Debug modeڷʱ趨Ϊ룬
//  ԱӰ漰¼.
    P1DR = 0x00;
    P1CR = set8bit(11111110);           //  P10 Ϊ
    P4DR = 0x00;
    P4CR = set8bit(11111100);           //  P40/P41 Ϊ
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;
//------------------------------------------------------------------
#endif

//-- ʼ IO  ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//  P4DR = 0x00;
//  P4CR = 0xff;    
    P7DR = 0x00;
    P7CR = 0xff;
    P8DR = 0x00;
    P8CR = 0xff; 
    CLR_WDT;                            // Źʱ (ι)




}



//*********************************************************************
//    :
//  : ʱ
// ע     : ==> t_1ms   = 0;          // ӳʱ䵥λ ms
//          : ==> t_100us = 1;          // ӳʱ䵥λ usϴ
//          : ɹ̶Ȧʱһʱ䣬ʹ÷£
//          : Delay_Times(t_1ms, 800);  // ӳ 800ms
//*********************************************************************
void Delay_Times(uchar tBase, uint x)
{
    uint  i, cgcrT;

    uchar cgcrF[4]={ 2, 4,  8, 1 };     // پƵΪ  8MHz ʱʹô
//  uchar cgcrF[4]={ 4, 8, 16, 2 };     // پƵΪ 16MHz ʱʹô

//  ϵͳڸʱ(ͨ1ͨ2ģʽ) ʱ
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  ϵͳڵʱ(12ģʽ) ʱϴ󣬲οʹã
    else for(; x>0; x--){}

    CLR_WDT;                            // Źʱ (ι)
}










