//******************************************
//  :
// 汾     :
//      :
// ע     :
//******************************************

#include "main.h"
#include "string.h"


extern void * const  BTEraseSec;
extern void * const  BTEraseSecEnd; 


#pragma asm
FLSCR1	EQU	0x0FD0
FLSCR2	EQU	0x0FD1
WDCTR	EQU 0x0FD4
WDCDR	EQU 0x0FD5
SYSCR3  EQU 0x0FDE
SYSCR4  EQU 0x0FDF

#pragma endasm

//*********************************************************************
//    : MapINTtoSRAM
//  : жжϴʽSRAM
// ע     :
//*********************************************************************
void  MapINTtoSRAM( uint* pDst, const uint* pSrc,uint num,uint vectorAddr){
	unsigned int vectorAddrInSRAM;
	vectorAddrInSRAM = vectorAddr & 0x01FF;
	// ж ffxxh(Flash)  1xxh(SRAM)
	memcpy( (unsigned int*)vectorAddrInSRAM,(const unsigned int*)vectorAddr,2);
	
	// жϴʽ Flash  SRAM
	memcpy( pDst,pSrc,num);
	

}

//*********************************************************************
//    : MapEraseSecFunctoSRAM
//  : ʽSRAM
// ע     : BTEraseSec,BTEraseSecEnd ļײǶ
//*********************************************************************
uint MapEraseSecFunctoSRAM(uint* pDst){
	// ʽ Flash  SRAM	     
	memcpy( pDst,&BTEraseSec, (uint)(&BTEraseSecEnd)-(uint)(&BTEraseSec));
	// شSize
	return (uint)(&BTEraseSecEnd)-(uint)(&BTEraseSec);
}

//*********************************************************************
//    : Flash_WriteByte
//  : д 1 byte  data  addr ĵַ
// ע     : 
//*********************************************************************
void __adecl Flash_WriteByte(uint addr, uchar data) 
{
	#pragma ASM
	;--WA=addr, C=data while used "__adecl" qualifier

	;--Backup contents
	PUSH 	B
	PUSH	DE	
	PUSH 	IX			
	
	;--store IMF
	LD		SP,SP-1
	LD		CF,(0x3A).0
	LD		(SP+0x01).0,CF
	
	;--Show BOOTROM
	SET 	(FLSCR1).4
	LD  	(FLSCR2),0xd5	
	
	;--((uchar __adecl(*)(uint,uchar,uchar,uchar))(*(void**)0x1010)  )(addr,0x0,data,0xd5);
	LD 		B,C
	LD 		(SP-),0xd5
	LD		DE,0x1010
	LD		IX,(DE)	
	LD 		C,0x00
	LD 		E,B
	CALL	IX							; Call .BTWrite
	
    ;--Hide BOOTROM
	CLR 	(FLSCR1).4
	LD  	(FLSCR2),0xd5	

	;--Restore IMF
	LD		CF,(SP+0x1).0
	LD		(0x3A).0,CF
	LD		SP,SP+1
	
	;--Restore contents	
	POP 	IX	
	POP 	DE
	POP 	B
	#pragma ENDASM
}


//*********************************************************************
//    : Flash_ReadByte
//  : ַָ addr ȡϺش
// ע     :
//*********************************************************************
uchar Flash_ReadByte(uint addr)
{
    return *((uchar *)addr);
}


//*********************************************************************
//    : Flash_ReadSequence
//  :  addr ַʼȡ FLASH ָ length ϣ data 
// ע     :
//*********************************************************************
void Flash_ReadSequence(uint addr, uchar* data, uint length)
{
    uchar *p_addr = (uchar *)addr;
    uint  i;
    for( i=0; i<length; i++ )
    {
        data[i] = *(p_addr + i);
        CLR_WDT;                        // Źʱ (ι)
    }
}




//*********************************************************************
//    : Flash_SectionErase
//  :  addr ַڵ sectionϵͳжϵַ section ڵ (1024 byte)
// ע     : <addr>
//          :   ĵַ˵ַ section (1024 byte)
//          : :
//          :    addr = 0xe000  section: 0xe000 ~ 0xe3ff  0xe000  ϵͳ 0xe000 ~ 0xe3ff  (1024 bytes)
//          :    addr = 0xee99  section: 0xec00 ~ 0xefff  0xee99  ϵͳ 0xec00 ~ 0xefff  (1024 bytes)
//          :    addr = 0xeeff  section: 0xec00 ~ 0xefff  0xeeff  ϵͳ 0xec00 ~ 0xefff  (1024 bytes)
//          :    addr = 0xf000  section: 0xf000 ~ 0xf3ff  0xf000  ϵͳ 0xf000 ~ 0xf3ff  (1024 bytes)
//*********************************************************************
void __adecl Flash_SectionErase(void* functionAddr,uint addr,uchar size)
{	
	#pragma ASM
	;--WA=functionAddr, BC=addr , E=size while used "__adecl" qualifier

	;--Backup contents	
	PUSH	D	
	PUSH 	IX		
	
	;--store IMF,WDT
	LD		SP,SP-2				
	LD		CF,(0x3A).0
	LD		(SP+0x02).0,CF
	CLR		(0x3A).0
	ld		IX,WDCTR
	ld		D,(IX)
	ld		(SP+0x1),D
	clr		(IX).5
	ld		(WDCDR),0xb1	
	
	;--MAP SRAM to Program Area
	ld		IX,SYSCR3
	set		(IX).2
	set		(IX).1
	ld		(SYSCR4),0xd4	
	
	;--((uchar __adecl(*)(uchar, uchar))functionAddr )(eraseSection,0xd5,size);	
	ld		IX,WA
	LD  	WA,BC
	LD  	C,0xd5	
	CALL 	IX
	
	;--UNMAP SRAM to Program Area
	ld		IX,SYSCR3
	clr		(IX).2
	clr		(IX).1
	ld		(SYSCR4),0xd4	
	
	;--Restore IMF,WDT
	LD		CF,(SP+0x2).0
	LD		(0x3A).0,CF
	LD		A,(SP+0x1)
	ld		(WDCTR),A
	LD		SP,SP+2
	
	;--Restore contents	
	POP 	IX	
	POP 	D
	#pragma ENDASM	
}

#pragma asm

ADR_CMD_SEQ_1	equ	0xF555
ADR_CMD_SEQ_2	equ	0xFAAA
ADR_CMD_SEQ_3	equ	0xF555
ADR_CMD_SEQ_4	equ	0xF555
ADR_CMD_SEQ_5	equ	0xFAAA
;/////////////////////////////////////////////////////////////////////
;//	Module name	    : BTEraseSec
;//	Function	    : erase FLASH 1 section (1024 Bytes)
;//	Register In	    : WA  Specified section 
;//			        : C	  FLSCR2 command(0xD5);
;//                 : E   Select 1KB, 128B
;//	Register OUT	: A	  Result flag :FF=OK  others=fail
;//	Register WORK	: WA, BC , DE , IX 
;/////////////////////////////////////////////////////////////////////
;---------------------------------------------------------------------
public	_BTEraseSec
_BTEraseSec:
	di	
	; == Enable Flash Command
	ld	 B, (FLSCR1)	
	and	 B, 0x1F		
	or	 B, 0xA0		
	ld	(FLSCR1), B
	ld	(FLSCR2), C		
	; ====	
	
	ld	IX,WA
	
	; --- Section erase sequence
	ld	(ADR_CMD_SEQ_1), 0xAA
	ld	(ADR_CMD_SEQ_2), 0x55
	ld	(ADR_CMD_SEQ_3), 0x80
	ld	(ADR_CMD_SEQ_4), 0xAA
	ld	(ADR_CMD_SEQ_5), 0x55
	ld	(IX), E
	nop
	nop
	nop	
	ld	W, (IX)
	cmp	W, (IX)		
	j	ne, lTglChkEraseSec
	ld	A, 0
	j	lEraseSecEnd
	
lTglChkEraseSec:
lpWaitToggle:
	ld	W, (IX)
	cmp	W, (IX)
	j	ne, lpWaitToggle
	
	ld	A, W		

lEraseSecEnd:
	; == Disable Flash Command	
	ld	W, (FLSCR1)	
	and	W, 0x1F		
	or	W, 0x40		
	ld	(FLSCR1), W		
	ld	(FLSCR2), 0xD5	
	

	; == FAREA clear
	and	(FLSCR1), 0xf3	
	ld	(FLSCR2), 0xD5	
	; ====
	
	
	ret
public	_BTEraseSecEnd
_BTEraseSecEnd:
#pragma endasm


















