//******************************************
//  : MQ6902_ADC
// 汾     : V 1.00
//      : 
// ע     :
//******************************************

#include "main.h"



uint  vref_l, vref_h, iReal_Vref2V, ADC_Code_READ;


//*********************************************************************
//    : ADC_Init
//  : OIO,AIN,늉,ģʽ
// ע     :
//*********************************************************************
void ADC_Init()
{
    P4FC_P4 = 1;
    P4CR_P4 = 0;
//====== 趨 ======    
    ADCCR1_SAIN     = AIN4;             // 趨 SAINѡ AD תģźͨ
    ADCCR1_AINEN    = 1;                // 趨ģź AINEN Ϊ"ģź"
    ADCCR1_AMD      = ADC_REPEAT;       // 趨 AMDѡ AD תģʽΪλظģʽ
    ADCCR2_ACK      = CONV256CLK;       // 趨 AD תʱ
}


//*********************************************************************
//    : ADC_Start
//  :  ADC
// ע     :
//*********************************************************************
void ADC_Start(void)
{
    ADCCR1_ADRS = 1;                    //  AD ת
}


//*********************************************************************
//    : ADC_Stop
//  : ֹͣ ADC
// ע     :
//*********************************************************************
void ADC_Stop(void)
{
    ADCCR1_AMD = 0;                     // 0: ֹ AD ǿ AD ֹͣ
}


//*********************************************************************
//    : ADC_IntEnable
//  : ADCж
// ע     : ִкῪж(IMF)
//*********************************************************************
void ADC_IntEnable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    IL_INTADC = 0;                      // ж
    EI_INTADC = 1;                      // 趨ж
    EI;                                 // пж // EIRL_IMF=1
}


//*********************************************************************
//    : ADC_IntDisable
//  : ֹADCж
// ע     : ִкῪж(IMF)
//*********************************************************************
void ADC_IntDisable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    EI_INTADC = 0;                      // ж
	IL_INTADC = 0;                      // ж    
    EI;                                 // пж // EIRL_IMF=1
}


//*********************************************************************
//    : ADC_SingleDetect
//  : ADC ģʽȡ
// ע     :
//*********************************************************************
uint ADC_SingleDetect(uchar SAIN)
{
    BIT_LIST_16 ADC_READ;

//====== Oģźͨ ======
    ADCCR1_SAIN = SAIN;                 // 1. 趨 SAINѡ AD תģźͨ

    ADCCR1_ADRS = 1;                    //  AD ת
    while(  ADCCR2_ADBF ){ CLR_WDT; }   // 1: AD תС
    while( !ADCCR2_EOCF ){ CLR_WDT; }   // 1: AD תɣ 0: AD תǰת

    ADC_READ.byte[0] = ADCDRL;          // ȡ ADC ֵȶ Low Byte, ٶ High Byte
    ADC_READ.byte[1] = ADCDRH;          // ȡ ADC ֵȶ Low Byte, ٶ High Byte


	return ADC_READ.word;
}


//*********************************************************************
//    : ADC_RepeatDetect
//  : ADC ظģʽȡ
// ע     :
//*********************************************************************
uint ADC_RepeatDetect(uchar SAIN)
{
    uchar i;
    ulong adc_data = 0;
    uint  ad_max = 0, ad_min = 1024;
    BIT_LIST_16 ADC_READ;

//====== Oģźͨ ======
    ADCCR1_SAIN = SAIN;                 // 1. 趨 SAINѡ AD תģźͨ

    ADCCR1_ADRS = 1;                    //  AD ת
    for( i=0; i<(AD_TIMES+2); i++ )
    {
        while( !ADCCR2_EOCF ){ CLR_WDT; } // 1: AD תɣ 0: AD תǰת
        ADC_READ.byte[0] = ADCDRL;      // ȡ ADC ֵȶ Low Byte, ٶ High Byte
        ADC_READ.byte[1] = ADCDRH;      // ȡ ADC ֵȶ Low Byte, ٶ High Byte
        adc_data += ADC_READ.word;
        if( ADC_READ.word > ad_max ) ad_max = ADC_READ.word;
        if( ADC_READ.word < ad_min ) ad_min = ADC_READ.word;
    }
    ADCCR1_ADRS = 0;                    // ֹͣ AD ת

    adc_data -= ad_max;                 // ȥֵ
    adc_data -= ad_min;                 // ȥСֵ
    adc_data /= AD_TIMES;

	return (uint)adc_data;
}



//*********************************************************************
//    : IntADC
//  : жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntADC(void)
{
    NOP;                                // ָ
}




























